/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.actions.ChooseRunConfigurationPopup;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindowId;

public class ChooseRunConfigurationPopupAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project2 != null);
        new ChooseRunConfigurationPopup(project2, this.getAdKey(), this.getDefaultExecutor(), this.getAlternativeExecutor()).show();
    }

    protected Executor getDefaultExecutor() {
        return DefaultRunExecutor.getRunExecutorInstance();
    }

    protected Executor getAlternativeExecutor() {
        return ExecutorRegistry.getInstance().getExecutorById(ToolWindowId.DEBUG);
    }

    protected String getAdKey() {
        return "run.configuration.alternate.action.ad";
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        presentation.setEnabled(true);
        if (project2 == null || project2.isDisposed()) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        if (null == this.getDefaultExecutor()) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        presentation.setEnabled(true);
        presentation.setVisible(true);
    }

    public boolean isDumbAware() {
        return Registry.is((String)"dumb.aware.run.configurations");
    }
}

