/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.testframework.TestFrameworkPropertyListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.StoringPropertyContainer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import com.intellij.util.config.DumbAwareToggleBooleanProperty;
import com.intellij.util.config.Storage;
import com.intellij.util.config.ToggleBooleanProperty;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestConsoleProperties
extends StoringPropertyContainer
implements Disposable {
    public static final BooleanProperty SCROLL_TO_STACK_TRACE = new BooleanProperty("scrollToStackTrace", false);
    public static final BooleanProperty SORT_ALPHABETICALLY = new BooleanProperty("sortTestsAlphabetically", false);
    public static final BooleanProperty SORT_BY_DURATION = new BooleanProperty("sortTestsByDuration", false);
    public static final BooleanProperty SELECT_FIRST_DEFECT = new BooleanProperty("selectFirtsDefect", false);
    public static final BooleanProperty TRACK_RUNNING_TEST = new BooleanProperty("trackRunningTest", true);
    public static final BooleanProperty HIDE_IGNORED_TEST = new BooleanProperty("hideIgnoredTests", false);
    public static final BooleanProperty HIDE_PASSED_TESTS = new BooleanProperty("hidePassedTests", true);
    public static final BooleanProperty SCROLL_TO_SOURCE = new BooleanProperty("scrollToSource", false);
    public static final BooleanProperty OPEN_FAILURE_LINE = new BooleanProperty("openFailureLine", true);
    public static final BooleanProperty TRACK_CODE_COVERAGE = new BooleanProperty("trackCodeCoverage", false);
    public static final BooleanProperty SHOW_STATISTICS = new BooleanProperty("showStatistics", false);
    public static final BooleanProperty SHOW_INLINE_STATISTICS = new BooleanProperty("showInlineStatistics", true);
    public static final BooleanProperty INCLUDE_NON_STARTED_IN_RERUN_FAILED = new BooleanProperty("includeNonStarted", true);
    public static final BooleanProperty HIDE_SUCCESSFUL_CONFIG = new BooleanProperty("hideConfig", false);
    private final Project myProject;
    private final Executor myExecutor;
    private ConsoleView myConsole;
    private boolean myUsePredefinedMessageFilter;
    private GlobalSearchScope myScope;
    protected final Map<AbstractProperty, List<TestFrameworkPropertyListener>> myListeners;

    public TestConsoleProperties(@NotNull Storage storage2, Project project2, Executor executor) {
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/execution/testframework/TestConsoleProperties", "<init>"));
        }
        super(storage2);
        this.myUsePredefinedMessageFilter = true;
        this.myListeners = ContainerUtil.newHashMap();
        this.myProject = project2;
        this.myExecutor = executor;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public GlobalSearchScope getScope() {
        if (this.myScope == null) {
            this.myScope = this.initScope();
        }
        GlobalSearchScope globalSearchScope = this.myScope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/TestConsoleProperties", "getScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    protected GlobalSearchScope initScope() {
        RunProfile configuration = this.getConfiguration();
        if (!(configuration instanceof ModuleRunProfile)) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myProject);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/TestConsoleProperties", "initScope"));
            }
            return globalSearchScope;
        }
        Module[] modules = ((ModuleRunProfile)configuration).getModules();
        if (modules.length == 0) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myProject);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/TestConsoleProperties", "initScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope scope = GlobalSearchScope.EMPTY_SCOPE;
        for (Module each : modules) {
            scope = scope.uniteWith(GlobalSearchScope.moduleRuntimeScope((Module)each, (boolean)true));
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/TestConsoleProperties", "initScope"));
        }
        return globalSearchScope;
    }

    public <T> void addListener(@NotNull AbstractProperty<T> property, @NotNull TestFrameworkPropertyListener<T> listener2) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/execution/testframework/TestConsoleProperties", "addListener"));
        }
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/execution/testframework/TestConsoleProperties", "addListener"));
        }
        ArrayList listeners = this.myListeners.get(property);
        if (listeners == null) {
            listeners = ContainerUtil.newArrayList();
            this.myListeners.put(property, listeners);
        }
        listeners.add(listener2);
    }

    public <T> void addListenerAndSendValue(@NotNull AbstractProperty<T> property, @NotNull TestFrameworkPropertyListener<T> listener2) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/execution/testframework/TestConsoleProperties", "addListenerAndSendValue"));
        }
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/execution/testframework/TestConsoleProperties", "addListenerAndSendValue"));
        }
        this.addListener(property, listener2);
        listener2.onChanged(property.get((AbstractProperty.AbstractPropertyContainer)this));
    }

    public <T> void removeListener(@NotNull AbstractProperty<T> property, @NotNull TestFrameworkPropertyListener listener2) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/execution/testframework/TestConsoleProperties", "removeListener"));
        }
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/execution/testframework/TestConsoleProperties", "removeListener"));
        }
        List<TestFrameworkPropertyListener> listeners = this.myListeners.get(property);
        if (listeners != null) {
            listeners.remove(listener2);
        }
    }

    public Executor getExecutor() {
        return this.myExecutor;
    }

    public boolean isDebug() {
        return this.myExecutor.getId() == DefaultDebugExecutor.EXECUTOR_ID;
    }

    public boolean isPaused() {
        XDebugSession debuggerSession = XDebuggerManager.getInstance((Project)this.myProject).getDebugSession(this.getConsole());
        return debuggerSession != null && debuggerSession.isPaused();
    }

    @Override
    protected <T> void onPropertyChanged(@NotNull AbstractProperty<T> property, T value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/execution/testframework/TestConsoleProperties", "onPropertyChanged"));
        }
        List<TestFrameworkPropertyListener> listeners = this.myListeners.get(property);
        if (listeners != null) {
            for (Object o : listeners.toArray()) {
                TestFrameworkPropertyListener listener2 = (TestFrameworkPropertyListener)o;
                listener2.onChanged(value);
            }
        }
    }

    public void setConsole(ConsoleView console) {
        this.myConsole = console;
    }

    public void dispose() {
        this.myListeners.clear();
    }

    public abstract RunProfile getConfiguration();

    public boolean isEditable() {
        return false;
    }

    protected ExecutionConsole getConsole() {
        return this.myConsole;
    }

    public boolean isUsePredefinedMessageFilter() {
        return this.myUsePredefinedMessageFilter;
    }

    public void setUsePredefinedMessageFilter(boolean usePredefinedMessageFilter) {
        this.myUsePredefinedMessageFilter = usePredefinedMessageFilter;
    }

    public void appendAdditionalActions(DefaultActionGroup actionGroup, JComponent parent, TestConsoleProperties target) {
    }

    @Nullable
    protected AnAction createImportAction() {
        return null;
    }

    @NotNull
    protected ToggleBooleanProperty createIncludeNonStartedInRerun(TestConsoleProperties target) {
        String text = ExecutionBundle.message((String)"junit.runing.info.include.non.started.in.rerun.failed.action.name", (Object[])new Object[0]);
        DumbAwareToggleBooleanProperty dumbAwareToggleBooleanProperty = new DumbAwareToggleBooleanProperty(text, null, null, (AbstractProperty.AbstractPropertyContainer)target, INCLUDE_NON_STARTED_IN_RERUN_FAILED);
        if (dumbAwareToggleBooleanProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/TestConsoleProperties", "createIncludeNonStartedInRerun"));
        }
        return dumbAwareToggleBooleanProperty;
    }

    @NotNull
    protected ToggleBooleanProperty createHideSuccessfulConfig(TestConsoleProperties target) {
        String text = ExecutionBundle.message((String)"junit.runing.info.hide.successful.config.action.name", (Object[])new Object[0]);
        this.setIfUndefined((AbstractProperty<Boolean>)HIDE_SUCCESSFUL_CONFIG, true);
        DumbAwareToggleBooleanProperty dumbAwareToggleBooleanProperty = new DumbAwareToggleBooleanProperty(text, null, null, (AbstractProperty.AbstractPropertyContainer)target, HIDE_SUCCESSFUL_CONFIG);
        if (dumbAwareToggleBooleanProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/TestConsoleProperties", "createHideSuccessfulConfig"));
        }
        return dumbAwareToggleBooleanProperty;
    }

    @JdkConstants.TreeSelectionMode
    protected int getSelectionMode() {
        return 1;
    }

    @NotNull
    public ExecutionTarget getExecutionTarget() {
        ExecutionTarget executionTarget = DefaultExecutionTarget.INSTANCE;
        if (executionTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/TestConsoleProperties", "getExecutionTarget"));
        }
        return executionTarget;
    }
}

