/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.util.projectWizard.ProjectSettingsStepBase;
import com.intellij.ide.util.projectWizard.actions.ProjectSpecificAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.CustomStepProjectGenerator;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.util.Function;
import com.intellij.util.NullableConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractNewProjectStep
extends DefaultActionGroup
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(AbstractNewProjectStep.class);

    protected AbstractNewProjectStep(@NotNull Customization customization) {
        if (customization == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customization", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep", "<init>"));
        }
        super("Select Project Type", true);
        NullableConsumer<ProjectSettingsStepBase> callback = customization.createCallback();
        ProjectSpecificAction projectSpecificAction = customization.createProjectSpecificAction(callback);
        this.addProjectSpecificAction(projectSpecificAction);
        DirectoryProjectGenerator[] generators = customization.getProjectGenerators();
        customization.setUpBasicAction(projectSpecificAction, generators);
        this.addAll(customization.getActions(generators, callback));
        this.addAll(customization.getExtraActions(callback));
    }

    protected void addProjectSpecificAction(@NotNull ProjectSpecificAction projectSpecificAction) {
        if (projectSpecificAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSpecificAction", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep", "addProjectSpecificAction"));
        }
        this.addAll(projectSpecificAction.getChildren(null));
    }

    public static Project doGenerateProject(@Nullable Project project2, @NotNull String locationString, final @Nullable DirectoryProjectGenerator generator, @NotNull Function<VirtualFile, Object> settingsComputable) {
        String message;
        int rc;
        if (locationString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locationString", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep", "doGenerateProject"));
        }
        if (settingsComputable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsComputable", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep", "doGenerateProject"));
        }
        final File location = new File(FileUtil.toSystemDependentName((String)locationString));
        if (!location.exists() && !location.mkdirs()) {
            String message2 = ActionsBundle.message((String)"action.NewDirectoryProject.cannot.create.dir", (Object[])new Object[]{location.getAbsolutePath()});
            Messages.showErrorDialog((Project)project2, (String)message2, (String)ActionsBundle.message((String)"action.NewDirectoryProject.title", (Object[])new Object[0]));
            return null;
        }
        final VirtualFile baseDir = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(location);
            }
        });
        if (baseDir == null) {
            LOG.error("Couldn't find '" + location + "' in VFS");
            return null;
        }
        baseDir.refresh(false, true);
        if (baseDir.getChildren().length > 0 && (rc = Messages.showYesNoDialog((Project)project2, (String)(message = ActionsBundle.message((String)"action.NewDirectoryProject.not.empty", (Object[])new Object[]{location.getAbsolutePath()})), (String)ActionsBundle.message((String)"action.NewDirectoryProject.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) == 0) {
            return PlatformProjectOpenProcessor.getInstance().doOpenProject(baseDir, null, false);
        }
        String generatorName = generator == null ? "empty" : ConvertUsagesUtil.ensureProperKey(generator.getName());
        UsageTrigger.trigger("AbstractNewProjectStep." + generatorName);
        Object settings = null;
        if (generator != null) {
            try {
                settings = settingsComputable.fun((Object)baseDir);
            }
            catch (ProcessCanceledException e) {
                return null;
            }
        }
        RecentProjectsManager.getInstance().setLastProjectCreationLocation(location.getParent());
        final Object finalSettings = settings;
        return PlatformProjectOpenProcessor.doOpenProject(baseDir, null, false, -1, new ProjectOpenedCallback(){

            public void projectOpened(Project project2, Module module2) {
                if (generator != null) {
                    generator.generateProject(project2, baseDir, finalSettings, module2);
                }
            }
        }, false);
    }

    protected static abstract class AbstractCallback
    implements NullableConsumer<ProjectSettingsStepBase> {
        protected AbstractCallback() {
        }

        public void consume(@Nullable ProjectSettingsStepBase settings) {
            if (settings == null) {
                return;
            }
            Project project2 = ProjectManager.getInstance().getDefaultProject();
            final DirectoryProjectGenerator generator = settings.getProjectGenerator();
            AbstractNewProjectStep.doGenerateProject(project2, settings.getProjectLocation(), generator, new Function<VirtualFile, Object>(){

                public Object fun(VirtualFile file2) {
                    return this.getProjectSettings(generator);
                }
            });
        }

        @Nullable
        protected abstract Object getProjectSettings(@NotNull DirectoryProjectGenerator var1);
    }

    protected static abstract class Customization {
        protected Customization() {
        }

        @NotNull
        protected ProjectSpecificAction createProjectSpecificAction(@NotNull NullableConsumer<ProjectSettingsStepBase> callback) {
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "createProjectSpecificAction"));
            }
            DirectoryProjectGenerator emptyProjectGenerator = this.createEmptyProjectGenerator();
            ProjectSpecificAction projectSpecificAction = new ProjectSpecificAction(emptyProjectGenerator, this.createProjectSpecificSettingsStep(emptyProjectGenerator, callback));
            if (projectSpecificAction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "createProjectSpecificAction"));
            }
            return projectSpecificAction;
        }

        @NotNull
        protected abstract NullableConsumer<ProjectSettingsStepBase> createCallback();

        @NotNull
        protected abstract DirectoryProjectGenerator createEmptyProjectGenerator();

        @NotNull
        protected abstract ProjectSettingsStepBase createProjectSpecificSettingsStep(@NotNull DirectoryProjectGenerator var1, @NotNull NullableConsumer<ProjectSettingsStepBase> var2);

        @NotNull
        protected DirectoryProjectGenerator[] getProjectGenerators() {
            DirectoryProjectGenerator[] directoryProjectGeneratorArray = (DirectoryProjectGenerator[])Extensions.getExtensions(DirectoryProjectGenerator.EP_NAME);
            if (directoryProjectGeneratorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "getProjectGenerators"));
            }
            return directoryProjectGeneratorArray;
        }

        public AnAction[] getActions(@NotNull DirectoryProjectGenerator[] generators, @NotNull NullableConsumer<ProjectSettingsStepBase> callback) {
            if (generators == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generators", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "getActions"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "getActions"));
            }
            ArrayList actions = ContainerUtil.newArrayList();
            for (DirectoryProjectGenerator projectGenerator : generators) {
                actions.addAll(ContainerUtil.list((Object[])this.getActions(projectGenerator, callback)));
            }
            return actions.toArray(new AnAction[actions.size()]);
        }

        @NotNull
        public AnAction[] getActions(@NotNull DirectoryProjectGenerator generator, @NotNull NullableConsumer<ProjectSettingsStepBase> callback) {
            if (generator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "getActions"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "getActions"));
            }
            if (this.shouldIgnore(generator)) {
                if (AnAction.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "getActions"));
                }
                return AnAction.EMPTY_ARRAY;
            }
            ProjectSettingsStepBase step = generator instanceof CustomStepProjectGenerator ? (ProjectSettingsStepBase)((CustomStepProjectGenerator)((Object)generator)).createStep(generator, callback) : this.createProjectSpecificSettingsStep(generator, callback);
            ProjectSpecificAction projectSpecificAction = new ProjectSpecificAction(generator, step);
            AnAction[] anActionArray = projectSpecificAction.getChildren(null);
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "getActions"));
            }
            return anActionArray;
        }

        protected boolean shouldIgnore(@NotNull DirectoryProjectGenerator generator) {
            if (generator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "shouldIgnore"));
            }
            return false;
        }

        @NotNull
        public AnAction[] getExtraActions(@NotNull NullableConsumer<ProjectSettingsStepBase> callback) {
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "getExtraActions"));
            }
            if (AnAction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "getExtraActions"));
            }
            return AnAction.EMPTY_ARRAY;
        }

        public void setUpBasicAction(@NotNull ProjectSpecificAction projectSpecificAction, @NotNull DirectoryProjectGenerator[] generators) {
            if (projectSpecificAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSpecificAction", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "setUpBasicAction"));
            }
            if (generators == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generators", "com/intellij/ide/util/projectWizard/AbstractNewProjectStep$Customization", "setUpBasicAction"));
            }
        }
    }
}

