/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.StripTrailingSpacesLineFilter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiBasedStripTrailingSpacesLineFilter
extends StripTrailingSpacesLineFilter {
    public boolean isStripSpacesAllowed(@Nullable Project project2, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesLineFilter", "isStripSpacesAllowed"));
        }
        return true;
    }

    public final boolean apply(@Nullable Project project2, @NotNull Document document, @NotNull BitSet disabledLinesBitSet) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesLineFilter", "apply"));
        }
        if (disabledLinesBitSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledLinesBitSet", "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesLineFilter", "apply"));
        }
        Language language = PsiBasedStripTrailingSpacesLineFilter.getDocumentLanguage(document);
        if (language != null && this.isApplicableTo(language)) {
            PsiFile psiFile = PsiBasedStripTrailingSpacesLineFilter.getPsiFile(project2, document);
            if (psiFile != null) {
                return this.apply(document, psiFile, disabledLinesBitSet);
            }
            return false;
        }
        return true;
    }

    protected abstract boolean isApplicableTo(@NotNull Language var1);

    protected abstract boolean apply(@NotNull Document var1, @NotNull PsiFile var2, BitSet var3);

    @Nullable
    private static Language getDocumentLanguage(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesLineFilter", "getDocumentLanguage"));
        }
        FileDocumentManager manager = FileDocumentManager.getInstance();
        VirtualFile file2 = manager.getFile(document);
        if (file2 != null && file2.isValid()) {
            return LanguageUtil.getFileLanguage((VirtualFile)file2);
        }
        return null;
    }

    @Nullable
    private static PsiFile getPsiFile(@Nullable Project project2, @NotNull Document document) {
        PsiDocumentManager documentManager;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/PsiBasedStripTrailingSpacesLineFilter", "getPsiFile"));
        }
        if (project2 != null && (documentManager = PsiDocumentManager.getInstance((Project)project2)).isCommitted(document)) {
            return documentManager.getCachedPsiFile(document);
        }
        return null;
    }
}

