/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.bidi.BidiRegionsSeparator;
import com.intellij.openapi.editor.bidi.LanguageBidiRegionsSeparator;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.view.ApproximationFragment;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.IterationState;
import com.intellij.openapi.editor.impl.view.LineFragment;
import com.intellij.openapi.editor.impl.view.TabFragment;
import com.intellij.openapi.editor.impl.view.TextFragmentFactory;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class LineLayout {
    private LineLayout() {
    }

    @NotNull
    static LineLayout create(@NotNull EditorView view, int line, boolean skipBidiLayout) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "create"));
        }
        List<BidiRun> runs = LineLayout.createFragments(view, line, skipBidiLayout);
        LineLayout lineLayout = LineLayout.createLayout(runs);
        if (lineLayout == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/LineLayout", "create"));
        }
        return lineLayout;
    }

    @NotNull
    static LineLayout create(@NotNull EditorView view, @NotNull CharSequence text, @JdkConstants.FontStyle int fontStyle) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "create"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/view/LineLayout", "create"));
        }
        List<BidiRun> runs = LineLayout.createFragments(view, text, fontStyle);
        LineLayout delegate = LineLayout.createLayout(runs);
        WithSize withSize = new WithSize(delegate);
        if (withSize == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/LineLayout", "create"));
        }
        return withSize;
    }

    private static LineLayout createLayout(@NotNull List<BidiRun> runs) {
        BidiRun run;
        if (runs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runs", "com/intellij/openapi/editor/impl/view/LineLayout", "createLayout"));
        }
        if (runs.isEmpty()) {
            return new SingleChunk(null);
        }
        if (runs.size() == 1 && (run = runs.get(0)).level == 0 && run.getChunkCount() == 1) {
            Chunk chunk = run.chunks == null ? new Chunk(0, run.endOffset) : run.chunks[0];
            return new SingleChunk(chunk);
        }
        return new MultiChunk(runs.toArray(new BidiRun[runs.size()]));
    }

    private static void reorderRunsVisually(BidiRun[] bidiRuns) {
        byte[] levels = new byte[bidiRuns.length];
        for (int i = 0; i < bidiRuns.length; ++i) {
            levels[i] = bidiRuns[i].level;
        }
        Bidi.reorderVisually(levels, 0, bidiRuns, 0, levels.length);
    }

    static boolean isBidiLayoutRequired(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/view/LineLayout", "isBidiLayoutRequired"));
        }
        char[] chars = CharArrayUtil.fromSequence((CharSequence)text);
        return Bidi.requiresBidi(chars, 0, chars.length);
    }

    private static List<BidiRun> createFragments(@NotNull EditorView view, int line, boolean skipBidiLayout) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "createFragments"));
        }
        EditorImpl editor = view.getEditor();
        DocumentEx document = editor.getDocument();
        int lineStartOffset = document.getLineStartOffset(line);
        int lineEndOffset = document.getLineEndOffset(line);
        if (lineEndOffset <= lineStartOffset) {
            return Collections.emptyList();
        }
        if (skipBidiLayout) {
            return Collections.singletonList(new BidiRun(lineEndOffset - lineStartOffset));
        }
        CharSequence text = document.getImmutableCharSequence().subSequence(lineStartOffset, lineEndOffset);
        char[] chars = CharArrayUtil.fromSequence((CharSequence)text);
        return LineLayout.createRuns(editor, chars, lineStartOffset);
    }

    private static List<BidiRun> createFragments(@NotNull EditorView view, @NotNull CharSequence text, @JdkConstants.FontStyle int fontStyle) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "createFragments"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/view/LineLayout", "createFragments"));
        }
        if (text.length() == 0) {
            return Collections.emptyList();
        }
        EditorImpl editor = view.getEditor();
        FontRenderContext fontRenderContext = view.getFontRenderContext();
        FontPreferences fontPreferences = editor.getColorsScheme().getFontPreferences();
        char[] chars = CharArrayUtil.fromSequence((CharSequence)text);
        List<BidiRun> runs = LineLayout.createRuns(editor, chars, -1);
        for (BidiRun run : runs) {
            for (Chunk chunk : run.getChunks()) {
                LineLayout.addFragments(run, chunk, chars, chunk.startOffset, chunk.endOffset, fontStyle, fontPreferences, fontRenderContext, null);
            }
        }
        return runs;
    }

    private static List<BidiRun> createRuns(EditorImpl editor, char[] text, int startOffsetInEditor) {
        int textLength = text.length;
        if (editor.myDisableRtl || !Bidi.requiresBidi(text, 0, textLength)) {
            return Collections.singletonList(new BidiRun(textLength));
        }
        ArrayList<BidiRun> runs = new ArrayList<BidiRun>();
        if (startOffsetInEditor >= 0) {
            int lastOffset = startOffsetInEditor;
            IElementType lastToken = null;
            HighlighterIterator iterator = editor.getHighlighter().createIterator(startOffsetInEditor);
            int endOffsetInEditor = startOffsetInEditor + textLength;
            while (!iterator.atEnd() && iterator.getStart() < endOffsetInEditor) {
                IElementType currentToken = iterator.getTokenType();
                if (LineLayout.distinctTokens(lastToken, currentToken)) {
                    int tokenStart = Math.max(iterator.getStart(), startOffsetInEditor);
                    LineLayout.addRuns(runs, text, lastOffset - startOffsetInEditor, tokenStart - startOffsetInEditor);
                    lastToken = currentToken;
                    lastOffset = tokenStart;
                }
                iterator.advance();
            }
            LineLayout.addRuns(runs, text, lastOffset - startOffsetInEditor, endOffsetInEditor - startOffsetInEditor);
        } else {
            LineLayout.addRuns(runs, text, 0, textLength);
        }
        return runs;
    }

    private static boolean distinctTokens(@Nullable IElementType token1, @Nullable IElementType token2) {
        if (token1 == token2) {
            return false;
        }
        if (token1 == null || token2 == null) {
            return true;
        }
        if (!token1.getLanguage().is(token2.getLanguage())) {
            return true;
        }
        BidiRegionsSeparator separator = (BidiRegionsSeparator)LanguageBidiRegionsSeparator.INSTANCE.forLanguage(token1.getLanguage());
        return separator.createBorderBetweenTokens(token1, token2);
    }

    private static void addRuns(List<BidiRun> runs, char[] text, int start, int end) {
        int afterLastTabPosition = start;
        for (int i = start; i < end; ++i) {
            if (text[i] != '\t') continue;
            LineLayout.addRunsNoTabs(runs, text, afterLastTabPosition, i);
            afterLastTabPosition = i + 1;
            LineLayout.addOrMergeRun(runs, new BidiRun(0, i, i + 1));
        }
        LineLayout.addRunsNoTabs(runs, text, afterLastTabPosition, end);
    }

    private static void addRunsNoTabs(List<BidiRun> runs, char[] text, int start, int end) {
        if (start >= end) {
            return;
        }
        Bidi bidi = new Bidi(text, start, null, 0, end - start, -2);
        int runCount = bidi.getRunCount();
        for (int i = 0; i < runCount; ++i) {
            LineLayout.addOrMergeRun(runs, new BidiRun((byte)bidi.getRunLevel(i), start + bidi.getRunStart(i), start + bidi.getRunLimit(i)));
        }
    }

    private static void addOrMergeRun(List<BidiRun> runs, BidiRun run) {
        int size = runs.size();
        if (size > 0 && runs.get(size - 1).level == 0 && run.level == 0) {
            BidiRun lastRun = runs.remove(size - 1);
            assert (lastRun.endOffset == run.startOffset);
            runs.add(new BidiRun(0, lastRun.startOffset, run.endOffset));
        } else {
            runs.add(run);
        }
    }

    private static void addFragments(BidiRun run, Chunk chunk, char[] text, int start, int end, int fontStyle, FontPreferences fontPreferences, FontRenderContext fontRenderContext, @Nullable TabFragment tabFragment) {
        assert (start < end);
        FontInfo currentFontInfo = null;
        int currentIndex = start;
        for (int i = start; i < end; ++i) {
            FontInfo fontInfo;
            char nextChar;
            int c = text[i];
            if (c == 9 && tabFragment != null) {
                assert (run.level == 0);
                LineLayout.addTextFragmentIfNeeded(chunk, text, currentIndex, i, currentFontInfo, fontRenderContext, false);
                chunk.fragments.add(tabFragment);
                currentFontInfo = null;
                currentIndex = i + 1;
                continue;
            }
            boolean surrogatePair = false;
            int codePoint = c;
            if (Character.isHighSurrogate((char)c) && i + 1 < end && Character.isLowSurrogate(nextChar = text[i + 1])) {
                codePoint = Character.toCodePoint((char)c, nextChar);
                surrogatePair = true;
            }
            if (!(fontInfo = ComplementaryFontsRegistry.getFontAbleToDisplay(codePoint, fontStyle, fontPreferences)).equals(currentFontInfo)) {
                LineLayout.addTextFragmentIfNeeded(chunk, text, currentIndex, i, currentFontInfo, fontRenderContext, run.isRtl());
                currentFontInfo = fontInfo;
                currentIndex = i;
            }
            if (!surrogatePair) continue;
            ++i;
        }
        LineLayout.addTextFragmentIfNeeded(chunk, text, currentIndex, end, currentFontInfo, fontRenderContext, run.isRtl());
        assert (!chunk.fragments.isEmpty());
    }

    private static void addTextFragmentIfNeeded(Chunk chunk, char[] chars, int from, int to, FontInfo fontInfo, FontRenderContext fontRenderContext, boolean isRtl) {
        if (to > from) {
            assert (fontInfo != null);
            chunk.fragments.add(TextFragmentFactory.createTextFragment(chars, from, to, isRtl, fontInfo, fontRenderContext));
        }
    }

    Iterable<VisualFragment> getFragmentsInVisualOrder(final float startX) {
        return new Iterable<VisualFragment>(){

            @Override
            public Iterator<VisualFragment> iterator() {
                return new VisualOrderIterator(null, 0, startX, 0, 0, 0, LineLayout.this.getRunsInVisualOrder());
            }
        };
    }

    Iterator<VisualFragment> getFragmentsInVisualOrder(@NotNull EditorView view, int line, float startX, int startVisualColumn, int startOffset, int endOffset, @Nullable Runnable quickEvaluationListener) {
        BidiRun[] runs;
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "getFragmentsInVisualOrder"));
        }
        assert (startOffset <= endOffset);
        if (startOffset == endOffset) {
            runs = new BidiRun[]{};
        } else {
            ArrayList<BidiRun> runList = new ArrayList<BidiRun>();
            for (BidiRun run : this.getRunsInLogicalOrder()) {
                if (run.endOffset <= startOffset) continue;
                if (run.startOffset >= endOffset) break;
                runList.add(run.subRun(view, line, startOffset, endOffset, quickEvaluationListener));
            }
            if ((runs = runList.toArray(new BidiRun[runList.size()])).length > 1) {
                LineLayout.reorderRunsVisually(runs);
            }
        }
        int startLogicalColumn = view.getLogicalPositionCache().offsetToLogicalColumn(line, startOffset);
        return new VisualOrderIterator(view, line, startX, startVisualColumn, startLogicalColumn, startOffset, runs);
    }

    float getWidth() {
        throw new RuntimeException("This LineLayout instance doesn't have precalculated width");
    }

    abstract boolean isLtr();

    abstract boolean isRtlLocation(int var1, boolean var2);

    abstract int findNearestDirectionBoundary(int var1, boolean var2);

    abstract BidiRun[] getRunsInLogicalOrder();

    abstract BidiRun[] getRunsInVisualOrder();

    static class VisualFragment {
        private LineFragment delegate;
        private int startOffset;
        private int startLogicalColumn;
        private int startVisualColumn;
        private float startX;
        private boolean isRtl;

        VisualFragment() {
        }

        boolean isRtl() {
            return this.isRtl;
        }

        int getMinOffset() {
            return this.isRtl ? this.startOffset - this.getLength() : this.startOffset;
        }

        int getMaxOffset() {
            return this.isRtl ? this.startOffset : this.startOffset + this.getLength();
        }

        int getStartOffset() {
            return this.startOffset;
        }

        int getEndOffset() {
            return this.isRtl ? this.startOffset - this.getLength() : this.startOffset + this.getLength();
        }

        int getLength() {
            return this.delegate.getLength();
        }

        int getStartLogicalColumn() {
            return this.startLogicalColumn;
        }

        int getEndLogicalColumn() {
            return this.isRtl ? this.startLogicalColumn - this.getLogicalColumnCount() : this.startLogicalColumn + this.getLogicalColumnCount();
        }

        int getMinLogicalColumn() {
            return this.isRtl ? this.startLogicalColumn - this.getLogicalColumnCount() : this.startLogicalColumn;
        }

        int getMaxLogicalColumn() {
            return this.isRtl ? this.startLogicalColumn : this.startLogicalColumn + this.getLogicalColumnCount();
        }

        int getStartVisualColumn() {
            return this.startVisualColumn;
        }

        int getEndVisualColumn() {
            return this.startVisualColumn + this.getVisualColumnCount();
        }

        int getLogicalColumnCount() {
            return this.isRtl ? this.getLength() : this.delegate.getLogicalColumnCount(this.getMinLogicalColumn());
        }

        int getVisualColumnCount() {
            return this.delegate.getVisualColumnCount(this.startX);
        }

        float getStartX() {
            return this.startX;
        }

        float getEndX() {
            return this.delegate.offsetToX(this.startX, 0, this.getLength());
        }

        float getWidth() {
            return this.getEndX() - this.getStartX();
        }

        int logicalToVisualColumn(int column) {
            return this.startVisualColumn + this.delegate.logicalToVisualColumn(this.startX, this.getMinLogicalColumn(), this.isRtl ? this.startLogicalColumn - column : column - this.startLogicalColumn);
        }

        int visualToLogicalColumn(int column) {
            int relativeLogicalColumn = this.delegate.visualToLogicalColumn(this.startX, this.getMinLogicalColumn(), column - this.startVisualColumn);
            return this.isRtl ? this.startLogicalColumn - relativeLogicalColumn : this.startLogicalColumn + relativeLogicalColumn;
        }

        float offsetToX(int offset) {
            return this.delegate.offsetToX(this.startX, 0, this.getRelativeOffset(offset));
        }

        float offsetToX(float startX, int startOffset, int offset) {
            return this.delegate.offsetToX(startX, this.getRelativeOffset(startOffset), this.getRelativeOffset(offset));
        }

        int[] xToVisualColumn(float x) {
            int[] column = this.delegate.xToVisualColumn(this.startX, x);
            column[0] = column[0] + this.startVisualColumn;
            return column;
        }

        float visualColumnToX(int column) {
            return this.delegate.visualColumnToX(this.startX, column - this.startVisualColumn);
        }

        void draw(Graphics2D g, float x, float y) {
            this.delegate.draw(g, x, y, 0, this.getLength());
        }

        void draw(Graphics2D g, float x, float y, int startRelativeColumn, int endRelativeColumn) {
            this.delegate.draw(g, x, y, startRelativeColumn, endRelativeColumn);
        }

        private int getRelativeOffset(int offset) {
            return this.isRtl ? this.startOffset - offset : offset - this.startOffset;
        }
    }

    private static class VisualOrderIterator
    implements Iterator<VisualFragment> {
        private final EditorView myView;
        private final int myLine;
        private final BidiRun[] myRuns;
        private int myRunIndex = 0;
        private int myChunkIndex = 0;
        private int myFragmentIndex = 0;
        private int myOffsetInsideRun = 0;
        private VisualFragment myFragment = new VisualFragment();

        private VisualOrderIterator(EditorView view, int line, float startX, int startVisualColumn, int startLogicalColumn, int startOffset, BidiRun[] runsInVisualOrder) {
            this.myView = view;
            this.myLine = line;
            this.myRuns = runsInVisualOrder;
            this.myFragment.startX = startX;
            this.myFragment.startVisualColumn = startVisualColumn;
            this.myFragment.startLogicalColumn = startLogicalColumn;
            this.myFragment.startOffset = startOffset;
        }

        @Override
        public boolean hasNext() {
            if (this.myRunIndex >= this.myRuns.length) {
                return false;
            }
            BidiRun run = this.myRuns[this.myRunIndex];
            Chunk[] chunks = run.getChunks();
            if (this.myChunkIndex >= chunks.length) {
                return false;
            }
            Chunk chunk = chunks[run.isRtl() ? chunks.length - 1 - this.myChunkIndex : this.myChunkIndex];
            if (this.myView != null) {
                chunk.ensureLayout(this.myView, run, this.myLine);
            }
            return this.myFragmentIndex < chunk.fragments.size();
        }

        @Override
        public VisualFragment next() {
            VisualFragment visualFragment;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BidiRun run = this.myRuns[this.myRunIndex];
            if (this.myRunIndex == 0 && this.myChunkIndex == 0 && this.myFragmentIndex == 0) {
                visualFragment = this.myFragment;
                visualFragment.startLogicalColumn = visualFragment.startLogicalColumn + ((run.isRtl() ? run.endOffset : run.startOffset) - this.myFragment.startOffset);
            } else {
                this.myFragment.startLogicalColumn = this.myFragment.getEndLogicalColumn();
                if (this.myChunkIndex == 0 && this.myFragmentIndex == 0) {
                    visualFragment = this.myFragment;
                    visualFragment.startLogicalColumn = visualFragment.startLogicalColumn + ((run.isRtl() ? run.endOffset : run.startOffset) - this.myFragment.getEndOffset());
                }
                this.myFragment.startVisualColumn = this.myFragment.getEndVisualColumn();
                this.myFragment.startX = this.myFragment.getEndX();
            }
            this.myFragment.isRtl = run.isRtl();
            Chunk[] chunks = run.getChunks();
            Chunk chunk = chunks[run.isRtl() ? chunks.length - 1 - this.myChunkIndex : this.myChunkIndex];
            assert (!chunk.fragments.isEmpty());
            this.myFragment.delegate = chunk.fragments.get(run.isRtl() ? chunk.fragments.size() - 1 - this.myFragmentIndex : this.myFragmentIndex);
            this.myFragment.startOffset = run.isRtl() ? run.endOffset - this.myOffsetInsideRun : run.startOffset + this.myOffsetInsideRun;
            this.myOffsetInsideRun += this.myFragment.getLength();
            ++this.myFragmentIndex;
            if (this.myFragmentIndex >= chunk.fragments.size()) {
                this.myFragmentIndex = 0;
                ++this.myChunkIndex;
                if (this.myChunkIndex >= chunks.length) {
                    this.myChunkIndex = 0;
                    this.myOffsetInsideRun = 0;
                    ++this.myRunIndex;
                }
            }
            return this.myFragment;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ApproximationChunk
    extends Chunk {
        private ApproximationChunk(@NotNull EditorView view, int line, int start, int end) {
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout$ApproximationChunk", "<init>"));
            }
            super(start, end);
            int startColumn = view.getLogicalPositionCache().offsetToLogicalColumn(line, start);
            int endColumn = view.getLogicalPositionCache().offsetToLogicalColumn(line, end);
            this.fragments.add(new ApproximationFragment(end - start, endColumn - startColumn, view.getMaxCharWidth()));
        }

        @Override
        boolean isReal() {
            return false;
        }
    }

    static class Chunk {
        final List<LineFragment> fragments = new ArrayList<LineFragment>();
        private int startOffset;
        private int endOffset;

        private Chunk(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        private void ensureLayout(@NotNull EditorView view, BidiRun run, int line) {
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout$Chunk", "ensureLayout"));
            }
            if (this.isReal()) {
                view.getTextLayoutCache().onChunkAccess(this);
            }
            if (!this.fragments.isEmpty()) {
                return;
            }
            int lineStartOffset = view.getEditor().getDocument().getLineStartOffset(line);
            int start = lineStartOffset + this.startOffset;
            int end = lineStartOffset + this.endOffset;
            IterationState it = new IterationState(view.getEditor(), start, end, false, false, true, false, false);
            FontPreferences fontPreferences = view.getEditor().getColorsScheme().getFontPreferences();
            char[] chars = CharArrayUtil.fromSequence((CharSequence)view.getEditor().getDocument().getImmutableCharSequence(), (int)start, (int)end);
            while (!it.atEnd()) {
                LineLayout.addFragments(run, this, chars, it.getStartOffset() - start, it.getEndOffset() - start, it.getMergedAttributes().getFontType(), fontPreferences, view.getFontRenderContext(), view.getTabFragment());
                it.advance();
            }
            view.getSizeManager().textLayoutPerformed(start, end);
            assert (!this.fragments.isEmpty());
        }

        private Chunk subChunk(EditorView view, BidiRun run, int line, int targetStartOffset, int targetEndOffset, @Nullable Runnable quickEvaluationListener) {
            assert (targetStartOffset < this.endOffset);
            assert (targetEndOffset > this.startOffset);
            int start = Math.max(this.startOffset, targetStartOffset);
            int end = Math.min(this.endOffset, targetEndOffset);
            if (quickEvaluationListener != null && this.fragments.isEmpty()) {
                quickEvaluationListener.run();
                return new ApproximationChunk(view, line, start, end);
            }
            if (start == this.startOffset && end == this.endOffset) {
                return this;
            }
            this.ensureLayout(view, run, line);
            Chunk chunk = new Chunk(start, end);
            int offset = this.startOffset;
            for (LineFragment fragment : this.fragments) {
                if (end <= offset) break;
                int endOffset = offset + fragment.getLength();
                if (start < endOffset) {
                    chunk.fragments.add(fragment.subFragment(Math.max(start, offset) - offset, Math.min(end, endOffset) - offset));
                }
                offset = endOffset;
            }
            return chunk;
        }

        boolean isReal() {
            return true;
        }

        void clearCache() {
            this.fragments.clear();
        }
    }

    private static class BidiRun {
        private static final int CHUNK_CHARACTERS = 1024;
        private final byte level;
        private final int startOffset;
        private final int endOffset;
        private Chunk[] chunks;

        private BidiRun(int length) {
            this(0, 0, length);
        }

        private BidiRun(byte level, int startOffset, int endOffset) {
            this.level = level;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        private boolean isRtl() {
            return (this.level & 1) != 0;
        }

        private Chunk[] getChunks() {
            if (this.chunks == null) {
                int chunkCount = this.getChunkCount();
                this.chunks = new Chunk[chunkCount];
                for (int i = 0; i < chunkCount; ++i) {
                    Chunk chunk;
                    int from = this.startOffset + i * 1024;
                    int to = i == chunkCount - 1 ? this.endOffset : from + 1024;
                    this.chunks[i] = chunk = new Chunk(from, to);
                }
            }
            return this.chunks;
        }

        private int getChunkCount() {
            return (this.endOffset - this.startOffset + 1024 - 1) / 1024;
        }

        private BidiRun subRun(@NotNull EditorView view, int line, int targetStartOffset, int targetEndOffset, @Nullable Runnable quickEvaluationListener) {
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout$BidiRun", "subRun"));
            }
            assert (targetStartOffset < this.endOffset);
            assert (targetEndOffset > this.startOffset);
            int start = Math.max(this.startOffset, targetStartOffset);
            int end = Math.min(this.endOffset, targetEndOffset);
            BidiRun subRun = new BidiRun(this.level, start, end);
            ArrayList<Chunk> subChunks = new ArrayList<Chunk>();
            for (Chunk chunk : this.getChunks()) {
                if (chunk.endOffset <= start) continue;
                if (chunk.startOffset >= end) break;
                subChunks.add(chunk.subChunk(view, this, line, start, end, quickEvaluationListener));
            }
            subRun.chunks = subChunks.toArray(new Chunk[subChunks.size()]);
            return subRun;
        }

        static /* synthetic */ Chunk[] access$402(BidiRun x0, Chunk[] x1) {
            x0.chunks = x1;
            return x1;
        }
    }

    private static class WithSize
    extends LineLayout {
        private final LineLayout myDelegate;
        private final float myWidth;

        private WithSize(@NotNull LineLayout delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/editor/impl/view/LineLayout$WithSize", "<init>"));
            }
            this.myDelegate = delegate;
            this.myWidth = this.calculateWidth();
        }

        private float calculateWidth() {
            float x = 0.0f;
            for (VisualFragment fragment : this.getFragmentsInVisualOrder(x)) {
                x = fragment.getEndX();
            }
            return x;
        }

        @Override
        float getWidth() {
            return this.myWidth;
        }

        @Override
        boolean isLtr() {
            return this.myDelegate.isLtr();
        }

        @Override
        boolean isRtlLocation(int offset, boolean leanForward) {
            return this.myDelegate.isRtlLocation(offset, leanForward);
        }

        @Override
        int findNearestDirectionBoundary(int offset, boolean lookForward) {
            return this.myDelegate.findNearestDirectionBoundary(offset, lookForward);
        }

        @Override
        BidiRun[] getRunsInLogicalOrder() {
            return this.myDelegate.getRunsInLogicalOrder();
        }

        @Override
        BidiRun[] getRunsInVisualOrder() {
            return this.myDelegate.getRunsInVisualOrder();
        }
    }

    private static class MultiChunk
    extends LineLayout {
        private final BidiRun[] myBidiRunsInLogicalOrder;
        private final BidiRun[] myBidiRunsInVisualOrder;

        private MultiChunk(BidiRun[] bidiRunsInLogicalOrder) {
            this.myBidiRunsInLogicalOrder = bidiRunsInLogicalOrder;
            if (bidiRunsInLogicalOrder.length > 1) {
                this.myBidiRunsInVisualOrder = (BidiRun[])this.myBidiRunsInLogicalOrder.clone();
                LineLayout.reorderRunsVisually(this.myBidiRunsInVisualOrder);
            } else {
                this.myBidiRunsInVisualOrder = bidiRunsInLogicalOrder;
            }
        }

        @Override
        boolean isLtr() {
            return this.myBidiRunsInLogicalOrder.length == 0 || this.myBidiRunsInLogicalOrder.length == 1 && !this.myBidiRunsInLogicalOrder[0].isRtl();
        }

        @Override
        boolean isRtlLocation(int offset, boolean leanForward) {
            if (offset == 0 && !leanForward) {
                return false;
            }
            for (BidiRun run : this.myBidiRunsInLogicalOrder) {
                if (offset >= run.endOffset && (offset != run.endOffset || leanForward)) continue;
                return run.isRtl();
            }
            return false;
        }

        @Override
        int findNearestDirectionBoundary(int offset, boolean lookForward) {
            if (lookForward) {
                byte originLevel = -1;
                for (BidiRun run : this.myBidiRunsInLogicalOrder) {
                    if (originLevel >= 0) {
                        if (run.level == originLevel) continue;
                        return run.startOffset;
                    }
                    if (run.endOffset <= offset) continue;
                    originLevel = run.level;
                }
                return originLevel > 0 ? this.myBidiRunsInLogicalOrder[this.myBidiRunsInLogicalOrder.length - 1].endOffset : -1;
            }
            byte originLevel = -1;
            for (int i = this.myBidiRunsInLogicalOrder.length - 1; i >= 0; --i) {
                BidiRun run = this.myBidiRunsInLogicalOrder[i];
                if (originLevel >= 0) {
                    if (run.level == originLevel) continue;
                    return run.endOffset;
                }
                if (run.startOffset >= offset) continue;
                originLevel = run.level;
            }
            return originLevel > 0 ? 0 : -1;
        }

        @Override
        BidiRun[] getRunsInLogicalOrder() {
            return this.myBidiRunsInLogicalOrder;
        }

        @Override
        BidiRun[] getRunsInVisualOrder() {
            return this.myBidiRunsInVisualOrder;
        }
    }

    private static class SingleChunk
    extends LineLayout {
        private final Chunk myChunk;

        private SingleChunk(Chunk chunk) {
            this.myChunk = chunk;
        }

        @Override
        boolean isLtr() {
            return true;
        }

        @Override
        boolean isRtlLocation(int offset, boolean leanForward) {
            return false;
        }

        @Override
        int findNearestDirectionBoundary(int offset, boolean lookForward) {
            return -1;
        }

        @Override
        BidiRun[] getRunsInLogicalOrder() {
            return this.createRuns();
        }

        @Override
        BidiRun[] getRunsInVisualOrder() {
            return this.createRuns();
        }

        private BidiRun[] createRuns() {
            if (this.myChunk == null) {
                return new BidiRun[0];
            }
            BidiRun run = new BidiRun(this.myChunk.endOffset);
            BidiRun.access$402(run, new Chunk[]{this.myChunk});
            return new BidiRun[]{run};
        }
    }
}

