/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ConfigurationError;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ConfigurationErrorQuickFix;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsSettings;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.awt.RelativePoint;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ProjectConfigurationProblem
extends ConfigurationError {
    private final ProjectStructureProblemDescription myDescription;
    private final Project myProject;

    public ProjectConfigurationProblem(ProjectStructureProblemDescription description, Project project2) {
        super(StringUtil.unescapeXml((String)description.getMessage(true)), ProjectConfigurationProblem.computeDescription(description), ProjectConfigurationProblem.getSettings(project2, description.getProblemLevel()).isIgnored(description));
        this.myDescription = description;
        this.myProject = project2;
    }

    private static ProjectStructureProblemsSettings getSettings(Project project2, ProjectStructureProblemDescription.ProblemLevel problemLevel) {
        if (problemLevel == ProjectStructureProblemDescription.ProblemLevel.PROJECT) {
            return ProjectStructureProblemsSettings.getProjectInstance(project2);
        }
        return ProjectStructureProblemsSettings.getGlobalInstance();
    }

    private static String computeDescription(ProjectStructureProblemDescription description) {
        String descriptionString = description.getDescription();
        return descriptionString != null ? descriptionString : description.getMessage(true);
    }

    @NotNull
    public ProjectStructureProblemDescription getProblemDescription() {
        ProjectStructureProblemDescription projectStructureProblemDescription = this.myDescription;
        if (projectStructureProblemDescription == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectConfigurationProblem", "getProblemDescription"));
        }
        return projectStructureProblemDescription;
    }

    @Override
    public void ignore(boolean ignored) {
        super.ignore(ignored);
        ProjectConfigurationProblem.getSettings(this.myProject, this.myDescription.getProblemLevel()).setIgnored(this.myDescription, ignored);
    }

    @Override
    public void navigate() {
        this.myDescription.getPlace().navigate();
    }

    @Override
    public boolean canBeFixed() {
        return !this.myDescription.getFixes().isEmpty();
    }

    @Override
    public void fix(JComponent contextComponent, RelativePoint relativePoint) {
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<ConfigurationErrorQuickFix>(null, this.myDescription.getFixes()){

            @NotNull
            public String getTextFor(ConfigurationErrorQuickFix value) {
                String string = value.getActionName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectConfigurationProblem$1", "getTextFor"));
                }
                return string;
            }

            public PopupStep onChosen(final ConfigurationErrorQuickFix selectedValue, boolean finalChoice) {
                return this.doFinalStep(new Runnable(){

                    @Override
                    public void run() {
                        selectedValue.performFix();
                    }
                });
            }
        }).show(relativePoint);
    }
}

