/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.updateSettings.impl.DetectedPluginsPanel;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.ui.TableUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.jetbrains.annotations.Nullable;

public class PluginsAdvertiserDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)("#" + PluginsAdvertiserDialog.class.getName()));
    @Nullable
    private final Project myProject;
    private final PluginDownloader[] myUploadedPlugins;
    private final List<PluginId> myAllPlugins;
    private final Set<String> mySkippedPlugins = new HashSet<String>();

    PluginsAdvertiserDialog(@Nullable Project project2, PluginDownloader[] plugins2, List<PluginId> allPlugins) {
        super(project2);
        this.myProject = project2;
        Arrays.sort(plugins2, new Comparator<PluginDownloader>(){

            @Override
            public int compare(PluginDownloader o1, PluginDownloader o2) {
                return o1.getPluginName().compareToIgnoreCase(o2.getPluginName());
            }
        });
        this.myUploadedPlugins = plugins2;
        this.myAllPlugins = allPlugins;
        this.setTitle("Choose Plugins to Install or Enable");
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        DetectedPluginsPanel foundPluginsPanel = new DetectedPluginsPanel(){

            @Override
            protected Set<String> getSkippedPlugins() {
                return PluginsAdvertiserDialog.this.mySkippedPlugins;
            }
        };
        for (PluginDownloader uploadedPlugin : this.myUploadedPlugins) {
            foundPluginsPanel.add(uploadedPlugin);
        }
        TableUtil.ensureSelectionExists((JTable)foundPluginsPanel.getEntryTable());
        return foundPluginsPanel;
    }

    protected void doOKAction() {
        HashSet<String> pluginsToEnable = new HashSet<String>();
        ArrayList<PluginNode> nodes = new ArrayList<PluginNode>();
        for (PluginDownloader downloader : this.myUploadedPlugins) {
            PluginNode pluginNode;
            String pluginId = downloader.getPluginId();
            if (this.mySkippedPlugins.contains(pluginId)) continue;
            pluginsToEnable.add(pluginId);
            if (PluginManagerCore.getDisabledPlugins().contains(pluginId) || (pluginNode = PluginDownloader.createPluginNode(null, downloader)) == null) continue;
            nodes.add(pluginNode);
        }
        Runnable notifyRunnable = new Runnable(){

            @Override
            public void run() {
                PluginManagerMain.notifyPluginsUpdated(PluginsAdvertiserDialog.this.myProject);
            }
        };
        for (String pluginId : pluginsToEnable) {
            PluginManagerCore.enablePlugin(pluginId);
        }
        if (!nodes.isEmpty()) {
            try {
                PluginManagerMain.downloadPlugins(nodes, this.myAllPlugins, notifyRunnable, null);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        } else if (!pluginsToEnable.isEmpty()) {
            notifyRunnable.run();
        }
        super.doOKAction();
    }
}

