/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.TextFilePatchInProgress;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

abstract class AutoMatchStrategy {
    protected final VirtualFile myBaseDir;
    protected MultiMap<String, VirtualFile> myFolderDecisions;
    protected final List<TextFilePatchInProgress> myResult;

    AutoMatchStrategy(VirtualFile baseDir) {
        this.myBaseDir = baseDir;
        this.myResult = new LinkedList<TextFilePatchInProgress>();
        this.myFolderDecisions = MultiMap.createSet();
    }

    public abstract void acceptPatch(TextFilePatch var1, Collection<VirtualFile> var2);

    public abstract void processCreation(TextFilePatch var1);

    public abstract void beforeCreations();

    public abstract boolean succeeded();

    public List<TextFilePatchInProgress> getResult() {
        return this.myResult;
    }

    protected void registerFolderDecision(String patchPath, VirtualFile base) {
        String path = this.extractPathWithoutName(patchPath);
        if (path != null) {
            this.myFolderDecisions.putValue((Object)path, (Object)base);
        }
    }

    @Nullable
    protected Collection<VirtualFile> suggestFolderForCreation(TextFilePatch creation) {
        String newFileParentPath = this.extractPathWithoutName(creation.getAfterName());
        if (newFileParentPath != null) {
            return this.filterVariants(creation, this.myFolderDecisions.get((Object)newFileParentPath));
        }
        return null;
    }

    protected void processCreationBasedOnFolderDecisions(TextFilePatch creation) {
        Collection<VirtualFile> variants = this.suggestFolderForCreation(creation);
        if (variants != null) {
            this.myResult.add(new TextFilePatchInProgress(creation, variants, this.myBaseDir));
        } else {
            this.myResult.add(new TextFilePatchInProgress(creation, null, this.myBaseDir));
        }
    }

    protected Collection<VirtualFile> filterVariants(TextFilePatch patch, Collection<VirtualFile> in) {
        String path = patch.getBeforeName() == null ? patch.getAfterName() : patch.getBeforeName();
        path = path.replace("\\", "/");
        boolean caseSensitive = SystemInfo.isFileSystemCaseSensitive;
        LinkedList<VirtualFile> result = new LinkedList<VirtualFile>();
        for (VirtualFile vf : in) {
            String vfPath = vf.getPath();
            if ((!caseSensitive || !vfPath.endsWith(path)) && (caseSensitive || !StringUtil.endsWithIgnoreCase((String)vfPath, (String)path))) continue;
            result.add(vf);
        }
        return result;
    }

    @Nullable
    protected String extractPathWithoutName(String path) {
        String replaced = path.replace("\\", "/");
        int idx = replaced.lastIndexOf(47);
        if (idx == -1) {
            return null;
        }
        return replaced.substring(0, idx);
    }

    @Nullable
    protected TextFilePatchInProgress processMatch(TextFilePatch patch, VirtualFile file2) {
        int idx;
        String beforeName = patch.getBeforeName();
        if (beforeName == null) {
            return null;
        }
        String[] parts = beforeName.replace('\\', '/').split("/");
        VirtualFile parent = file2.getParent();
        for (idx = parts.length - 2; parent != null && idx >= 0 && parent.getName().equals(parts[idx]); parent = parent.getParent(), --idx) {
        }
        if (parent != null) {
            TextFilePatchInProgress result = new TextFilePatchInProgress(patch, null, this.myBaseDir);
            result.setNewBase(parent);
            int numDown = idx + 1;
            AutoMatchStrategy.processStipUp(result, numDown);
            return result;
        }
        return null;
    }

    public static void processStipUp(AbstractFilePatchInProgress patchInProgress, int num) {
        for (int i = 0; i < num; ++i) {
            patchInProgress.up();
        }
    }
}

