/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.progress.util.StandardProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSetQueue;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class DocumentCommitThread
extends DocumentCommitProcessor
implements Runnable,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.DocumentCommitThread");
    private final ExecutorService executor = new BoundedTaskExecutor((Executor)PooledThreadExecutor.INSTANCE, JobSchedulerImpl.CORES_COUNT, (Disposable)this);
    private final Object lock = new Object();
    private final HashSetQueue<DocumentCommitProcessor.CommitTask> documentsToCommit = new HashSetQueue();
    private final HashSetQueue<DocumentCommitProcessor.CommitTask> documentsToApplyInEDT = new HashSetQueue();
    private final ApplicationEx myApplication;
    private volatile boolean isDisposed;
    private DocumentCommitProcessor.CommitTask currentTask;
    private boolean myEnabled;
    private int runningWriteActions;
    final StringBuilder log = new StringBuilder();

    public static DocumentCommitThread getInstance() {
        return (DocumentCommitThread)ServiceManager.getService(DocumentCommitThread.class);
    }

    public DocumentCommitThread(final ApplicationEx application) {
        this.myApplication = application;
        application.invokeLater(new Runnable(){

            @Override
            public void run() {
                assert (DocumentCommitThread.this.runningWriteActions == 0);
                if (application.isDisposed()) {
                    return;
                }
                assert (!application.isWriteAccessAllowed() || application.isUnitTestMode());
                application.addApplicationListener((ApplicationListener)new ApplicationAdapter(){

                    public void beforeWriteActionStart(Object action) {
                        int writeActionsBefore = DocumentCommitThread.this.runningWriteActions++;
                        if (writeActionsBefore == 0) {
                            DocumentCommitThread.this.disable("Write action started: " + action);
                        }
                    }

                    public void writeActionFinished(Object action) {
                        int writeActionsAfter = DocumentCommitThread.this.runningWriteActions = Math.max(0, DocumentCommitThread.this.runningWriteActions - 1);
                        if (writeActionsAfter == 0) {
                            DocumentCommitThread.this.enable("Write action finished: " + action);
                        } else if (writeActionsAfter < 0) {
                            System.err.println("mismatched listeners: " + writeActionsAfter + ";\n==== log===" + DocumentCommitThread.this.log + "\n====end log===" + ";\n=======threaddump====\n" + ThreadDumper.dumpThreadsToString() + "\n=====END threaddump=======");
                            assert (false);
                        }
                    }
                }, DocumentCommitThread.this);
                DocumentCommitThread.this.enable("Listener installed, started");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.isDisposed = true;
        Object object = this.lock;
        synchronized (object) {
            this.documentsToCommit.clear();
        }
        this.cancel("Stop thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disable(@NonNls @NotNull Object reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "disable"));
        }
        Object object = this.lock;
        synchronized (object) {
            this.cancel(reason);
            this.myEnabled = false;
            this.log(null, "Disabled", null, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enable(@NonNls @NotNull Object reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "enable"));
        }
        Object object = this.lock;
        synchronized (object) {
            this.myEnabled = true;
            this.wakeUpQueue();
            this.log(null, "Enabled", null, reason);
        }
    }

    private void wakeUpQueue() {
        if (!this.isDisposed) {
            this.executor.execute(this);
        }
    }

    private void cancel(@NonNls @NotNull Object reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "cancel"));
        }
        this.startNewTask(null, reason);
    }

    @Override
    public void commitAsynchronously(@NotNull Project project2, @NotNull Document document, @NonNls @NotNull Object reason, @NotNull ModalityState currentModalityState) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/DocumentCommitThread", "commitAsynchronously"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/DocumentCommitThread", "commitAsynchronously"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "commitAsynchronously"));
        }
        if (currentModalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModalityState", "com/intellij/psi/impl/DocumentCommitThread", "commitAsynchronously"));
        }
        this.queueCommit(project2, document, reason, currentModalityState);
    }

    void queueCommit(@NotNull Project project2, @NotNull Document document, @NonNls @NotNull Object reason, @NotNull ModalityState currentModalityState) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/DocumentCommitThread", "queueCommit"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/DocumentCommitThread", "queueCommit"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "queueCommit"));
        }
        if (currentModalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModalityState", "com/intellij/psi/impl/DocumentCommitThread", "queueCommit"));
        }
        assert (!this.isDisposed) : "already disposed";
        if (!project2.isInitialized()) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getCachedPsiFile(document);
        if (psiFile == null) {
            return;
        }
        this.doQueue(project2, document, DocumentCommitThread.getAllFileNodes(psiFile), reason, currentModalityState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private DocumentCommitProcessor.CommitTask doQueue(@NotNull Project project2, @NotNull Document document, @NotNull List<Pair<PsiFileImpl, FileASTNode>> oldFileNodes, @NotNull Object reason, @NotNull ModalityState currentModalityState) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
        }
        if (oldFileNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFileNodes", "com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
        }
        if (currentModalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModalityState", "com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
        }
        Object object = this.lock;
        // MONITORENTER : object
        DocumentCommitProcessor.CommitTask newTask = this.createNewTaskAndCancelSimilar(project2, document, oldFileNodes, reason, currentModalityState);
        this.documentsToCommit.offer((Object)newTask);
        this.log(project2, "Queued", newTask, reason);
        this.wakeUpQueue();
        DocumentCommitProcessor.CommitTask commitTask = newTask;
        // MONITOREXIT : object
        if (commitTask != null) return commitTask;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private DocumentCommitProcessor.CommitTask createNewTaskAndCancelSimilar(@NotNull Project project2, @NotNull Document document, @NotNull List<Pair<PsiFileImpl, FileASTNode>> oldFileNodes, @NotNull Object reason, @NotNull ModalityState currentModalityState) {
        Pair<PsiFileImpl, FileASTNode> pair;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
        }
        if (oldFileNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFileNodes", "com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
        }
        if (currentModalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModalityState", "com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
        }
        Object object = this.lock;
        // MONITORENTER : object
        Iterator<Pair<PsiFileImpl, FileASTNode>> iterator = oldFileNodes.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                DocumentCommitProcessor.CommitTask newTask = new DocumentCommitProcessor.CommitTask(project2, document, oldFileNodes, this.createProgressIndicator(), reason, currentModalityState);
                this.cancelAndRemoveFromDocsToCommit(newTask);
                this.cancelAndRemoveCurrentTask(newTask);
                this.cancelAndRemoveFromDocsToApplyInEDT(newTask);
                DocumentCommitProcessor.CommitTask commitTask = newTask;
                // MONITOREXIT : object
                if (commitTask != null) return commitTask;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
            }
            pair = iterator.next();
            assert (((PsiFileImpl)pair.first).getProject() == project2);
        }
    }

    @Override
    public void log(Project project2, @NonNls String msg, @Nullable DocumentCommitProcessor.CommitTask task, Object ... args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAll() {
        Object object = this.lock;
        synchronized (object) {
            this.cancel("cancel all in tests");
            for (DocumentCommitProcessor.CommitTask commitTask : this.documentsToCommit) {
                commitTask.indicator.cancel();
                this.log(commitTask.project, "Removed from background queue", commitTask, new Object[0]);
            }
            this.documentsToCommit.clear();
            for (DocumentCommitProcessor.CommitTask commitTask : this.documentsToApplyInEDT) {
                commitTask.indicator.cancel();
                this.log(commitTask.project, "Removed from EDT apply queue (sync commit called)", commitTask, new Object[0]);
            }
            this.documentsToApplyInEDT.clear();
            DocumentCommitProcessor.CommitTask task = this.currentTask;
            if (task != null) {
                this.cancelAndRemoveFromDocsToCommit(task);
            }
            this.cancel("Sync commit intervened");
            ((BoundedTaskExecutor)this.executor).clearAndCancelAll();
        }
    }

    public void clearQueue() {
        this.cancelAll();
        this.clearLog();
        this.wakeUpQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearLog() {
        StringBuilder stringBuilder = this.log;
        synchronized (stringBuilder) {
            this.log.setLength(0);
        }
    }

    private void cancelAndRemoveCurrentTask(@NotNull DocumentCommitProcessor.CommitTask newTask) {
        if (newTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTask", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveCurrentTask"));
        }
        DocumentCommitProcessor.CommitTask currentTask = this.currentTask;
        if (currentTask != null && currentTask.equals(newTask)) {
            this.cancelAndRemoveFromDocsToCommit(currentTask);
            this.cancel("Sync commit intervened");
        }
    }

    private void cancelAndRemoveFromDocsToApplyInEDT(@NotNull DocumentCommitProcessor.CommitTask newTask) {
        if (newTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTask", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromDocsToApplyInEDT"));
        }
        boolean removed = DocumentCommitThread.cancelAndRemoveFromQueue(newTask, this.documentsToApplyInEDT);
        if (removed) {
            this.log(newTask.project, "Removed from EDT apply queue", newTask, new Object[0]);
        }
    }

    private void cancelAndRemoveFromDocsToCommit(@NotNull DocumentCommitProcessor.CommitTask newTask) {
        if (newTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTask", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromDocsToCommit"));
        }
        boolean removed = DocumentCommitThread.cancelAndRemoveFromQueue(newTask, this.documentsToCommit);
        if (removed) {
            this.log(newTask.project, "Removed from background queue", newTask, new Object[0]);
        }
    }

    private static boolean cancelAndRemoveFromQueue(@NotNull DocumentCommitProcessor.CommitTask newTask, @NotNull HashSetQueue<DocumentCommitProcessor.CommitTask> queue) {
        if (newTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTask", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromQueue"));
        }
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromQueue"));
        }
        DocumentCommitProcessor.CommitTask queuedTask = (DocumentCommitProcessor.CommitTask)queue.find((Object)newTask);
        if (queuedTask != null) {
            assert (queuedTask != newTask);
            queuedTask.indicator.cancel();
        }
        return queue.remove((Object)newTask);
    }

    @Override
    public void run() {
        while (!this.isDisposed) {
            try {
                boolean polled = this.pollQueue();
                if (polled) continue;
                break;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pollQueue() {
        Object object;
        assert (!this.myApplication.isDispatchThread()) : Thread.currentThread();
        boolean success = false;
        Document document = null;
        Project project2 = null;
        DocumentCommitProcessor.CommitTask task = null;
        try {
            ProgressIndicator indicator;
            object = this.lock;
            synchronized (object) {
                if (!this.myEnabled || (task = (DocumentCommitProcessor.CommitTask)this.documentsToCommit.poll()) == null) {
                    return false;
                }
                document = task.document;
                indicator = task.indicator;
                project2 = task.project;
                this.log(project2, "Pulled", task, indicator, this.myEnabled);
                if (project2.isDisposed() || !((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project2)).isInUncommittedSet(document)) {
                    this.log(project2, "Abandon and proceed to next", task, new Object[0]);
                    return true;
                }
                if (indicator.isCanceled()) {
                    return true;
                }
                this.startNewTask(task, "Pulled new task");
                this.documentsToApplyInEDT.add((Object)task);
            }
            Runnable finishRunnable = null;
            if (indicator.isCanceled()) {
                success = false;
            } else {
                final DocumentCommitProcessor.CommitTask commitTask = task;
                final Runnable[] result = new Runnable[1];
                ProgressManager.getInstance().executeProcessUnderProgress(new Runnable(){

                    @Override
                    public void run() {
                        result[0] = DocumentCommitThread.this.commitUnderProgress(commitTask, false);
                    }
                }, commitTask.indicator);
                finishRunnable = result[0];
                success = finishRunnable != null;
                this.log(project2, "commit returned", task, finishRunnable, indicator);
            }
            if (success) {
                assert (!this.myApplication.isDispatchThread());
                this.myApplication.invokeLater(finishRunnable, task.myCreationModalityState);
                this.log(project2, "InvokeLater finishRunnable", task, finishRunnable, task.myCreationModalityState);
            }
        }
        catch (ProcessCanceledException e) {
            this.cancel((Object)e);
            this.log(project2, "PCE", task, new Object[]{e});
            success = false;
        }
        catch (Throwable e) {
            LOG.error(this.log.toString(), e);
            this.cancel(e);
        }
        final PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project2);
        if (!success && task != null && documentManager.isUncommited(task.document)) {
            final Document finalDocument = document;
            List oldFileNodes = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<Pair<PsiFileImpl, FileASTNode>>>(){

                public List<Pair<PsiFileImpl, FileASTNode>> compute() {
                    PsiFile file2 = documentManager.getPsiFile(finalDocument);
                    return file2 == null ? null : DocumentCommitThread.getAllFileNodes(file2);
                }
            });
            if (oldFileNodes != null) {
                this.doQueue(project2, document, oldFileNodes, "re-added on failure", task.myCreationModalityState);
            }
        }
        object = this.lock;
        synchronized (object) {
            this.currentTask = null;
        }
        return true;
    }

    @Override
    public void commitSynchronously(@NotNull Document document, @NotNull Project project2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/DocumentCommitThread", "commitSynchronously"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/DocumentCommitThread", "commitSynchronously"));
        }
        assert (!this.isDisposed);
        this.myApplication.assertWriteAccessAllowed();
        if (!project2.isInitialized() && !project2.isDefault()) {
            String s = project2 + "; Disposed: " + project2.isDisposed() + "; Open: " + project2.isOpen();
            try {
                Disposer.dispose((Disposable)project2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new RuntimeException(s);
        }
        PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project2);
        PsiFile psiFile = documentManager.getPsiFile(document);
        if (psiFile == null) {
            documentManager.myUncommittedDocuments.remove(document);
            return;
        }
        DocumentCommitProcessor.CommitTask task = this.createNewTaskAndCancelSimilar(project2, document, DocumentCommitThread.getAllFileNodes(psiFile), "Sync commit", ModalityState.current());
        assert (!task.indicator.isCanceled());
        Runnable finish = this.commitUnderProgress(task, true);
        this.log(project2, "Committed sync", task, finish, task.indicator);
        assert (finish != null);
        finish.run();
    }

    @NotNull
    private static List<Pair<PsiFileImpl, FileASTNode>> getAllFileNodes(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/DocumentCommitThread", "getAllFileNodes"));
        }
        List list = ContainerUtil.map((Collection)file2.getViewProvider().getAllFiles(), (Function)new Function<PsiFile, Pair<PsiFileImpl, FileASTNode>>(){

            public Pair<PsiFileImpl, FileASTNode> fun(PsiFile root) {
                return Pair.create((Object)((PsiFileImpl)root), (Object)root.getNode());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread", "getAllFileNodes"));
        }
        return list;
    }

    @Override
    @NotNull
    protected ProgressIndicator createProgressIndicator() {
        AbstractProgressIndicatorBase abstractProgressIndicatorBase = ApplicationManager.getApplication().isUnitTestMode() ? new AbstractProgressIndicatorBase(){

            @Override
            public void cancel() {
                super.cancel();
                DocumentCommitThread.this.log(null, "indicator cancel", null, this);
            }
        } : new StandardProgressIndicatorBase();
        if (abstractProgressIndicatorBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread", "createProgressIndicator"));
        }
        return abstractProgressIndicatorBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNewTask(@Nullable DocumentCommitProcessor.CommitTask task, @NotNull Object reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/psi/impl/DocumentCommitThread", "startNewTask"));
        }
        Object object = this.lock;
        synchronized (object) {
            DocumentCommitProcessor.CommitTask cur = this.currentTask;
            if (cur != null) {
                cur.indicator.cancel();
            }
            this.currentTask = task;
        }
        this.log(task == null ? null : task.project, "new task started", task, reason);
    }

    @Nullable
    private Runnable commitUnderProgress(final @NotNull DocumentCommitProcessor.CommitTask task, boolean synchronously) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/psi/impl/DocumentCommitThread", "commitUnderProgress"));
        }
        if (synchronously) assert (!task.indicator.isCanceled());
        final Project project2 = task.project;
        this.log(project2, "commitUnderProgress()", task, synchronously, task.indicator);
        final Document document = task.document;
        final PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project2);
        SmartList finishProcessors = new SmartList();
        Runnable runnable2 = new Runnable((List)finishProcessors){
            final /* synthetic */ List val$finishProcessors;
            {
                this.val$finishProcessors = list;
            }

            @Override
            public void run() {
                boolean changeStillValid;
                DocumentCommitThread.this.myApplication.assertReadAccessAllowed();
                if (project2.isDisposed()) {
                    return;
                }
                if (documentManager.isCommitted(document)) {
                    return;
                }
                boolean bl = changeStillValid = task.modificationStamp == document.getModificationStamp();
                if (!changeStillValid) {
                    DocumentCommitThread.this.log(project2, "Doc changed", task, task.modificationStamp, document.getModificationStamp());
                    task.indicator.cancel();
                    return;
                }
                FileViewProvider viewProvider = documentManager.getCachedViewProvider(document);
                if (viewProvider == null) {
                    this.val$finishProcessors.add(DocumentCommitThread.this.handleCommitWithoutPsi(documentManager, document, task));
                    return;
                }
                for (Pair<PsiFileImpl, FileASTNode> pair : task.myOldFileNodes) {
                    FileASTNode oldFileNode;
                    Processor<Document> finishProcessor;
                    PsiFileImpl file2 = (PsiFileImpl)pair.first;
                    if (!file2.isValid() || (finishProcessor = DocumentCommitThread.this.doCommit(task, file2, oldFileNode = (FileASTNode)pair.second)) == null) continue;
                    this.val$finishProcessors.add(finishProcessor);
                }
            }
        };
        if (synchronously) {
            this.myApplication.assertWriteAccessAllowed();
            runnable2.run();
        } else if (!this.myApplication.tryRunReadAction(runnable2)) {
            this.log(project2, "Could not start read action", task, this.myApplication.isReadAccessAllowed(), Thread.currentThread());
            return null;
        }
        boolean canceled = task.indicator.isCanceled();
        assert (!synchronously || !canceled);
        if (canceled) {
            return null;
        }
        return new Runnable((List)finishProcessors, synchronously){
            final /* synthetic */ List val$finishProcessors;
            final /* synthetic */ boolean val$synchronously;
            {
                this.val$finishProcessors = list;
                this.val$synchronously = bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DocumentCommitThread.this.myApplication.assertIsDispatchThread();
                boolean committed = project2.isDisposed() || documentManager.isCommitted(document);
                Object object = DocumentCommitThread.this.lock;
                synchronized (object) {
                    DocumentCommitThread.this.documentsToApplyInEDT.remove((Object)task);
                    if (committed) {
                        DocumentCommitThread.this.log(project2, "Marked as already committed in EDT apply queue, return", task, new Object[0]);
                        return;
                    }
                }
                DocumentCommitThread.this.log(project2, "Executing later finishCommit", task, new Object[0]);
                try {
                    boolean success;
                    boolean changeStillValid = task.modificationStamp == document.getModificationStamp();
                    boolean bl = success = changeStillValid && documentManager.finishCommit(document, this.val$finishProcessors, this.val$synchronously, task.reason);
                    if (this.val$synchronously) assert (success);
                    if (!changeStillValid) {
                        DocumentCommitThread.this.log(project2, "document changed; ignore", task, task.modificationStamp, document.getModificationStamp());
                        return;
                    }
                    DocumentCommitThread.this.log(project2, "after call finishCommit", task, success);
                    if (this.val$synchronously || success) assert (!documentManager.isInUncommittedSet(document));
                    if (!success) {
                        DocumentCommitThread.this.queueCommit(project2, document, "Re-added back", task.myCreationModalityState);
                    }
                }
                catch (Error e) {
                    System.err.println("Log:" + DocumentCommitThread.this.log);
                    throw e;
                }
            }
        };
    }

    @NotNull
    private Processor<Document> handleCommitWithoutPsi(final @NotNull PsiDocumentManagerBase documentManager, @NotNull Document document, final @NotNull DocumentCommitProcessor.CommitTask task) {
        if (documentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentManager", "com/intellij/psi/impl/DocumentCommitThread", "handleCommitWithoutPsi"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/DocumentCommitThread", "handleCommitWithoutPsi"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/psi/impl/DocumentCommitThread", "handleCommitWithoutPsi"));
        }
        final long startDocModificationTimeStamp = document.getModificationStamp();
        Processor<Document> processor2 = new Processor<Document>(){

            public boolean process(Document document) {
                DocumentCommitThread.this.log(task.project, "Finishing without PSI", task, document.getModificationStamp(), startDocModificationTimeStamp);
                if (document.getModificationStamp() != startDocModificationTimeStamp || documentManager.getCachedViewProvider(document) != null) {
                    return false;
                }
                documentManager.handleCommitWithoutPsi(document);
                return true;
            }
        };
        if (processor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/DocumentCommitThread", "handleCommitWithoutPsi"));
        }
        return processor2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEnabled() {
        Object object = this.lock;
        synchronized (object) {
            return this.myEnabled;
        }
    }

    public String toString() {
        return "Document commit thread; application: " + this.myApplication + "; isDisposed: " + this.isDisposed + "; myEnabled: " + this.isEnabled() + "; runningWriteActions: " + this.runningWriteActions;
    }

    public void waitForAllCommits() throws ExecutionException, InterruptedException {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        ((BoundedTaskExecutor)this.executor).waitAllTasksExecuted(100, TimeUnit.SECONDS);
        UIUtil.dispatchAllInvocationEvents();
    }
}

