/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.stubsHierarchy.impl.ClassAnchor;

public class SmartClassAnchor {
    public static final SmartClassAnchor[] EMPTY_ARRAY = new SmartClassAnchor[0];
    public final int myId;
    public final int myFileId;

    public SmartClassAnchor(int id, int fileId) {
        this.myId = id;
        this.myFileId = fileId;
    }

    static SmartClassAnchor create(int symbolId, ClassAnchor classAnchor) {
        if (classAnchor instanceof ClassAnchor.StubClassAnchor) {
            return new StubSmartClassAnchor(symbolId, classAnchor.myFileId, ((ClassAnchor.StubClassAnchor)classAnchor).myStubId);
        }
        if (classAnchor instanceof ClassAnchor.DirectClassAnchor) {
            return new DirectSmartClassAnchor(symbolId, classAnchor.myFileId, ((ClassAnchor.DirectClassAnchor)classAnchor).myPsiClass);
        }
        return null;
    }

    public static class DirectSmartClassAnchor
    extends SmartClassAnchor {
        public final PsiClass myPsiClass;

        public DirectSmartClassAnchor(int id, int fileId, PsiClass psiClass) {
            super(id, fileId);
            this.myPsiClass = psiClass;
        }
    }

    public static class StubSmartClassAnchor
    extends SmartClassAnchor {
        public final int myStubId;

        public StubSmartClassAnchor(int id, int fileId, int stubId) {
            super(id, fileId);
            this.myStubId = stubId;
        }
    }
}

