/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.replaceConstructorWithFactory;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.replaceConstructorWithFactory.ReplaceConstructorWithFactoryViewDescriptor;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceConstructorWithFactoryProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.replaceConstructorWithFactory.ReplaceConstructorWithFactoryProcessor");
    private final PsiMethod myConstructor;
    private final String myFactoryName;
    private final PsiElementFactory myFactory;
    private final PsiClass myOriginalClass;
    private final PsiClass myTargetClass;
    private final PsiManager myManager;
    private final boolean myIsInner;
    private List<PsiElement> myNonNewConstructorUsages;

    public ReplaceConstructorWithFactoryProcessor(Project project2, PsiMethod originalConstructor, PsiClass originalClass, PsiClass targetClass, @NonNls String factoryName) {
        super(project2);
        this.myOriginalClass = originalClass;
        this.myConstructor = originalConstructor;
        this.myTargetClass = targetClass;
        this.myFactoryName = factoryName;
        this.myManager = PsiManager.getInstance((Project)project2);
        this.myFactory = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory();
        this.myIsInner = this.isInner(this.myOriginalClass);
    }

    private boolean isInner(PsiClass originalClass) {
        boolean result = PsiUtil.isInnerClass((PsiClass)originalClass);
        if (result) {
            LOG.assertTrue(PsiTreeUtil.isAncestor((PsiElement)this.myTargetClass, (PsiElement)originalClass, (boolean)false));
        }
        return result;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/replaceConstructorWithFactory/ReplaceConstructorWithFactoryProcessor", "createUsageViewDescriptor"));
        }
        if (this.myConstructor != null) {
            ReplaceConstructorWithFactoryViewDescriptor replaceConstructorWithFactoryViewDescriptor = new ReplaceConstructorWithFactoryViewDescriptor(this.myConstructor);
            if (replaceConstructorWithFactoryViewDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/replaceConstructorWithFactory/ReplaceConstructorWithFactoryProcessor", "createUsageViewDescriptor"));
            }
            return replaceConstructorWithFactoryViewDescriptor;
        }
        ReplaceConstructorWithFactoryViewDescriptor replaceConstructorWithFactoryViewDescriptor = new ReplaceConstructorWithFactoryViewDescriptor(this.myOriginalClass);
        if (replaceConstructorWithFactoryViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/replaceConstructorWithFactory/ReplaceConstructorWithFactoryProcessor", "createUsageViewDescriptor"));
        }
        return replaceConstructorWithFactoryViewDescriptor;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)this.myProject);
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        this.myNonNewConstructorUsages = new ArrayList<PsiElement>();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)(this.myConstructor == null ? this.myOriginalClass : this.myConstructor), (SearchScope)projectScope, (boolean)false)) {
            PsiElement element = reference.getElement();
            if (element.getParent() instanceof PsiNewExpression) {
                usages.add(new UsageInfo(element.getParent()));
                continue;
            }
            if ("super".equals(element.getText()) || "this".equals(element.getText())) {
                this.myNonNewConstructorUsages.add(element);
                continue;
            }
            if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor()) {
                this.myNonNewConstructorUsages.add(element);
                continue;
            }
            if (!(element instanceof PsiClass)) continue;
            this.myNonNewConstructorUsages.add(element);
        }
        UsageInfo[] usageInfoArray = usages.toArray(new UsageInfo[usages.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/replaceConstructorWithFactory/ReplaceConstructorWithFactoryProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        PsiClass constructorContainingClass;
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/refactoring/replaceConstructorWithFactory/ReplaceConstructorWithFactoryProcessor", "preprocessUsages"));
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)this.myProject).getResolveHelper();
        if (!helper.isAccessible((PsiMember)(constructorContainingClass = this.getConstructorContainingClass()), (PsiElement)this.myTargetClass, null)) {
            String message = RefactoringBundle.message((String)"class.0.is.not.accessible.from.target.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)constructorContainingClass, true), RefactoringUIUtil.getDescription((PsiElement)this.myTargetClass, true)});
            conflicts.putValue((Object)constructorContainingClass, (Object)message);
        }
        HashSet<PsiElement> reportedContainers = new HashSet<PsiElement>();
        String targetClassDescription = RefactoringUIUtil.getDescription((PsiElement)this.myTargetClass, true);
        for (UsageInfo usage : usages) {
            PsiElement container = ConflictsUtil.getContainer(usage.getElement());
            if (reportedContainers.contains(container)) continue;
            reportedContainers.add(container);
            if (helper.isAccessible((PsiMember)this.myTargetClass, usage.getElement(), null)) continue;
            String message = RefactoringBundle.message((String)"target.0.is.not.accessible.from.1", (Object[])new Object[]{targetClassDescription, RefactoringUIUtil.getDescription(container, true)});
            conflicts.putValue((Object)this.myTargetClass, (Object)message);
        }
        if (this.myIsInner) {
            for (UsageInfo usage : usages) {
                PsiClass containingClass;
                PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)usage.getElement(), PsiField.class);
                if (field == null || !PsiTreeUtil.isAncestor((PsiElement)(containingClass = field.getContainingClass()), (PsiElement)this.myTargetClass, (boolean)true)) continue;
                String message = RefactoringBundle.message((String)"constructor.being.refactored.is.used.in.initializer.of.0", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)field, true), RefactoringUIUtil.getDescription((PsiElement)constructorContainingClass, false)});
                conflicts.putValue((Object)field, (Object)message);
            }
        }
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts, usages);
    }

    private PsiClass getConstructorContainingClass() {
        if (this.myConstructor != null) {
            return this.myConstructor.getContainingClass();
        }
        return this.myOriginalClass;
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/replaceConstructorWithFactory/ReplaceConstructorWithFactoryProcessor", "performRefactoring"));
        }
        try {
            PsiReferenceExpression classReferenceExpression = this.myFactory.createReferenceExpression(this.myTargetClass);
            PsiReferenceExpression qualifiedMethodReference = (PsiReferenceExpression)this.myFactory.createExpressionFromText("A." + this.myFactoryName, null);
            PsiMethod factoryMethod = (PsiMethod)this.myTargetClass.add((PsiElement)this.createFactoryMethod());
            if (this.myConstructor != null) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)this.myConstructor, (String)"private", (boolean)true);
                VisibilityUtil.escalateVisibility((PsiMember)this.myConstructor, (PsiElement)factoryMethod);
                for (PsiElement place : this.myNonNewConstructorUsages) {
                    VisibilityUtil.escalateVisibility((PsiMember)this.myConstructor, (PsiElement)place);
                }
            }
            if (this.myConstructor == null) {
                PsiMethod constructor = this.myFactory.createConstructor();
                PsiUtil.setModifierProperty((PsiModifierListOwner)constructor, (String)"private", (boolean)true);
                constructor = (PsiMethod)this.getConstructorContainingClass().add((PsiElement)constructor);
                VisibilityUtil.escalateVisibility((PsiMember)constructor, (PsiElement)this.myTargetClass);
            }
            for (UsageInfo usage : usages) {
                PsiNewExpression newExpression = (PsiNewExpression)usage.getElement();
                if (newExpression == null) continue;
                VisibilityUtil.escalateVisibility((PsiMember)factoryMethod, (PsiElement)newExpression);
                PsiMethodCallExpression factoryCall = (PsiMethodCallExpression)this.myFactory.createExpressionFromText(this.myFactoryName + "()", (PsiElement)newExpression);
                factoryCall.getArgumentList().replace((PsiElement)newExpression.getArgumentList());
                boolean replaceMethodQualifier = false;
                PsiExpression newQualifier = newExpression.getQualifier();
                PsiElement resolvedFactoryMethod = factoryCall.getMethodExpression().resolve();
                if (resolvedFactoryMethod != factoryMethod || newQualifier != null) {
                    factoryCall.getMethodExpression().replace((PsiElement)qualifiedMethodReference);
                    replaceMethodQualifier = true;
                }
                if (replaceMethodQualifier) {
                    if (newQualifier == null) {
                        factoryCall.getMethodExpression().getQualifierExpression().replace((PsiElement)classReferenceExpression);
                    } else {
                        factoryCall.getMethodExpression().getQualifierExpression().replace((PsiElement)newQualifier);
                    }
                }
                newExpression.replace((PsiElement)factoryCall);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private PsiMethod createFactoryMethod() throws IncorrectOperationException {
        PsiParameter[] params;
        PsiClass containingClass = this.getConstructorContainingClass();
        PsiClassType type = this.myFactory.createType(containingClass, PsiSubstitutor.EMPTY);
        PsiMethod factoryMethod = this.myFactory.createMethod(this.myFactoryName, (PsiType)type);
        if (this.myConstructor != null) {
            factoryMethod.getParameterList().replace((PsiElement)this.myConstructor.getParameterList());
            factoryMethod.getThrowsList().replace((PsiElement)this.myConstructor.getThrowsList());
        }
        HashSet<String> names = new HashSet<String>();
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)(this.myConstructor != null ? this.myConstructor : containingClass))) {
            if (names.contains(typeParameter.getName())) continue;
            names.add(typeParameter.getName());
            factoryMethod.getTypeParameterList().addAfter((PsiElement)typeParameter, null);
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)this.myFactory.createStatementFromText("return new A();", null);
        PsiNewExpression newExpression = (PsiNewExpression)returnStatement.getReturnValue();
        PsiJavaCodeReferenceElement classRef = this.myFactory.createReferenceElementByType(type);
        newExpression.getClassReference().replace((PsiElement)classRef);
        PsiExpressionList argumentList = newExpression.getArgumentList();
        for (PsiParameter parameter : params = factoryMethod.getParameterList().getParameters()) {
            PsiExpression paramRef = this.myFactory.createExpressionFromText(parameter.getName(), null);
            argumentList.add((PsiElement)paramRef);
        }
        factoryMethod.getBody().add((PsiElement)returnStatement);
        PsiUtil.setModifierProperty((PsiModifierListOwner)factoryMethod, (String)this.getDefaultFactoryVisibility(), (boolean)true);
        if (!this.myIsInner) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)factoryMethod, (String)"static", (boolean)true);
        }
        return (PsiMethod)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)factoryMethod);
    }

    @PsiModifier.ModifierConstant
    private String getDefaultFactoryVisibility() {
        PsiModifierList modifierList = this.myConstructor != null ? this.myConstructor.getModifierList() : this.myOriginalClass.getModifierList();
        return VisibilityUtil.getVisibilityModifier((PsiModifierList)modifierList);
    }

    @Override
    protected String getCommandName() {
        if (this.myConstructor != null) {
            return RefactoringBundle.message((String)"replace.constructor.0.with.a.factory.method", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myConstructor)});
        }
        return RefactoringBundle.message((String)"replace.default.constructor.of.0.with.a.factory.method", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myOriginalClass)});
    }

    public PsiClass getOriginalClass() {
        return this.getConstructorContainingClass();
    }

    public PsiClass getTargetClass() {
        return this.myTargetClass;
    }

    public PsiMethod getConstructor() {
        return this.myConstructor;
    }

    public String getFactoryName() {
        return this.myFactoryName;
    }
}

