/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Computable;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.CloudLoggingHandlerImpl;
import com.intellij.remoteServer.util.CloudNotifier;
import com.intellij.remoteServer.util.ServerRuntimeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CloudApplicationRuntime
extends DeploymentRuntime {
    private static final Logger LOG = Logger.getInstance((String)("#" + CloudApplicationRuntime.class.getName()));
    private final String myApplicationName;
    private Deployment myDeployment;

    public CloudApplicationRuntime(String applicationName) {
        this.myApplicationName = applicationName;
    }

    public String getApplicationName() {
        return this.myApplicationName;
    }

    @Nullable
    public DeploymentStatus getStatus() {
        return null;
    }

    @Nullable
    public String getStatusText() {
        return null;
    }

    public void setDeploymentModel(@NotNull Deployment deployment) {
        if (deployment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployment", "com/intellij/remoteServer/util/CloudApplicationRuntime", "setDeploymentModel"));
        }
        this.myDeployment = deployment;
    }

    protected Deployment getDeploymentModel() {
        return this.myDeployment;
    }

    public CloudNotifier getCloudNotifier() {
        return new CloudNotifier(this.getCloudType().getPresentableName());
    }

    protected abstract ServerTaskExecutor getTaskExecutor();

    protected abstract AgentTaskExecutor getAgentTaskExecutor();

    protected abstract ServerType<?> getCloudType();

    @Nullable
    public String getGroup() {
        return null;
    }

    protected abstract class LoggingTask {
        protected LoggingTask() {
        }

        public void perform(final Project project2, final Runnable onDone) {
            CloudApplicationRuntime.this.getTaskExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        CloudApplicationRuntime.this.getAgentTaskExecutor().execute(new Computable<Object>(){

                            public Object compute() {
                                Deployment deployment = CloudApplicationRuntime.this.getDeploymentModel();
                                CloudLoggingHandlerImpl loggingHandler = deployment == null ? null : new CloudLoggingHandlerImpl(deployment.getOrCreateLogManager(project2)){

                                    @Override
                                    public void println(String message) {
                                        LOG.info(message);
                                    }
                                };
                                LoggingTask.this.run(loggingHandler);
                                return null;
                            }
                        });
                        onDone.run();
                    }
                    catch (ServerRuntimeException e) {
                        CloudApplicationRuntime.this.getCloudNotifier().showMessage(e.getMessage(), MessageType.ERROR);
                    }
                }
            });
        }

        protected abstract void run(CloudAgentLoggingHandler var1);
    }
}

