/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.LightIdeaTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.util.SmartList;
import com.intellij.util.lang.CompoundRuntimeException;
import java.util.List;

public class LightIdeaTestFixtureImpl
extends BaseFixture
implements LightIdeaTestFixture {
    private final LightProjectDescriptor myProjectDescriptor;
    private CodeStyleSettings myOldCodeStyleSettings;

    public LightIdeaTestFixtureImpl(LightProjectDescriptor projectDescriptor) {
        this.myProjectDescriptor = projectDescriptor;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        IdeaTestApplication application = LightPlatformTestCase.initApplication();
        LightPlatformTestCase.doSetup(this.myProjectDescriptor, LocalInspectionTool.EMPTY_ARRAY, this.getTestRootDisposable());
        InjectedLanguageManagerImpl.pushInjectors(this.getProject());
        this.myOldCodeStyleSettings = this.getCurrentCodeStyleSettings().clone();
        this.myOldCodeStyleSettings.getIndentOptions((FileType)StdFileTypes.JAVA);
        application.setDataProvider(new TestDataProvider(this.getProject()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        Project project2 = this.getProject();
        CodeStyleSettingsManager.getInstance((Project)project2).dropTemporarySettings();
        CodeStyleSettings oldCodeStyleSettings = this.myOldCodeStyleSettings;
        this.myOldCodeStyleSettings = null;
        SmartList exceptions = new SmartList();
        try {
            UsefulTestCase.doCheckForSettingsDamage(oldCodeStyleSettings, this.getCurrentCodeStyleSettings(), (List<Throwable>)exceptions);
            LightPlatformTestCase.doTearDown(project2, LightPlatformTestCase.getApplication(), true, (List<Throwable>)exceptions);
            super.tearDown();
            InjectedLanguageManagerImpl.checkInjectorsAreDisposed(project2);
            PersistentFS.getInstance().clearIdCache();
            PlatformTestCase.cleanupApplicationCaches(project2);
        }
        finally {
            CompoundRuntimeException.throwIfNotEmpty((List)exceptions);
        }
    }

    @Override
    public Project getProject() {
        return LightPlatformTestCase.getProject();
    }

    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        if (CodeStyleSchemes.getInstance().getCurrentScheme() == null) {
            return new CodeStyleSettings();
        }
        return CodeStyleSettingsManager.getSettings((Project)this.getProject());
    }

    @Override
    public Module getModule() {
        return LightPlatformTestCase.getModule();
    }
}

