/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import org.jetbrains.annotations.NotNull;

public class BalloonLayoutConfiguration {
    public final int iconPanelWidth;
    public final Dimension iconOffset;
    public final int topSpaceHeight;
    public final int titleContentSpaceHeight;
    public final int contentActionsSpaceHeight;
    public final int titleActionsSpaceHeight;
    public final int bottomSpaceHeight;
    public final int actionGap;
    public final Dimension rightActionsOffset;
    public final int closeOffset;
    public final int gearCloseSpace;
    public final int allActionsOffset;
    public final int beforeGearSpace;
    public static final int FixedWidth;
    public static final int MaxWidth;
    public static final int MinWidth;
    public static final String MaxWidthStyle;
    public static final int NotificationSpace;

    @NotNull
    public static BalloonLayoutConfiguration create(@NotNull Notification notification, @NotNull BalloonLayoutData layoutData) {
        boolean actions;
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/ui/BalloonLayoutConfiguration", "create"));
        }
        if (layoutData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutData", "com/intellij/ui/BalloonLayoutConfiguration", "create"));
        }
        boolean title = notification.isTitle();
        boolean content = notification.isContent();
        boolean bl = actions = !notification.getActions().isEmpty();
        if (title && content && actions) {
            BalloonLayoutConfiguration balloonLayoutConfiguration = BalloonLayoutConfiguration.treeLines();
            if (balloonLayoutConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/BalloonLayoutConfiguration", "create"));
            }
            return balloonLayoutConfiguration;
        }
        if (content && NotificationsManagerImpl.calculateContentHeight(title || actions ? 1 : 2) < layoutData.fullHeight) {
            BalloonLayoutConfiguration balloonLayoutConfiguration = BalloonLayoutConfiguration.treeLines();
            if (balloonLayoutConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/BalloonLayoutConfiguration", "create"));
            }
            return balloonLayoutConfiguration;
        }
        BalloonLayoutConfiguration balloonLayoutConfiguration = BalloonLayoutConfiguration.twoLines();
        if (balloonLayoutConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/BalloonLayoutConfiguration", "create"));
        }
        return balloonLayoutConfiguration;
    }

    @NotNull
    private static BalloonLayoutConfiguration twoLines() {
        BalloonLayoutConfiguration balloonLayoutConfiguration = new BalloonLayoutConfiguration((Dimension)new JBDimension(10, 11), JBUI.scale((int)11), JBUI.scale((int)5), JBUI.scale((int)5), JBUI.scale((int)5), JBUI.scale((int)14));
        if (balloonLayoutConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/BalloonLayoutConfiguration", "twoLines"));
        }
        return balloonLayoutConfiguration;
    }

    @NotNull
    private static BalloonLayoutConfiguration treeLines() {
        BalloonLayoutConfiguration balloonLayoutConfiguration = new BalloonLayoutConfiguration((Dimension)new JBDimension(10, 7), JBUI.scale((int)7), JBUI.scale((int)3), JBUI.scale((int)7), 0, JBUI.scale((int)8));
        if (balloonLayoutConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/BalloonLayoutConfiguration", "treeLines"));
        }
        return balloonLayoutConfiguration;
    }

    private BalloonLayoutConfiguration(@NotNull Dimension iconOffset, int topSpaceHeight, int titleContentSpaceHeight, int contentActionsSpaceHeight, int titleActionsSpaceHeight, int bottomSpaceHeight) {
        if (iconOffset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iconOffset", "com/intellij/ui/BalloonLayoutConfiguration", "<init>"));
        }
        this(JBUI.scale((int)32), iconOffset, topSpaceHeight, titleContentSpaceHeight, contentActionsSpaceHeight, titleActionsSpaceHeight, bottomSpaceHeight, JBUI.scale((int)16), (Dimension)new JBDimension(8, 6), JBUI.scale((int)7), JBUI.scale((int)5), JBUI.scale((int)15));
    }

    private BalloonLayoutConfiguration(int iconPanelWidth, @NotNull Dimension iconOffset, int topSpaceHeight, int titleContentSpaceHeight, int contentActionsSpaceHeight, int titleActionsSpaceHeight, int bottomSpaceHeight, int actionGap, @NotNull Dimension rightActionsOffset, int afterGearSpace, int beforeCloseSpace, int beforeGearSpace) {
        if (iconOffset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iconOffset", "com/intellij/ui/BalloonLayoutConfiguration", "<init>"));
        }
        if (rightActionsOffset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightActionsOffset", "com/intellij/ui/BalloonLayoutConfiguration", "<init>"));
        }
        this.iconPanelWidth = iconPanelWidth;
        this.iconOffset = iconOffset;
        this.topSpaceHeight = topSpaceHeight;
        this.titleContentSpaceHeight = titleContentSpaceHeight;
        this.contentActionsSpaceHeight = contentActionsSpaceHeight;
        this.titleActionsSpaceHeight = titleActionsSpaceHeight;
        this.bottomSpaceHeight = bottomSpaceHeight;
        this.actionGap = actionGap;
        this.rightActionsOffset = rightActionsOffset;
        this.closeOffset = beforeCloseSpace + AllIcons.Ide.Notification.Close.getIconWidth() + rightActionsOffset.width;
        this.gearCloseSpace = afterGearSpace + beforeCloseSpace;
        this.allActionsOffset = this.closeOffset + afterGearSpace + AllIcons.Ide.Notification.Gear.getIconWidth();
        this.beforeGearSpace = beforeGearSpace;
    }

    static {
        int styleWidth;
        int width;
        MinWidth = JBUI.scale((int)100);
        if (SystemInfo.isMac) {
            width = 360;
            styleWidth = 240;
        } else if (SystemInfo.isLinux) {
            width = 410;
            styleWidth = 270;
        } else {
            width = 330;
            styleWidth = 205;
        }
        width += AllIcons.Ide.Notification.Shadow.Left.getIconWidth();
        FixedWidth = JBUI.scale((int)(width += AllIcons.Ide.Notification.Shadow.Right.getIconWidth()));
        MaxWidth = JBUI.scale((int)(width - 60));
        MaxWidthStyle = "width:" + JBUI.scale((int)styleWidth) + "px;";
        NotificationSpace = JBUI.scale((int)10);
    }
}

