/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.FontInfoRenderer;
import com.intellij.util.ui.FontInfo;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.ListCellRenderer;

public final class FontComboBox
extends ComboBox {
    private static final FontInfoRenderer RENDERER = new FontInfoRenderer();
    private Model myModel;

    public FontComboBox() {
        this(false);
    }

    public FontComboBox(boolean withAllStyles) {
        super((ComboBoxModel)new Model(withAllStyles));
        this.setRenderer((ListCellRenderer)((Object)RENDERER));
    }

    public boolean isMonospacedOnly() {
        return this.myModel.myMonospacedOnly;
    }

    public void setMonospacedOnly(boolean monospaced) {
        if (this.myModel.myMonospacedOnly != monospaced) {
            this.myModel.myMonospacedOnly = monospaced;
            Object item = this.myModel.getSelectedItem();
            this.myModel.setSelectedItem(null);
            this.myModel.setSelectedItem(item);
        }
    }

    public String getFontName() {
        Object item = this.myModel.getSelectedItem();
        return item == null ? null : item.toString();
    }

    public void setFontName(String item) {
        this.myModel.setSelectedItem(item);
    }

    public void setModel(ComboBoxModel model) {
        if (!(model instanceof Model)) {
            throw new UnsupportedOperationException();
        }
        this.myModel = (Model)model;
        super.setModel(model);
    }

    private static final class Model
    extends AbstractListModel
    implements ComboBoxModel {
        private final List<FontInfo> myAllFonts;
        private final List<FontInfo> myMonoFonts;
        private boolean myMonospacedOnly;
        private Object mySelectedItem;

        private Model(boolean withAllStyles) {
            this.myAllFonts = FontInfo.getAll((boolean)withAllStyles);
            this.myMonoFonts = new ArrayList<FontInfo>();
            for (FontInfo info : this.myAllFonts) {
                if (!info.isMonospaced()) continue;
                this.myMonoFonts.add(info);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.mySelectedItem;
        }

        @Override
        public void setSelectedItem(Object item) {
            FontInfo info;
            if (item instanceof FontInfo && (info = this.getInfo(item)) == null) {
                List<FontInfo> list = this.myMonospacedOnly ? this.myMonoFonts : this.myAllFonts;
                Object object = item = list.isEmpty() ? null : list.get(0);
            }
            if (item instanceof String && (info = this.getInfo(item)) != null) {
                item = info;
            }
            if (!(this.mySelectedItem != null ? this.mySelectedItem.equals(item) : item == null)) {
                this.mySelectedItem = item;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public int getSize() {
            List<FontInfo> list = this.myMonospacedOnly ? this.myMonoFonts : this.myAllFonts;
            return this.mySelectedItem instanceof String ? 1 + list.size() : list.size();
        }

        @Override
        public Object getElementAt(int index) {
            List<FontInfo> list = this.myMonospacedOnly ? this.myMonoFonts : this.myAllFonts;
            return 0 <= index && index < list.size() ? list.get(index) : this.mySelectedItem;
        }

        private FontInfo getInfo(Object item) {
            for (FontInfo info : this.myMonospacedOnly ? this.myMonoFonts : this.myAllFonts) {
                if (!(item instanceof String ? info.toString().equalsIgnoreCase((String)item) : info.equals(item))) continue;
                return info;
            }
            return null;
        }
    }
}

