/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.plaf.gtk;

import com.intellij.Patches;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import sun.swing.SwingUtilities2;

public class GtkPaintingUtil {
    private static final String V6_SYNTH_UI_CLASS = "sun.swing.plaf.synth.SynthUI";
    private static final String V7_SYNTH_UI_CLASS = "javax.swing.plaf.synth.SynthUI";

    private GtkPaintingUtil() {
    }

    public static Color getForeground(BasicMenuItemUI ui, JMenuItem menuItem) {
        SynthContext context = GtkPaintingUtil.getSynthContext(ui, menuItem);
        return context.getStyle().getColor(context, ColorType.TEXT_FOREGROUND);
    }

    public static void paintDisabledText(BasicMenuItemUI originalUI, Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)menuItem, g);
        int index = menuItem.getDisplayedMnemonicIndex();
        Color fg = GtkPaintingUtil.getForeground(originalUI, menuItem);
        Color shadow = UIUtil.shade((Color)menuItem.getBackground(), (double)1.24, (double)0.5);
        g.setColor(shadow);
        SwingUtilities2.drawStringUnderlineCharAt(menuItem, g, text, index, textRect.x + 1, textRect.y + fm.getAscent() + 1);
        g.setColor(fg);
        SwingUtilities2.drawStringUnderlineCharAt(menuItem, g, text, index, textRect.x, textRect.y + fm.getAscent());
    }

    public static boolean isSynthUI(MenuItemUI ui) {
        for (Class<?> aClass = ui.getClass(); aClass != null && aClass.getSimpleName().contains("Synth"); aClass = aClass.getSuperclass()) {
            for (Class<?> anInterface : aClass.getInterfaces()) {
                if (!V6_SYNTH_UI_CLASS.equals(anInterface.getName()) && !V7_SYNTH_UI_CLASS.equals(anInterface.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static SynthContext getSynthContext(MenuItemUI ui, JComponent item) {
        assert (Patches.USE_REFLECTION_TO_ACCESS_JDK7);
        try {
            Method getContext = ui.getClass().getMethod("getContext", JComponent.class);
            getContext.setAccessible(true);
            return (SynthContext)getContext.invoke((Object)ui, item);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

