/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.impl.VcsUserImpl;
import com.intellij.vcs.log.ui.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.filter.VcsLogUserFilterImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class MyCommitsHighlighter
implements VcsLogHighlighter {
    @NotNull
    private final VcsLogDataHolder myDataHolder;
    @NotNull
    private final VcsLogUi myLogUi;
    private boolean myShouldHighlightUser;

    public MyCommitsHighlighter(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUi logUi) {
        if (logDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "<init>"));
        }
        if (logUi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logUi", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "<init>"));
        }
        this.myShouldHighlightUser = false;
        this.myDataHolder = logDataHolder;
        this.myLogUi = logUi;
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(@NotNull VcsShortCommitDetails details, boolean isSelected) {
        VcsUser currentUser;
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "getStyle"));
        }
        if (!this.myLogUi.isHighlighterEnabled("MY_COMMITS")) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            if (vcsCommitStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "getStyle"));
            }
            return vcsCommitStyle;
        }
        if (this.myShouldHighlightUser && (currentUser = this.myDataHolder.getCurrentUser().get(details.getRoot())) != null && VcsUserImpl.isSamePerson(currentUser, details.getAuthor())) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.bold();
            if (vcsCommitStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "getStyle"));
            }
            return vcsCommitStyle;
        }
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        if (vcsCommitStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "getStyle"));
        }
        return vcsCommitStyle;
    }

    public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "update"));
        }
        this.myShouldHighlightUser = !this.isSingleUser() && !MyCommitsHighlighter.isFilteredByCurrentUser(dataPack.getFilters());
    }

    private boolean isSingleUser() {
        NotNullFunction<VcsUser, String> nameToString = new NotNullFunction<VcsUser, String>(){

            @NotNull
            public String fun(VcsUser user) {
                String string = VcsUserImpl.getNameInStandardForm(user.getName());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter$1", "fun"));
                }
                return string;
            }
        };
        HashSet allUserNames = ContainerUtil.newHashSet((Iterable)ContainerUtil.map(this.myDataHolder.getAllUsers(), (Function)nameToString));
        HashSet currentUserNames = ContainerUtil.newHashSet((Iterable)ContainerUtil.map(this.myDataHolder.getCurrentUser().values(), (Function)nameToString));
        return allUserNames.size() == currentUserNames.size() && currentUserNames.containsAll(allUserNames);
    }

    private static boolean isFilteredByCurrentUser(@NotNull VcsLogFilterCollection filters) {
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/vcs/log/ui/MyCommitsHighlighter", "isFilteredByCurrentUser"));
        }
        VcsLogUserFilter userFilter = filters.getUserFilter();
        if (userFilter == null) {
            return false;
        }
        Collection<String> filterByName = ((VcsLogUserFilterImpl)userFilter).getUserNamesForPresentation();
        return Collections.singleton("me").containsAll(filterByName);
    }

    public static class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        private static final String ID = "MY_COMMITS";

        @Override
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUi logUi) {
            if (logDataHolder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/MyCommitsHighlighter$Factory", "createHighlighter"));
            }
            if (logUi == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logUi", "com/intellij/vcs/log/ui/MyCommitsHighlighter$Factory", "createHighlighter"));
            }
            MyCommitsHighlighter myCommitsHighlighter = new MyCommitsHighlighter(logDataHolder, logUi);
            if (myCommitsHighlighter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter$Factory", "createHighlighter"));
            }
            return myCommitsHighlighter;
        }

        @Override
        @NotNull
        public String getId() {
            if (ID == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter$Factory", "getId"));
            }
            return ID;
        }

        @Override
        @NotNull
        public String getTitle() {
            if ("My Commits" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MyCommitsHighlighter$Factory", "getTitle"));
            }
            return "My Commits";
        }

        @Override
        public boolean showMenuItem() {
            return true;
        }
    }
}

