/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.TableView;
import com.intellij.util.Alarm;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.jsonSchema.JsonSchemaMappingsConfigurationBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaMappingsView {
    private static final String ADD_SCHEMA_MAPPING = "settings.json.schema.add.mapping";
    private TableView<JsonSchemaMappingsConfigurationBase.Item> myTableView;
    private ToolbarDecorator myDecorator;
    private JComponent myComponent;
    private Project myProject;
    private TextFieldWithBrowseButton mySchemaField;

    public JsonSchemaMappingsView(Project project2) {
        this.createUI(project2);
    }

    private void createUI(Project project2) {
        this.myProject = project2;
        this.myTableView = new TableView();
        this.myTableView.getTableHeader().setVisible(false);
        this.myDecorator = ToolbarDecorator.createDecorator(this.myTableView);
        this.myDecorator.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int[] rows = JsonSchemaMappingsView.this.myTableView.getSelectedRows();
                if (rows != null && rows.length > 0) {
                    int cnt = 0;
                    for (int row : rows) {
                        JsonSchemaMappingsView.this.myTableView.getListTableModel().removeRow(row - cnt);
                        ++cnt;
                    }
                    JsonSchemaMappingsView.this.myTableView.getListTableModel().fireTableDataChanged();
                }
            }
        }).setAddAction((AnActionButtonRunnable)new MyAddActionButtonRunnable(project2)).disableUpDownActions();
        JPanel wrapper = new JPanel(new BorderLayout());
        JPanel wrapper2 = new JPanel(new BorderLayout());
        this.mySchemaField = new TextFieldWithBrowseButton();
        SwingHelper.installFileCompletionAndBrowseDialog(this.myProject, this.mySchemaField, "Select JSON Schema File", FileChooserDescriptorFactory.createSingleFileDescriptor());
        this.attachNavigateToSchema();
        JBLabel label = new JBLabel("JSON schema file:");
        wrapper2.add((Component)label, "West");
        label.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)0, (int)10));
        wrapper2.add((Component)this.mySchemaField, "Center");
        wrapper2.setBorder((Border)JBUI.Borders.empty((int)0, (int)10, (int)10, (int)10));
        wrapper.add((Component)wrapper2, "North");
        wrapper.add((Component)this.myDecorator.createPanel(), "Center");
        this.myComponent = wrapper;
    }

    private void attachNavigateToSchema() {
        new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                String pathToSchema = JsonSchemaMappingsView.this.mySchemaField.getText();
                if (StringUtil.isEmptyOrSpaces((String)pathToSchema)) {
                    return;
                }
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(pathToSchema));
                if (virtualFile == null) {
                    BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder("File not found", UIUtil.getBalloonErrorIcon(), MessageType.ERROR.getPopupBackground(), null);
                    Balloon balloon = balloonBuilder.setFadeoutTime(TimeUnit.SECONDS.toMillis(3L)).createBalloon();
                    balloon.showInCenterOf((JComponent)JsonSchemaMappingsView.this.mySchemaField);
                    return;
                }
                new OpenFileDescriptor(JsonSchemaMappingsView.this.myProject, virtualFile).navigate(true);
            }
        }.registerCustomShortcutSet(CommonShortcuts.getEditSource(), (JComponent)this.mySchemaField);
    }

    public List<JsonSchemaMappingsConfigurationBase.Item> getData() {
        List items = this.myTableView.getListTableModel().getItems();
        return items;
    }

    public void setItems(VirtualFile schemaFile, List<JsonSchemaMappingsConfigurationBase.Item> data) {
        this.mySchemaField.setText(FileUtil.toSystemDependentName((String)schemaFile.getPath()));
        this.myTableView.setModelAndUpdateColumns(new ListTableModel(JsonSchemaMappingsView.createColumns(), new ArrayList<JsonSchemaMappingsConfigurationBase.Item>(data)));
    }

    public String getSchemaSubPath() {
        return FileUtil.toSystemDependentName((String)this.getRelativePath(this.myProject, this.mySchemaField.getText()));
    }

    private static ColumnInfo[] createColumns() {
        return new ColumnInfo[]{new ColumnInfo<JsonSchemaMappingsConfigurationBase.Item, String>(""){

            @Nullable
            public String valueOf(JsonSchemaMappingsConfigurationBase.Item item) {
                String prefix = item.isPattern() ? "Pattern: " : (item.isDirectory() ? "Directory: " : "File: ");
                return prefix + item.getPath();
            }
        }};
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    private String getRelativePath(@NotNull Project project2, @NotNull String text) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/JsonSchemaMappingsView", "getRelativePath"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/jsonSchema/JsonSchemaMappingsView", "getRelativePath"));
        }
        if (project2.isDefault()) {
            return text;
        }
        String relativePath = FileUtil.getRelativePath((File)new File(project2.getBasePath()), (File)new File(text));
        return relativePath == null ? text : relativePath;
    }

    private class MyAddActionButtonRunnable
    implements AnActionButtonRunnable {
        private final Project myProject;

        public MyAddActionButtonRunnable(Project project2) {
            this.myProject = project2;
        }

        public void run(AnActionButton button) {
            JBPanel panel = new JBPanel((LayoutManager)new GridBagLayout());
            GridBag bag = new GridBag();
            final JBTextField patternField = new JBTextField();
            final TextFieldWithBrowseButton directoryField = new TextFieldWithBrowseButton();
            final TextFieldWithBrowseButton fileField = new TextFieldWithBrowseButton();
            bag.setDefaultAnchor(18);
            final JBRadioButton radioPattern = new JBRadioButton("Filename pattern:");
            final JBRadioButton radioDirectory = new JBRadioButton("Files under:");
            final JBRadioButton radioFile = new JBRadioButton("File:");
            panel.add((Component)radioDirectory, (Object)bag.nextLine().next().fillCellNone().weightx(0.0));
            panel.add((Component)directoryField, (Object)bag.next().fillCellHorizontally().weightx(1.0));
            panel.add((Component)radioPattern, (Object)bag.nextLine().next().fillCellNone().weightx(0.0));
            panel.add((Component)patternField, (Object)bag.next().fillCellHorizontally().weightx(1.0));
            panel.add((Component)radioFile, (Object)bag.nextLine().next().fillCellNone().weightx(0.0));
            panel.add((Component)fileField, (Object)bag.next().fillCellHorizontally().weightx(1.0));
            SwingHelper.installFileCompletionAndBrowseDialog(this.myProject, directoryField, "Select Folder", FileChooserDescriptorFactory.createSingleFolderDescriptor());
            SwingHelper.installFileCompletionAndBrowseDialog(this.myProject, fileField, "Select File", FileChooserDescriptorFactory.createSingleFileDescriptor());
            ButtonGroup group = new ButtonGroup();
            group.add((AbstractButton)radioPattern);
            group.add((AbstractButton)radioDirectory);
            group.add((AbstractButton)radioFile);
            radioDirectory.setSelected(true);
            patternField.setMinimumSize(new Dimension(JBUI.scale((int)200), UIUtil.getInformationIcon().getIconHeight()));
            patternField.getEmptyText().setText("Example: *.config.json");
            final DialogBuilder builder = new DialogBuilder();
            builder.setTitle("Add JSON Schema Mapping");
            builder.setNorthPanel((JComponent)panel);
            builder.setPreferredFocusComponent((JComponent)directoryField);
            builder.setDimensionServiceKey("com.jetbrains.jsonSchema.JsonSchemaMappingsView#add");
            builder.setHelpId(JsonSchemaMappingsView.ADD_SCHEMA_MAPPING);
            Getter<String> textGetter = new Getter<String>(){

                public String get() {
                    if (radioPattern.isSelected()) {
                        return patternField.getText();
                    }
                    String text = radioDirectory.isSelected() ? directoryField.getText() : fileField.getText();
                    return JsonSchemaMappingsView.this.getRelativePath(MyAddActionButtonRunnable.this.myProject, text);
                }
            };
            Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
            final Runnable updaterValidator = new Runnable((Getter)textGetter, alarm){
                final /* synthetic */ Getter val$textGetter;
                final /* synthetic */ Alarm val$alarm;
                {
                    this.val$textGetter = getter;
                    this.val$alarm = alarm;
                }

                @Override
                public void run() {
                    if (!patternField.isVisible()) {
                        return;
                    }
                    patternField.setEnabled(radioPattern.isSelected());
                    directoryField.setEnabled(radioDirectory.isSelected());
                    fileField.setEnabled(radioFile.isSelected());
                    builder.setOkActionEnabled(!StringUtil.isEmptyOrSpaces((String)((String)this.val$textGetter.get())));
                    this.val$alarm.addRequest((Runnable)this, 300, ModalityState.any());
                }
            };
            alarm.addRequest(updaterValidator, 300, ModalityState.any());
            updaterValidator.run();
            ActionListener listener2 = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    updaterValidator.run();
                }
            };
            radioPattern.addActionListener(listener2);
            radioDirectory.addActionListener(listener2);
            radioFile.addActionListener(listener2);
            if (this.myProject == null || this.myProject.getBasePath() == null) {
                radioDirectory.setEnabled(false);
                radioFile.setEnabled(false);
                directoryField.setEnabled(false);
                fileField.setEnabled(false);
            }
            if (builder.showAndGet()) {
                String pattern = (String)textGetter.get();
                JsonSchemaMappingsConfigurationBase.Item item = new JsonSchemaMappingsConfigurationBase.Item(pattern, radioPattern.isSelected(), radioDirectory.isSelected());
                JsonSchemaMappingsView.this.myTableView.getListTableModel().addRow((Object)item);
            }
            Disposer.dispose((Disposable)alarm);
        }
    }
}

