/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.idea.RareLogger;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaImportedProviderMarker;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaObjectCodeInsightWrapper;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import java.io.Reader;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaServiceImpl
implements JsonSchemaService {
    private static final Logger LOGGER = Logger.getInstance(JsonSchemaServiceImpl.class);
    private static final Logger RARE_LOGGER = RareLogger.wrap(LOGGER, false);
    @Nullable
    private final Project myProject;
    private final ConcurrentMap<JsonSchemaFileProvider, JsonSchemaObjectCodeInsightWrapper> myWrappers = ContainerUtil.newConcurrentMap();

    public JsonSchemaServiceImpl(@Nullable Project project2) {
        this.myProject = project2;
    }

    @NotNull
    protected JsonSchemaProviderFactory[] getProviderFactories() {
        JsonSchemaProviderFactory[] jsonSchemaProviderFactoryArray = (JsonSchemaProviderFactory[])JsonSchemaProviderFactory.EP_NAME.getExtensions();
        if (jsonSchemaProviderFactoryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "getProviderFactories"));
        }
        return jsonSchemaProviderFactoryArray;
    }

    @Override
    @Nullable
    public Annotator getAnnotator(@Nullable VirtualFile file2) {
        JsonSchemaObjectCodeInsightWrapper wrapper = this.getWrapper(file2);
        return wrapper != null ? wrapper.getAnnotator() : null;
    }

    @Override
    @Nullable
    public CompletionContributor getCompletionContributor(@Nullable VirtualFile file2) {
        JsonSchemaObjectCodeInsightWrapper wrapper = this.getWrapper(file2);
        return wrapper != null ? wrapper.getContributor() : null;
    }

    @Override
    public boolean hasSchema(@Nullable VirtualFile file2) {
        JsonSchemaObjectCodeInsightWrapper wrapper = this.getWrapper(file2);
        return wrapper != null;
    }

    @Override
    @Nullable
    public DocumentationProvider getDocumentationProvider(@Nullable VirtualFile file2) {
        JsonSchemaObjectCodeInsightWrapper wrapper = this.getWrapper(file2);
        return wrapper != null ? wrapper.getDocumentationProvider() : null;
    }

    @Nullable
    private static JsonSchemaObjectCodeInsightWrapper createWrapper(@NotNull JsonSchemaFileProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl", "createWrapper"));
        }
        Reader reader = provider.getSchemaReader();
        try {
            if (reader != null) {
                JsonSchemaObject resultObject = new JsonSchemaReader().read(reader);
                return new JsonSchemaObjectCodeInsightWrapper(resultObject);
            }
        }
        catch (Exception e) {
            String message = "Error while processing json schema file: " + e.getMessage();
            if (provider instanceof JsonSchemaImportedProviderMarker) {
                RARE_LOGGER.info(message, (Throwable)e);
            }
            LOGGER.error(message, (Throwable)e);
        }
        return null;
    }

    @Override
    public void reset() {
        this.myWrappers.clear();
    }

    @Nullable
    private JsonSchemaObjectCodeInsightWrapper getWrapper(@Nullable VirtualFile file2) {
        JsonSchemaProviderFactory[] factories;
        if (file2 == null) {
            return null;
        }
        for (JsonSchemaProviderFactory factory : factories = this.getProviderFactories()) {
            for (JsonSchemaFileProvider provider : factory.getProviders(this.myProject)) {
                if (!provider.isAvailable(file2)) continue;
                JsonSchemaObjectCodeInsightWrapper wrapper = (JsonSchemaObjectCodeInsightWrapper)this.myWrappers.get(provider);
                if (wrapper == null) {
                    JsonSchemaObjectCodeInsightWrapper newWrapper = JsonSchemaServiceImpl.createWrapper(provider);
                    if (newWrapper == null) {
                        return null;
                    }
                    this.myWrappers.putIfAbsent(provider, newWrapper);
                    wrapper = (JsonSchemaObjectCodeInsightWrapper)this.myWrappers.get(provider);
                }
                if (wrapper == null) continue;
                return wrapper;
            }
        }
        return null;
    }
}

