/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.Function;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.ValueModifierUtilKt;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ,\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bJ\u001c\u0010\u0012\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00142\u0006\u0010\u0015\u001a\u00020\u0016J3\u0010\u0017\u001a\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n\u00a2\u0006\u0002\b\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/debugger/ValueModifierUtil;", "", "()V", "appendUnquotedName", "", "builder", "Ljava/lang/StringBuilder;", "name", "", "evaluateGet", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/values/Value;", "variable", "Lorg/jetbrains/debugger/Variable;", "host", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "selfName", "propertyNamesToString", "list", "", "quotedAware", "", "setValue", "Lorg/jetbrains/annotations/NotNull;", "newValue", "modifier", "Lorg/jetbrains/debugger/ValueModifier;", "script-debugger-backend"})
public final class ValueModifierUtil {
    public static final ValueModifierUtil INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Promise<Object> setValue(@NotNull Variable variable, @NotNull String newValue, @NotNull EvaluateContext evaluateContext2, @NotNull ValueModifier modifier) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)newValue, (String)"newValue");
        Intrinsics.checkParameterIsNotNull((Object)evaluateContext2, (String)"evaluateContext");
        Intrinsics.checkParameterIsNotNull((Object)modifier, (String)"modifier");
        Promise promise2 = EvaluateContext.DefaultImpls.evaluate$default(evaluateContext2, newValue, null, false, 6, null);
        return $receiver$iv.thenAsync((AsyncFunction)new AsyncFunction<EvaluateResult, Object>(modifier, variable, evaluateContext2){
            final /* synthetic */ ValueModifier $modifier$inlined;
            final /* synthetic */ Variable $variable$inlined;
            final /* synthetic */ EvaluateContext $evaluateContext$inlined;

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Promise fun(Object param) {
                EvaluateResult it = (EvaluateResult)param;
                Promise<?> promise2 = this.$modifier$inlined.setValue(this.$variable$inlined, it.getValue(), this.$evaluateContext$inlined);
                if (promise2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<kotlin.Any?>");
                }
                return promise2;
            }
            {
                this.$modifier$inlined = valueModifier;
                this.$variable$inlined = variable;
                this.$evaluateContext$inlined = evaluateContext2;
            }
        });
    }

    @NotNull
    public final Promise<Value> evaluateGet(@NotNull Variable variable, @NotNull Object host, @NotNull EvaluateContext evaluateContext2, @NotNull String selfName) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)evaluateContext2, (String)"evaluateContext");
        Intrinsics.checkParameterIsNotNull((Object)selfName, (String)"selfName");
        StringBuilder builder = new StringBuilder(selfName);
        String string = variable.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variable.name");
        this.appendUnquotedName(builder, string);
        String string2 = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"builder.toString()");
        Promise promise2 = evaluateContext2.evaluate(string2, Collections.singletonMap(selfName, host), false).then(new Function<? super T, ? extends SUB_RESULT>(variable){
            final /* synthetic */ Variable $variable;

            @NotNull
            public final Value fun(EvaluateResult it) {
                this.$variable.setValue(it.getValue());
                return it.getValue();
            }
            {
                this.$variable = variable;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"evaluateContext.evaluate\u2026\n        it.value\n      }");
        return promise2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String propertyNamesToString(@NotNull List<String> list, boolean quotedAware) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        StringBuilder builder = new StringBuilder();
        IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)CollectionsKt.getIndices((Collection)list)));
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = n;
        int n5 = n2;
        if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
            while (true) {
                void i;
                String name = list.get((int)i);
                ValueModifierUtilKt.access$doAppendName(builder, name, quotedAware && (name.charAt(0) == '\"' || name.charAt(0) == '\''));
                if (i == n2) break;
                i += n3;
            }
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    public final void appendUnquotedName(@NotNull StringBuilder builder, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        ValueModifierUtilKt.access$doAppendName(builder, name, false);
    }

    private ValueModifierUtil() {
        INSTANCE = this;
    }

    static {
        new ValueModifierUtil();
    }
}

