/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.google.gson.stream.JsonToken;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.UtilKt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.Base64VLQ;
import org.jetbrains.debugger.sourcemap.CharSequenceIterator;
import org.jetbrains.debugger.sourcemap.GeneratedMappingList;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.NamedEntry;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceMapDecoderKt;
import org.jetbrains.debugger.sourcemap.SourceMappingList;
import org.jetbrains.debugger.sourcemap.SourceResolver;
import org.jetbrains.debugger.sourcemap.UnmappedEntry;
import org.jetbrains.debugger.sourcemap.UnnamedEntry;
import org.jetbrains.io.JsonReaderEx;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\u001a8\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2&\u0010\f\u001a\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u00100\r\u001a1\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\u0014\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00120\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0016\u001a\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001aX\u0010\u001b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u00122&\u0010\f\u001a\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u00100\rH\u0002\u001aY\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00072\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\u0014\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00120\u00142\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010'\u001a\u0018\u0010(\u001a\n )*\u0004\u0018\u00010\u000f0\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a \u0010*\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010+\u001a\u0004\u0018\u00010\u000fH\u0002\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"MAPPING_COMPARATOR_BY_GENERATED_POSITION", "Ljava/util/Comparator;", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "getMAPPING_COMPARATOR_BY_GENERATED_POSITION", "()Ljava/util/Comparator;", "MAPPING_COMPARATOR_BY_SOURCE_POSITION", "UNMAPPED", "", "decodeSourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "in", "", "sourceResolverFactory", "Lkotlin/Function2;", "", "", "Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "getMapping", "", "reverseMappingsBySourceUrl", "", "sourceIndex", "([Ljava/util/List;I)Ljava/util/List;", "isSeparator", "", "charIterator", "Lorg/jetbrains/debugger/sourcemap/CharSequenceIterator;", "parseMap", "reader", "Lorg/jetbrains/io/JsonReaderEx;", "line", "column", "mappings", "readMappings", "", "value", "initialLine", "initialColumn", "names", "(Ljava/lang/String;IILjava/util/List;[Ljava/util/List;Ljava/util/List;)V", "readSourcePath", "kotlin.jvm.PlatformType", "readSources", "sourceRoot", "script-debugger-backend"})
public final class SourceMapDecoderKt {
    private static final Comparator<MappingEntry> MAPPING_COMPARATOR_BY_SOURCE_POSITION = MAPPING_COMPARATOR_BY_SOURCE_POSITION.1.INSTANCE;
    @NotNull
    private static final Comparator<MappingEntry> MAPPING_COMPARATOR_BY_GENERATED_POSITION = MAPPING_COMPARATOR_BY_GENERATED_POSITION.1.INSTANCE;
    public static final int UNMAPPED = -1;

    @NotNull
    public static final Comparator<MappingEntry> getMAPPING_COMPARATOR_BY_GENERATED_POSITION() {
        return MAPPING_COMPARATOR_BY_GENERATED_POSITION;
    }

    @Nullable
    public static final SourceMap decodeSourceMap(@NotNull CharSequence in, @NotNull Function2<? super List<String>, ? super List<String>, SourceResolver> sourceResolverFactory) {
        Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
        Intrinsics.checkParameterIsNotNull(sourceResolverFactory, (String)"sourceResolverFactory");
        CharSequence $receiver$iv = in;
        if ($receiver$iv.length() == 0) {
            throw (Throwable)new IOException("source map contents cannot be empty");
        }
        JsonReaderEx reader = new JsonReaderEx(in);
        reader.setLenient(true);
        return SourceMapDecoderKt.parseMap(reader, 0, 0, new ArrayList(), sourceResolverFactory);
    }

    /*
     * Unable to fully structure code
     */
    private static final SourceMap parseMap(JsonReaderEx reader, int line, int column, List<MappingEntry> mappings, Function2<? super List<String>, ? super List<String>, SourceResolver> sourceResolverFactory) {
        reader.beginObject();
        sourceRoot = null;
        sourcesReader = null;
        names = null;
        encodedMappings = null;
        file = null;
        version = -1;
        sourcesContent = null;
        while (reader.hasNext()) {
            block27: {
                block33: {
                    block31: {
                        block29: {
                            block30: {
                                block32: {
                                    block28: {
                                        var12_12 = reader.nextName();
                                        v0 = var12_12;
                                        if (v0 == null) break block27;
                                        switch (v0.hashCode()) {
                                            case -1111500899: {
                                                if (!var12_12.equals("sourceRoot")) ** break;
                                                break block28;
                                            }
                                            case 194445669: {
                                                if (!var12_12.equals("mappings")) ** break;
                                                break block29;
                                            }
                                            case 104585032: {
                                                if (!var12_12.equals("names")) ** break;
                                                break block30;
                                            }
                                            case 3143036: {
                                                if (!var12_12.equals("file")) ** break;
                                                break block31;
                                            }
                                            case -2021876808: {
                                                if (!var12_12.equals("sources")) ** break;
                                                break block32;
                                            }
                                            case -252243551: {
                                                if (!var12_12.equals("sourcesContent")) ** break;
                                                break block33;
                                            }
                                            case 351608024: {
                                                if (!var12_12.equals("version")) ** break;
                                                break;
                                            }
                                            case 947936814: {
                                                if (!var12_12.equals("sections")) ** break;
                                                throw (Throwable)new IOException("sections is not supported yet");
                                            }
                                        }
                                        version = reader.nextInt();
                                        continue;
                                    }
                                    sourceRoot = SourceMapDecoderKt.readSourcePath(reader);
                                    if (sourceRoot == null || !(Intrinsics.areEqual((Object)sourceRoot, (Object)"/") ^ true)) continue;
                                    sourceRoot = UriUtil.trimTrailingSlashes(sourceRoot);
                                    continue;
                                }
                                sourcesReader = reader.subReader();
                                reader.skipValue();
                                continue;
                            }
                            reader.beginArray();
                            if (reader.hasNext()) {
                                names = new ArrayList<E>();
                                do {
                                    if (Intrinsics.areEqual((Object)reader.peek(), (Object)JsonToken.BEGIN_OBJECT)) {
                                        reader.skipValue();
                                        ((ArrayList)names).add("POLYMER UNKNOWN NAME");
                                        continue;
                                    }
                                    ((ArrayList)names).add(reader.nextString(true));
                                } while (reader.hasNext());
                            } else {
                                names = CollectionsKt.emptyList();
                            }
                            reader.endArray();
                            continue;
                        }
                        encodedMappings = reader.nextString();
                        continue;
                    }
                    file = reader.nextString();
                    continue;
                }
                reader.beginArray();
                if (Intrinsics.areEqual((Object)reader.peek(), (Object)JsonToken.END_ARRAY) ^ true) {
                    sourcesContent = (List)new SmartList();
                    do {
                        if (Intrinsics.areEqual((Object)reader.peek(), (Object)JsonToken.STRING)) {
                            v1 = StringUtilRt.convertLineSeparators((String)reader.nextString());
                            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"StringUtilRt.convertLine\u2026tors(reader.nextString())");
                            sourcesContent.add(v1);
                            continue;
                        }
                        reader.skipValue();
                    } while (reader.hasNext());
                }
                reader.endArray();
                continue;
            }
            reader.skipValue();
        }
        reader.close();
        var12_12 = encodedMappings;
        if ($receiver$iv == null || $receiver$iv.length() == 0) {
            return null;
        }
        if (version != 3) {
            throw (Throwable)new IOException("Unsupported sourcemap version: " + version);
        }
        if (sourcesReader == null) {
            throw (Throwable)new IOException("sources is not specified");
        }
        sources = SourceMapDecoderKt.readSources(sourcesReader, sourceRoot);
        if (sources.isEmpty()) {
            return null;
        }
        reverseMappingsBySourceUrl = new List[sources.size()];
        v2 = encodedMappings;
        if (v2 == null) {
            Intrinsics.throwNpe();
        }
        SourceMapDecoderKt.readMappings(v2, line, column, mappings, reverseMappingsBySourceUrl, names);
        var15_14 = ((Object[])reverseMappingsBySourceUrl).length;
        result$iv = new MappingList[size$iv];
        var17_16 = false;
        var18_17 = size$iv - true;
        if (var17_16 <= var18_17) {
            do {
                var19_18 = ++i$iv;
                var24_21 = i$iv;
                var23_20 = result$iv;
                entries = reverseMappingsBySourceUrl[it];
                if (entries == null) {
                    v3 = null;
                } else {
                    CollectionsKt.sortWith((List)entries, SourceMapDecoderKt.MAPPING_COMPARATOR_BY_SOURCE_POSITION);
                    v3 = new SourceMappingList(entries);
                }
                var23_20[var24_21] = var25_22 = v3;
            } while (i$iv != var18_17);
        }
        sourceToEntries = (MappingList[])((Object[])result$iv);
        return new SourceMap(file, new GeneratedMappingList((List<? extends MappingEntry>)mappings), sourceToEntries, (SourceResolver)sourceResolverFactory.invoke(sources, (Object)sourcesContent), UtilKt.isNullOrEmpty(names) == false);
    }

    private static final String readSourcePath(JsonReaderEx reader) {
        String $receiver$iv = reader.nextString();
        String string = $receiver$iv;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        CharSequence $receiver$iv$iv = string;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $receiver$iv$iv.charAt(index$iv$iv);
            boolean bl = match$iv$iv = it <= ' ';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return PathUtil.toSystemIndependentName((String)StringUtil.nullize((String)((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()));
    }

    /*
     * WARNING - void declaration
     */
    private static final void readMappings(String value, int initialLine, int initialColumn, List<MappingEntry> mappings, List<MappingEntry>[] reverseMappingsBySourceUrl, List<String> names) {
        void $receiver$iv;
        CharSequence charSequence = value;
        if ($receiver$iv == null || $receiver$iv.length() == 0) {
            return;
        }
        int line = initialLine;
        int column = initialColumn;
        CharSequenceIterator charIterator = new CharSequenceIterator(value);
        int sourceIndex = 0;
        List<MappingEntry> reverseMappings = SourceMapDecoderKt.getMapping(reverseMappingsBySourceUrl, sourceIndex);
        int sourceLine = 0;
        int sourceColumn = 0;
        int nameIndex = 0;
        while (charIterator.hasNext()) {
            MappingEntry entry;
            if (charIterator.peek$script_debugger_backend() == ',') {
                charIterator.next();
            } else {
                while (charIterator.peek$script_debugger_backend() == ';') {
                    ++line;
                    column = 0;
                    charIterator.next();
                    if (charIterator.hasNext()) continue;
                    return;
                }
            }
            column += Base64VLQ.decode(charIterator);
            if (SourceMapDecoderKt.isSeparator(charIterator)) {
                mappings.add(new UnmappedEntry(line, column));
                continue;
            }
            int sourceIndexDelta = Base64VLQ.decode(charIterator);
            if (sourceIndexDelta != 0) {
                reverseMappings = SourceMapDecoderKt.getMapping(reverseMappingsBySourceUrl, sourceIndex += sourceIndexDelta);
            }
            sourceLine += Base64VLQ.decode(charIterator);
            sourceColumn += Base64VLQ.decode(charIterator);
            if (SourceMapDecoderKt.isSeparator(charIterator)) {
                entry = new UnnamedEntry(line, column, sourceIndex, sourceLine, sourceColumn);
            } else {
                Unit unit;
                nameIndex += Base64VLQ.decode(charIterator);
                boolean bl = names != null;
                if (_Assertions.ENABLED) {
                    void value$iv;
                    if (value$iv == false) {
                        String message$iv$iv = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)message$iv$iv));
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = Unit.INSTANCE;
                }
                List<String> list = names;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                entry = new NamedEntry(list.get(nameIndex), line, column, sourceIndex, sourceLine, sourceColumn);
            }
            reverseMappings.add(entry);
            mappings.add(entry);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> readSources(JsonReaderEx reader, String sourceRoot) {
        List sources;
        reader.beginArray();
        if (Intrinsics.areEqual((Object)reader.peek(), (Object)JsonToken.END_ARRAY)) {
            sources = CollectionsKt.emptyList();
        } else {
            sources = (List)new SmartList();
            do {
                void $receiver$iv;
                String sourceUrl = SourceMapDecoderKt.readSourcePath(reader);
                CharSequence charSequence = sourceRoot;
                if (!($receiver$iv == null || $receiver$iv.length() == 0)) {
                    sourceUrl = Intrinsics.areEqual((Object)sourceRoot, (Object)"/") ? "/" + sourceUrl : sourceRoot + "/" + sourceUrl;
                }
                ((SmartList)sources).add((Object)sourceUrl);
            } while (reader.hasNext());
        }
        reader.endArray();
        return sources;
    }

    private static final List<MappingEntry> getMapping(List<MappingEntry>[] reverseMappingsBySourceUrl, int sourceIndex) {
        List reverseMappings = reverseMappingsBySourceUrl[sourceIndex];
        if (reverseMappings == null) {
            reverseMappingsBySourceUrl[sourceIndex] = reverseMappings = (List)new ArrayList();
        }
        return reverseMappings;
    }

    private static final boolean isSeparator(CharSequenceIterator charIterator) {
        if (!charIterator.hasNext()) {
            return true;
        }
        char current = charIterator.peek$script_debugger_backend();
        return current == ',' || current == ';';
    }

    @NotNull
    public static final /* synthetic */ Comparator access$getMAPPING_COMPARATOR_BY_SOURCE_POSITION$p() {
        return MAPPING_COMPARATOR_BY_SOURCE_POSITION;
    }
}

