/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.ide.XmlRpcHandlerBean;
import com.intellij.ide.XmlRpcServer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcRequestProcessor;
import org.apache.xmlrpc.XmlRpcResponseProcessor;
import org.apache.xmlrpc.XmlRpcServerRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.Responses;
import org.picocontainer.PicoContainer;

public class XmlRpcServerImpl
implements XmlRpcServer {
    private static final Logger LOG = Logger.getInstance(XmlRpcServerImpl.class);
    private final Map<String, Object> handlerMapping = new THashMap();

    public XmlRpcServerImpl() {
        for (XmlRpcHandlerBean handlerBean : (XmlRpcHandlerBean[])Extensions.getExtensions((ExtensionPointName)XmlRpcHandlerBean.EP_NAME)) {
            try {
                this.handlerMapping.put(handlerBean.name, AbstractExtensionPointBean.instantiate((Class)handlerBean.findClass(handlerBean.implementation), (PicoContainer)ApplicationManager.getApplication().getPicoContainer(), (boolean)true));
            }
            catch (ClassNotFoundException e) {
                LOG.error((Throwable)e);
            }
        }
        LOG.debug("XmlRpcServerImpl instantiated, handlers " + this.handlerMapping);
    }

    public boolean hasHandler(String name) {
        return this.handlerMapping.containsKey(name);
    }

    public void addHandler(String name, Object handler2) {
        this.handlerMapping.put(name, handler2);
    }

    public void removeHandler(String name) {
        this.handlerMapping.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(@NotNull String path, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context, @Nullable Map<String, Object> handlers) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/ide/XmlRpcServerImpl", "process"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/XmlRpcServerImpl", "process"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/ide/XmlRpcServerImpl", "process"));
        }
        if (!(path.isEmpty() || path.length() == 1 && path.charAt(0) == '/' || path.equalsIgnoreCase("/rpc2"))) {
            return false;
        }
        if (request.method() == HttpMethod.POST) {
            ByteBuf result;
            ByteBuf content = request.content();
            if (content.readableBytes() == 0) {
                Responses.sendStatus(HttpResponseStatus.BAD_REQUEST, context.channel(), (HttpRequest)request);
                return true;
            }
            try (ByteBufInputStream in = new ByteBufInputStream(content);){
                XmlRpcServerRequest xmlRpcServerRequest = new XmlRpcRequestProcessor().decodeRequest((InputStream)in);
                if (StringUtil.isEmpty((String)xmlRpcServerRequest.getMethodName())) {
                    LOG.warn("method name empty");
                    boolean bl = false;
                    return bl;
                }
                Object response = XmlRpcServerImpl.invokeHandler(XmlRpcServerImpl.getHandler(xmlRpcServerRequest.getMethodName(), handlers == null ? this.handlerMapping : handlers), xmlRpcServerRequest);
                result = Unpooled.wrappedBuffer((byte[])new XmlRpcResponseProcessor().encodeResponse(response, "UTF-8"));
            }
            Responses.send((HttpResponse)Responses.response("text/xml", result), context.channel(), (HttpRequest)request);
            return true;
        }
        return false;
    }

    private static Object getHandler(@NotNull String methodName, @NotNull Map<String, Object> handlers) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "org/jetbrains/ide/XmlRpcServerImpl", "getHandler"));
        }
        if (handlers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handlers", "org/jetbrains/ide/XmlRpcServerImpl", "getHandler"));
        }
        Object handler2 = null;
        String handlerName = null;
        int dot = methodName.lastIndexOf(46);
        if (dot > -1) {
            handlerName = methodName.substring(0, dot);
            handler2 = handlers.get(handlerName);
        }
        if (handler2 != null) {
            return handler2;
        }
        if (dot > -1) {
            throw new IllegalStateException("RPC handler object \"" + handlerName + "\" not found");
        }
        throw new IllegalStateException("RPC handler object not found for \"" + methodName);
    }

    private static Object invokeHandler(@NotNull Object handler2, XmlRpcServerRequest request) throws Throwable {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/ide/XmlRpcServerImpl", "invokeHandler"));
        }
        return handler2 instanceof XmlRpcHandler ? (XmlRpcHandler)handler2 : XmlRpcServerImpl.invoke(handler2, request.getMethodName(), request.getParameters());
    }

    private static Object invoke(Object target, String methodName, Vector params) throws Throwable {
        Method method;
        int dot;
        Class<?> targetClass = target instanceof Class ? (Class<?>)target : target.getClass();
        Class[] argClasses = null;
        Object[] argValues = null;
        if (params != null) {
            argClasses = new Class[params.size()];
            argValues = new Object[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                argValues[i] = params.elementAt(i);
                argClasses[i] = argValues[i] instanceof Integer ? Integer.TYPE : (argValues[i] instanceof Double ? Double.TYPE : (argValues[i] instanceof Boolean ? Boolean.TYPE : argValues[i].getClass()));
            }
        }
        if ((dot = methodName.lastIndexOf(46)) > -1 && dot + 1 < methodName.length()) {
            methodName = methodName.substring(dot + 1);
        }
        if ((method = targetClass.getMethod(methodName, argClasses)).getDeclaringClass() == Object.class) {
            throw new XmlRpcException(0, "Invoker can't call methods defined in java.lang.Object");
        }
        Object returnValue = method.invoke(target, argValues);
        if (returnValue == null && method.getReturnType() == Void.TYPE) {
            throw new IllegalArgumentException("void return types for handler methods not supported, " + methodName);
        }
        return returnValue;
    }

    static final class XmlRpcRequestHandler
    extends HttpRequestHandler {
        XmlRpcRequestHandler() {
        }

        public boolean isSupported(@NotNull FullHttpRequest request) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/XmlRpcServerImpl$XmlRpcRequestHandler", "isSupported"));
            }
            return request.method() == HttpMethod.POST || request.method() == HttpMethod.OPTIONS;
        }

        public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) throws IOException {
            if (urlDecoder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/ide/XmlRpcServerImpl$XmlRpcRequestHandler", "process"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/XmlRpcServerImpl$XmlRpcRequestHandler", "process"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/ide/XmlRpcServerImpl$XmlRpcRequestHandler", "process"));
            }
            return XmlRpcServer.SERVICE.getInstance().process(urlDecoder.path(), request, context, null);
        }
    }
}

