/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SingletonNotificationManager {
    private final AtomicReference<Notification> notification;
    private final NotificationGroup group;
    private final NotificationType type;
    @Nullable
    private final NotificationListener listener;
    private Runnable expiredListener;

    public SingletonNotificationManager(@NotNull NotificationGroup group, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "org/jetbrains/notification/SingletonNotificationManager", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/notification/SingletonNotificationManager", "<init>"));
        }
        this.notification = new AtomicReference();
        this.group = group;
        this.type = type;
        this.listener = listener2;
    }

    public boolean notify(@NotNull String title, @NotNull String content) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/notification/SingletonNotificationManager", "notify"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/notification/SingletonNotificationManager", "notify"));
        }
        return this.notify(title, content, null);
    }

    public boolean notify(@NotNull String title, @NotNull String content, @Nullable Project project2) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/notification/SingletonNotificationManager", "notify"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/notification/SingletonNotificationManager", "notify"));
        }
        return this.notify(title, content, this.listener, project2);
    }

    public boolean notify(@NotNull String content, @Nullable Project project2) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/notification/SingletonNotificationManager", "notify"));
        }
        return this.notify("", content, this.listener, project2);
    }

    public boolean notify(@NotNull String title, @NotNull String content, @Nullable NotificationListener listener2, @Nullable Project project2) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/notification/SingletonNotificationManager", "notify"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/notification/SingletonNotificationManager", "notify"));
        }
        Notification oldNotification = this.notification.get();
        if (oldNotification != null) {
            if (!oldNotification.isExpired() && (oldNotification.getBalloon() != null || project2 != null && this.group.getDisplayType() == NotificationDisplayType.TOOL_WINDOW && ToolWindowManager.getInstance((Project)project2).getToolWindowBalloon(this.group.getToolWindowId()) != null)) {
                return false;
            }
            oldNotification.whenExpired(null);
            oldNotification.expire();
        }
        if (this.expiredListener == null) {
            this.expiredListener = new Runnable(){

                @Override
                public void run() {
                    Notification currentNotification = (Notification)SingletonNotificationManager.this.notification.get();
                    if (currentNotification != null && currentNotification.isExpired()) {
                        SingletonNotificationManager.this.notification.compareAndSet(currentNotification, null);
                    }
                }
            };
        }
        Notification newNotification = this.group.createNotification(title, content, this.type, listener2);
        newNotification.whenExpired(this.expiredListener);
        this.notification.set(newNotification);
        newNotification.notify(project2);
        return true;
    }

    public void clear() {
        Notification oldNotification = this.notification.getAndSet(null);
        if (oldNotification != null) {
            oldNotification.whenExpired(null);
            oldNotification.expire();
        }
    }
}

