/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.smartEnter;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.GrClassBodyFixer;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrForBodyFixer;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrIfConditionFixer;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrListFixer;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrLiteralFixer;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrMethodBodyFixer;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrMethodCallFixer;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrMethodCallWithSingleClosureArgFixer;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrMethodParametersFixer;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrMissingIfStatement;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrSwitchBodyFixer;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrSynchronizedFixer;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrWhileBodyFixer;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers.GrWhileConditionFixer;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.processors.GroovyPlainEnterProcessor;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovySmartEnterProcessor
extends SmartEnterProcessorWithFixers {
    public GroovySmartEnterProcessor() {
        List<SmartEnterProcessorWithFixers.Fixer> ourFixers = Arrays.asList(new SmartEnterProcessorWithFixers.Fixer[]{new SmartEnterProcessorWithFixers.Fixer<GroovySmartEnterProcessor>(){

            public void apply(@NotNull Editor editor, @NotNull GroovySmartEnterProcessor processor, @NotNull PsiElement psiElement) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/lang/completion/smartEnter/GroovySmartEnterProcessor$1", "apply"));
                }
                if (processor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/completion/smartEnter/GroovySmartEnterProcessor$1", "apply"));
                }
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/plugins/groovy/lang/completion/smartEnter/GroovySmartEnterProcessor$1", "apply"));
                }
                GrCatchClause catchClause = (GrCatchClause)PsiTreeUtil.getParentOfType((PsiElement)psiElement, GrCatchClause.class);
                if (catchClause == null || catchClause.getBody() != null) {
                    return;
                }
                if (!PsiTreeUtil.isAncestor((PsiElement)catchClause.getParameter(), (PsiElement)psiElement, (boolean)false)) {
                    return;
                }
                Document doc = editor.getDocument();
                PsiElement lBrace = catchClause.getLBrace();
                if (lBrace != null) {
                    return;
                }
                PsiElement eltToInsertAfter = catchClause.getRParenth();
                String text = "{\n}";
                if (eltToInsertAfter == null) {
                    eltToInsertAfter = catchClause.getParameter();
                    text = "){\n}";
                }
                if (eltToInsertAfter != null) {
                    doc.insertString(eltToInsertAfter.getTextRange().getEndOffset(), (CharSequence)text);
                }
            }
        }, new GrClassBodyFixer(), new GrMissingIfStatement(), new GrIfConditionFixer(), new GrLiteralFixer(), new GrMethodCallFixer(), new GrMethodBodyFixer(), new GrMethodParametersFixer(), new GrWhileConditionFixer(), new GrWhileBodyFixer(), new GrForBodyFixer(), new GrSwitchBodyFixer(), new GrSynchronizedFixer(), new GrListFixer(), new GrMethodCallWithSingleClosureArgFixer()});
        this.addFixers(ourFixers.toArray(new SmartEnterProcessorWithFixers.Fixer[ourFixers.size()]));
        this.addEnterProcessors(new SmartEnterProcessorWithFixers.FixEnterProcessor[]{new GroovyPlainEnterProcessor()});
    }

    protected void reformat(PsiElement atCaret) throws IncorrectOperationException {
        PsiElement parent = atCaret.getParent();
        if (parent instanceof GrCodeBlock) {
            GrCodeBlock block = (GrCodeBlock)parent;
            if (block.getStatements().length > 0 && block.getStatements()[0] == atCaret) {
                atCaret = block;
            }
        } else if (parent instanceof GrForStatement || parent instanceof GrSwitchStatement) {
            atCaret = parent;
        }
        super.reformat(atCaret);
    }

    protected void collectAllElements(@NotNull PsiElement atCaret, @NotNull OrderedSet<PsiElement> res, boolean recurse) {
        PsiElement[] children;
        if (atCaret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "atCaret", "org/jetbrains/plugins/groovy/lang/completion/smartEnter/GroovySmartEnterProcessor", "collectAllElements"));
        }
        if (res == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "res", "org/jetbrains/plugins/groovy/lang/completion/smartEnter/GroovySmartEnterProcessor", "collectAllElements"));
        }
        res.add(0, (Object)atCaret);
        if (this.doNotStepInto(atCaret)) {
            if (!recurse) {
                return;
            }
            recurse = false;
        }
        PsiElement parent = atCaret.getParent();
        if (atCaret instanceof GrClosableBlock && parent instanceof GrStringInjection && parent.getParent() instanceof GrString) {
            res.add((Object)parent.getParent());
        }
        if (parent instanceof GrArgumentList) {
            res.add((Object)parent.getParent());
        }
        for (PsiElement child : children = GroovySmartEnterProcessor.getChildren(atCaret)) {
            this.collectAllElements(child, res, recurse);
        }
    }

    public boolean doNotStepInto(PsiElement element) {
        return element instanceof PsiClass || element instanceof GrCodeBlock || element instanceof GrStatement && !(element instanceof GrExpression) || PsiUtil.isExpressionStatement(element) || element instanceof GrMethod;
    }

    @Nullable
    protected PsiElement getStatementAtCaret(Editor editor, PsiFile psiFile) {
        PsiElement atCaret = super.getStatementAtCaret(editor, psiFile);
        if (atCaret instanceof PsiWhiteSpace) {
            return null;
        }
        while (atCaret != null && !PsiUtil.isExpressionStatement(atCaret)) {
            if (atCaret instanceof PsiMethod || atCaret instanceof GrDocComment || atCaret instanceof GrTypeDefinition) {
                return atCaret;
            }
            atCaret = atCaret.getParent();
        }
        return atCaret;
    }

    protected void moveCaretInsideBracesIfAny(@NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/lang/completion/smartEnter/GroovySmartEnterProcessor", "moveCaretInsideBracesIfAny"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/lang/completion/smartEnter/GroovySmartEnterProcessor", "moveCaretInsideBracesIfAny"));
        }
        int caretOffset = editor.getCaretModel().getOffset();
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{}")) {
            caretOffset += 2;
        } else if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{\n}")) {
            caretOffset += 3;
        }
        caretOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(caretOffset - 1), (String)" \t") + 1;
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - "{}".length()), (CharSequence)"{}") || CharArrayUtil.regionMatches((CharSequence)chars, (int)(caretOffset - "{\n}".length()), (CharSequence)"{\n}")) {
            this.commit(editor);
            CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)file.getProject());
            boolean old = settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE;
            settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = false;
            PsiElement elt = PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(caretOffset - 1), (Class[])new Class[]{GrCodeBlock.class, GrTypeDefinitionBody.class});
            this.reformat(elt);
            settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = old;
            editor.getCaretModel().moveToOffset(caretOffset - 1);
        }
    }

    public void registerUnresolvedError(int offset) {
        if (this.myFirstErrorOffset > offset) {
            this.myFirstErrorOffset = offset;
        }
    }

    private static PsiElement[] getChildren(PsiElement element) {
        PsiElement psiChild = element.getFirstChild();
        if (psiChild == null) {
            return new PsiElement[0];
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        while (psiChild != null) {
            result.add(psiChild);
            psiChild = psiChild.getNextSibling();
        }
        return PsiUtilCore.toPsiElementArray(result);
    }
}

