/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.binding;

import com.intellij.openapi.util.Pair;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

public final class MutableClosure
implements CalculatedClosure {
    private final ClassDescriptor enclosingClass;
    private final CallableDescriptor enclosingFunWithReceiverDescriptor;
    private boolean captureThis;
    private boolean captureReceiver;
    private Map<DeclarationDescriptor, EnclosedValueDescriptor> captureVariables;
    private Map<DeclarationDescriptor, Integer> parameterOffsetInConstructor;
    private List<Pair<String, Type>> recordedFields;

    MutableClosure(@NotNull ClassDescriptor classDescriptor, @Nullable ClassDescriptor enclosingClass) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/binding/MutableClosure", "<init>"));
        }
        this.enclosingClass = enclosingClass;
        this.enclosingFunWithReceiverDescriptor = MutableClosure.enclosingExtensionMemberForClass(classDescriptor);
    }

    @Nullable
    private static CallableDescriptor enclosingExtensionMemberForClass(@NotNull ClassDescriptor classDescriptor) {
        CallableMemberDescriptor member;
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/binding/MutableClosure", "enclosingExtensionMemberForClass"));
        }
        DeclarationDescriptor classContainer = classDescriptor.getContainingDeclaration();
        if (classContainer instanceof CallableMemberDescriptor && (member = JvmCodegenUtil.getDirectMember((CallableMemberDescriptor)classContainer)).getExtensionReceiverParameter() != null) {
            return member;
        }
        return null;
    }

    @Nullable
    public ClassDescriptor getEnclosingClass() {
        return this.enclosingClass;
    }

    @Override
    public ClassDescriptor getCaptureThis() {
        return this.captureThis ? this.enclosingClass : null;
    }

    public void setCaptureThis() {
        this.captureThis = true;
    }

    @Override
    public KotlinType getCaptureReceiverType() {
        if (this.captureReceiver) {
            ReceiverParameterDescriptor parameter = this.getEnclosingReceiverDescriptor();
            assert (parameter != null) : "Receiver parameter should exist in " + this.enclosingFunWithReceiverDescriptor;
            return parameter.getType();
        }
        return null;
    }

    public void setCaptureReceiver() {
        if (this.enclosingFunWithReceiverDescriptor == null) {
            throw new IllegalStateException("Extension receiver parameter should exist");
        }
        this.captureReceiver = true;
    }

    @Override
    @NotNull
    public Map<DeclarationDescriptor, EnclosedValueDescriptor> getCaptureVariables() {
        Map<DeclarationDescriptor, EnclosedValueDescriptor> map2 = this.captureVariables != null ? this.captureVariables : Collections.emptyMap();
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/MutableClosure", "getCaptureVariables"));
        }
        return map2;
    }

    @Override
    @NotNull
    public List<Pair<String, Type>> getRecordedFields() {
        List<Pair<String, Type>> list2 = this.recordedFields != null ? this.recordedFields : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/binding/MutableClosure", "getRecordedFields"));
        }
        return list2;
    }

    public void recordField(String name, Type type2) {
        if (this.recordedFields == null) {
            this.recordedFields = new LinkedList<Pair<String, Type>>();
        }
        this.recordedFields.add(new Pair<String, Type>(name, type2));
    }

    public void captureVariable(EnclosedValueDescriptor value) {
        if (this.captureVariables == null) {
            this.captureVariables = new LinkedHashMap<DeclarationDescriptor, EnclosedValueDescriptor>();
        }
        this.captureVariables.put(value.getDescriptor(), value);
    }

    public void setCapturedParameterOffsetInConstructor(DeclarationDescriptor descriptor2, int offset) {
        if (this.parameterOffsetInConstructor == null) {
            this.parameterOffsetInConstructor = new LinkedHashMap<DeclarationDescriptor, Integer>();
        }
        this.parameterOffsetInConstructor.put(descriptor2, offset);
    }

    public int getCapturedParameterOffsetInConstructor(DeclarationDescriptor descriptor2) {
        Integer result2 = this.parameterOffsetInConstructor != null ? this.parameterOffsetInConstructor.get(descriptor2) : null;
        return result2 != null ? result2 : -1;
    }

    @Nullable
    public ReceiverParameterDescriptor getEnclosingReceiverDescriptor() {
        return this.enclosingFunWithReceiverDescriptor != null ? this.enclosingFunWithReceiverDescriptor.getExtensionReceiverParameter() : null;
    }
}

