/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.dependencies.external;

import com.android.tools.idea.gradle.dsl.dependencies.Dependencies;
import com.android.tools.idea.gradle.dsl.dependencies.ExternalDependencySpec;
import com.android.tools.idea.gradle.dsl.dependencies.external.ExternalDependency;
import com.android.tools.idea.gradle.dsl.parser.PsiElements;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

final class CompactNotation
extends ExternalDependency {
    @NotNull
    private final GrLiteral myValueLiteral;

    @Nullable
    static CompactNotation parse(@NotNull Dependencies parent, @NotNull GrMethodCall methodCall, @NotNull String configurationName, @NotNull GrLiteral valueLiteral) {
        ExternalDependencySpec spec;
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/dependencies/external/CompactNotation", "parse"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/android/tools/idea/gradle/dsl/dependencies/external/CompactNotation", "parse"));
        }
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/dependencies/external/CompactNotation", "parse"));
        }
        if (valueLiteral == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueLiteral", "com/android/tools/idea/gradle/dsl/dependencies/external/CompactNotation", "parse"));
        }
        String notation = PsiElements.getUnquotedText(valueLiteral);
        if (StringUtil.isNotEmpty((String)notation) && (spec = CompactNotation.parse(notation)) != null) {
            return new CompactNotation(parent, methodCall, configurationName, spec, valueLiteral);
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    static ExternalDependencySpec parse(@NotNull String notation) {
        if (notation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notation", "com/android/tools/idea/gradle/dsl/dependencies/external/CompactNotation", "parse"));
        }
        List segments = Splitter.on((char)':').trimResults().omitEmptyStrings().splitToList((CharSequence)notation);
        int segmentCount = segments.size();
        if (segmentCount > 0) {
            segments = Lists.newArrayList((Iterable)segments);
            String lastSegment = (String)segments.remove(segmentCount - 1);
            String extension = null;
            int indexOfAt = lastSegment.indexOf(64);
            if (indexOfAt != -1) {
                extension = lastSegment.substring(indexOfAt + 1, lastSegment.length());
                lastSegment = lastSegment.substring(0, indexOfAt);
            }
            segments.add(lastSegment);
            segmentCount = segments.size();
            String group = null;
            String name = null;
            String version = null;
            String classifier = null;
            if (segmentCount == 1) {
                name = (String)segments.get(0);
            } else if (segmentCount == 2) {
                if (!lastSegment.isEmpty() && Character.isDigit(lastSegment.charAt(0))) {
                    name = (String)segments.get(0);
                    version = lastSegment;
                } else {
                    group = (String)segments.get(0);
                    name = (String)segments.get(1);
                }
            } else if (segmentCount == 3 || segmentCount == 4) {
                group = (String)segments.get(0);
                name = (String)segments.get(1);
                version = (String)segments.get(2);
                if (segmentCount == 4) {
                    classifier = (String)segments.get(3);
                }
            }
            if (StringUtil.isNotEmpty((String)name)) {
                return new ExternalDependencySpec(name, group, version, classifier, extension);
            }
        }
        return null;
    }

    private CompactNotation(@NotNull Dependencies parent, @NotNull GrMethodCall methodCall, @NotNull String configurationName, @NotNull ExternalDependencySpec spec, @NotNull GrLiteral valueLiteral) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/dsl/dependencies/external/CompactNotation", "<init>"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/android/tools/idea/gradle/dsl/dependencies/external/CompactNotation", "<init>"));
        }
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/dependencies/external/CompactNotation", "<init>"));
        }
        if (spec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spec", "com/android/tools/idea/gradle/dsl/dependencies/external/CompactNotation", "<init>"));
        }
        if (valueLiteral == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueLiteral", "com/android/tools/idea/gradle/dsl/dependencies/external/CompactNotation", "<init>"));
        }
        super(parent, methodCall, configurationName, spec);
        this.myValueLiteral = valueLiteral;
    }

    @Override
    protected void applyVersion(@NotNull String newVersion) {
        if (newVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newVersion", "com/android/tools/idea/gradle/dsl/dependencies/external/CompactNotation", "applyVersion"));
        }
        this.mySpec.version = newVersion;
        PsiElements.setLiteralText(this.myValueLiteral, this.mySpec.toString());
    }

    @Override
    protected void removeFromParent() {
        GrClosableBlock closureBlock = this.getParent().getClosureBlock();
        assert (closureBlock != null);
        if (!this.removeArgumentIfMoreThanOne((GroovyPsiElement)this.myValueLiteral)) {
            closureBlock.removeElements(new PsiElement[]{this.getMethodCall()});
        }
    }
}

