/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.image;

import java.awt.image.BufferedImage;
import org.jdesktop.swingx.graphics.GraphicsUtilities;
import org.jdesktop.swingx.image.AbstractFilter;
import org.jdesktop.swingx.image.FastBlurFilter;

public class StackBlurFilter
extends AbstractFilter {
    private final int radius;
    private final int iterations;

    public StackBlurFilter() {
        this(3, 3);
    }

    public StackBlurFilter(int radius) {
        this(radius, 3);
    }

    public StackBlurFilter(int radius, int iterations) {
        if (radius < 1) {
            radius = 1;
        }
        if (iterations < 1) {
            iterations = 1;
        }
        this.radius = radius;
        this.iterations = iterations;
    }

    public int getEffectiveRadius() {
        return this.getIterations() * this.getRadius();
    }

    public int getRadius() {
        return this.radius;
    }

    public int getIterations() {
        return this.iterations;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int[] srcPixels = new int[width * height];
        int[] dstPixels = new int[width * height];
        GraphicsUtilities.getPixels(src, 0, 0, width, height, srcPixels);
        for (int i = 0; i < this.iterations; ++i) {
            FastBlurFilter.blur(srcPixels, dstPixels, width, height, this.radius);
            FastBlurFilter.blur(dstPixels, srcPixels, height, width, this.radius);
        }
        GraphicsUtilities.setPixels(dst, 0, 0, width, height, srcPixels);
        return dst;
    }
}

