/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoFormatTypedHandler
extends TypedActionHandlerBase {
    private static boolean myIsEnabledInTests = false;
    private static char[] NO_SPACE_AFTER = new char[]{'+', '-', '*', '/', '%', '&', '^', '|', '<', '>', '!', '=', ' '};
    private static final List<IElementType> COMPLEX_ASSIGNMENTS = ContainerUtil.newArrayList((Object[])new IElementType[]{JavaTokenType.PLUSEQ, JavaTokenType.MINUSEQ, JavaTokenType.ASTERISKEQ, JavaTokenType.DIVEQ, JavaTokenType.PERCEQ, JavaTokenType.ANDEQ, JavaTokenType.XOREQ, JavaTokenType.OREQ, JavaTokenType.LTLTEQ, JavaTokenType.GTGTEQ});

    public AutoFormatTypedHandler(@Nullable TypedActionHandler originalHandler) {
        super(originalHandler);
    }

    private static boolean isEnabled(Editor editor) {
        PsiFile file2;
        boolean isEnabled;
        boolean bl = isEnabled = myIsEnabledInTests && ApplicationManager.getApplication().isUnitTestMode() || Registry.is((String)"editor.reformat.on.typing");
        if (!isEnabled) {
            return false;
        }
        Project project2 = editor.getProject();
        Language language = null;
        if (project2 != null && (file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument())) != null) {
            language = file2.getLanguage();
        }
        return language == JavaLanguage.INSTANCE;
    }

    public static void setEnabledInTests(boolean value) {
        myIsEnabledInTests = value;
    }

    public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/AutoFormatTypedHandler", "execute"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/editorActions/AutoFormatTypedHandler", "execute"));
        }
        if (!AutoFormatTypedHandler.isEnabled(editor)) {
            this.executeOriginalHandler(editor, charTyped, dataContext);
            return;
        }
        if (AutoFormatTypedHandler.isInsertSpaceAtCaret(editor, charTyped, dataContext)) {
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" ");
        }
        this.executeOriginalHandler(editor, charTyped, dataContext);
    }

    private static boolean isInsertSpaceAtCaret(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/AutoFormatTypedHandler", "isInsertSpaceAtCaret"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/editorActions/AutoFormatTypedHandler", "isInsertSpaceAtCaret"));
        }
        if (!AutoFormatTypedHandler.isSpaceAroundAssignment(editor, dataContext)) {
            return false;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        CharSequence text = editor.getDocument().getImmutableCharSequence();
        HighlighterIterator lexerIterator = AutoFormatTypedHandler.createLexerIterator(editor, caretOffset);
        if (lexerIterator == null || lexerIterator.getTokenType() == JavaTokenType.STRING_LITERAL) {
            return false;
        }
        boolean insertBeforeEq = charTyped == '=' && AutoFormatTypedHandler.isInsertSpaceBeforeEq(caretOffset, text);
        boolean insertAfterEq = caretOffset > 0 && caretOffset - 1 < text.length() && text.charAt(caretOffset - 1) == '=' && AutoFormatTypedHandler.isAssignmentOperator(lexerIterator) && AutoFormatTypedHandler.isInsertSpaceAfterEq(charTyped);
        return insertBeforeEq || insertAfterEq;
    }

    private static boolean isAssignmentOperator(HighlighterIterator iterator) {
        IElementType type = iterator.getTokenType();
        if (type == TokenType.WHITE_SPACE) {
            iterator.retreat();
            type = iterator.getTokenType();
        }
        if (COMPLEX_ASSIGNMENTS.indexOf(type) >= 0) {
            return true;
        }
        if (type == JavaTokenType.EQ) {
            iterator.retreat();
            type = iterator.getTokenType();
            if (type == JavaTokenType.GT) {
                iterator.retreat();
                type = iterator.getTokenType();
                if (type == JavaTokenType.GT) {
                    return true;
                }
            } else if (type == TokenType.WHITE_SPACE || type == JavaTokenType.IDENTIFIER) {
                return true;
            }
        }
        return false;
    }

    private static boolean isInsertSpaceAfterEq(char charTyped) {
        return charTyped != '=' && charTyped != ' ';
    }

    private static HighlighterIterator createLexerIterator(Editor editor, int offset) {
        if (editor.getDocument().getTextLength() == 0) {
            return null;
        }
        return editor instanceof EditorEx ? ((EditorEx)editor).getHighlighter().createIterator(offset) : null;
    }

    private void executeOriginalHandler(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/AutoFormatTypedHandler", "executeOriginalHandler"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/editorActions/AutoFormatTypedHandler", "executeOriginalHandler"));
        }
        if (this.myOriginalHandler != null) {
            this.myOriginalHandler.execute(editor, charTyped, dataContext);
        }
    }

    private static boolean isInsertSpaceBeforeEq(int caretOffset, CharSequence text) {
        if (caretOffset == 0) {
            return false;
        }
        char charBefore = text.charAt(caretOffset - 1);
        for (char c : NO_SPACE_AFTER) {
            if (c != charBefore) continue;
            return false;
        }
        return true;
    }

    private static boolean isSpaceAroundAssignment(Editor editor, DataContext dataContext) {
        PsiFile file2;
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        PsiFile psiFile = file2 = project2 == null ? null : PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project2);
        if (file2 != null) {
            Language language = file2.getLanguage();
            CodeStyleSettings settings = CodeStyleSettingsManager.getInstance((Project)project2).getCurrentSettings();
            CommonCodeStyleSettings common = settings.getCommonSettings(language);
            return common.SPACE_AROUND_ASSIGNMENT_OPERATORS;
        }
        return false;
    }
}

