/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.generation.OverrideImplementsAnnotationsHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class OverrideImplementsAnnotationsHandlerImpl
implements OverrideImplementsAnnotationsHandler {
    @Override
    public String[] getAnnotations(Project project2) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project2);
        ArrayList<String> anns = new ArrayList<String>(manager.getNotNulls());
        anns.addAll(manager.getNullables());
        anns.add("org.jetbrains.annotations.Nls");
        return ArrayUtil.toStringArray(anns);
    }

    @Override
    @NotNull
    public String[] annotationsToRemove(Project project2, @NotNull String fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "com/intellij/codeInsight/generation/OverrideImplementsAnnotationsHandlerImpl", "annotationsToRemove"));
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project2);
        if (manager.getNotNulls().contains(fqName)) {
            String[] stringArray = ArrayUtil.toStringArray((Collection)manager.getNullables());
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/OverrideImplementsAnnotationsHandlerImpl", "annotationsToRemove"));
            }
            return stringArray;
        }
        if (manager.getNullables().contains(fqName)) {
            String[] stringArray = ArrayUtil.toStringArray((Collection)manager.getNotNulls());
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/OverrideImplementsAnnotationsHandlerImpl", "annotationsToRemove"));
            }
            return stringArray;
        }
        if (Comparing.strEqual((String)fqName, (String)"org.jetbrains.annotations.Nls")) {
            String[] stringArray = new String[]{"org.jetbrains.annotations.NonNls"};
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/OverrideImplementsAnnotationsHandlerImpl", "annotationsToRemove"));
            }
            return stringArray;
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/OverrideImplementsAnnotationsHandlerImpl", "annotationsToRemove"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }
}

