/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisConverter;
import com.intellij.codeInspection.bytecodeAnalysis.Bytes;
import com.intellij.codeInspection.bytecodeAnalysis.ClassDataIndexer;
import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.DirectionResultPair;
import com.intellij.codeInspection.bytecodeAnalysis.HComponent;
import com.intellij.codeInspection.bytecodeAnalysis.HEffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.HEffects;
import com.intellij.codeInspection.bytecodeAnalysis.HEquations;
import com.intellij.codeInspection.bytecodeAnalysis.HFinal;
import com.intellij.codeInspection.bytecodeAnalysis.HKey;
import com.intellij.codeInspection.bytecodeAnalysis.HPending;
import com.intellij.codeInspection.bytecodeAnalysis.HResult;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DifferentSerializableBytesImplyNonEqualityPolicy;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class BytecodeAnalysisIndex
extends FileBasedIndexExtension<Bytes, HEquations> {
    public static final ID<Bytes, HEquations> NAME = ID.create((String)"bytecodeAnalysis");
    private final HEquationsExternalizer myExternalizer = new HEquationsExternalizer();
    private static final ClassDataIndexer INDEXER = new ClassDataIndexer();
    private static final HKeyDescriptor KEY_DESCRIPTOR = new HKeyDescriptor();
    private static final int ourInternalVersion = 8;
    private static final boolean ourEnabled = SystemProperties.getBooleanProperty((String)"idea.enable.bytecode.contract.inference", (boolean)true);

    @NotNull
    public ID<Bytes, HEquations> getName() {
        ID<Bytes, HEquations> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<Bytes, HEquations, FileContent> getIndexer() {
        ClassDataIndexer classDataIndexer = INDEXER;
        if (classDataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getIndexer"));
        }
        return classDataIndexer;
    }

    @NotNull
    public KeyDescriptor<Bytes> getKeyDescriptor() {
        HKeyDescriptor hKeyDescriptor = KEY_DESCRIPTOR;
        if (hKeyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getKeyDescriptor"));
        }
        return hKeyDescriptor;
    }

    @NotNull
    public DataExternalizer<HEquations> getValueExternalizer() {
        HEquationsExternalizer hEquationsExternalizer = this.myExternalizer;
        if (hEquationsExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getValueExternalizer"));
        }
        return hEquationsExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaClassFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$1", "acceptInput"));
                }
                return ourEnabled && super.acceptInput(file2);
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 8 + (ourEnabled ? 255 : 0);
    }

    public static class HEquationsExternalizer
    implements DataExternalizer<HEquations> {
        public void save(@NotNull DataOutput out, HEquations eqs) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HEquationsExternalizer", "save"));
            }
            out.writeBoolean(eqs.stable);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)eqs.results.size());
            for (DirectionResultPair pair : eqs.results) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)pair.directionKey);
                HResult rhs = pair.hResult;
                if (rhs instanceof HFinal) {
                    HFinal finalResult = (HFinal)rhs;
                    out.writeBoolean(true);
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)finalResult.value.ordinal());
                    continue;
                }
                if (rhs instanceof HPending) {
                    HPending pendResult = (HPending)rhs;
                    out.writeBoolean(false);
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)pendResult.delta.length);
                    for (HComponent component : pendResult.delta) {
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)component.value.ordinal());
                        HKey[] ids = component.ids;
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)ids.length);
                        for (HKey hKey : ids) {
                            out.write(hKey.key);
                            int rawDirKey = hKey.negated ? -hKey.dirKey : hKey.dirKey;
                            DataInputOutputUtil.writeINT((DataOutput)out, (int)rawDirKey);
                            out.writeBoolean(hKey.stable);
                        }
                    }
                    continue;
                }
                if (!(rhs instanceof HEffects)) continue;
                HEffects effects = (HEffects)rhs;
                DataInputOutputUtil.writeINT((DataOutput)out, (int)effects.effects.size());
                for (HEffectQuantum effect : effects.effects) {
                    if (effect == HEffectQuantum.TopEffectQuantum) {
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)-1);
                        continue;
                    }
                    if (effect == HEffectQuantum.ThisChangeQuantum) {
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)-2);
                        continue;
                    }
                    if (effect instanceof HEffectQuantum.CallQuantum) {
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)-3);
                        HEffectQuantum.CallQuantum callQuantum = (HEffectQuantum.CallQuantum)effect;
                        out.write(callQuantum.key.key);
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)callQuantum.key.dirKey);
                        out.writeBoolean(callQuantum.key.stable);
                        out.writeBoolean(callQuantum.isStatic);
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)callQuantum.data.length);
                        for (DataValue dataValue : callQuantum.data) {
                            if (dataValue == DataValue.ThisDataValue) {
                                DataInputOutputUtil.writeINT((DataOutput)out, (int)-1);
                                continue;
                            }
                            if (dataValue == DataValue.LocalDataValue) {
                                DataInputOutputUtil.writeINT((DataOutput)out, (int)-2);
                                continue;
                            }
                            if (dataValue == DataValue.OwnedDataValue) {
                                DataInputOutputUtil.writeINT((DataOutput)out, (int)-3);
                                continue;
                            }
                            if (dataValue == DataValue.UnknownDataValue1) {
                                DataInputOutputUtil.writeINT((DataOutput)out, (int)-4);
                                continue;
                            }
                            if (dataValue == DataValue.UnknownDataValue2) {
                                DataInputOutputUtil.writeINT((DataOutput)out, (int)-5);
                                continue;
                            }
                            if (!(dataValue instanceof DataValue.ParameterDataValue)) continue;
                            DataInputOutputUtil.writeINT((DataOutput)out, (int)((DataValue.ParameterDataValue)dataValue).n);
                        }
                        continue;
                    }
                    if (!(effect instanceof HEffectQuantum.ParamChangeQuantum)) continue;
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)((HEffectQuantum.ParamChangeQuantum)effect).n);
                }
            }
        }

        public HEquations read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HEquationsExternalizer", "read"));
            }
            boolean stable = in.readBoolean();
            int size = DataInputOutputUtil.readINT((DataInput)in);
            ArrayList<DirectionResultPair> results = new ArrayList<DirectionResultPair>(size);
            for (int k = 0; k < size; ++k) {
                int directionKey = DataInputOutputUtil.readINT((DataInput)in);
                Direction direction = BytecodeAnalysisConverter.extractDirection(directionKey);
                if (direction == Direction.Pure) {
                    HashSet<HEffectQuantum> effects = new HashSet<HEffectQuantum>();
                    int effectsSize = DataInputOutputUtil.readINT((DataInput)in);
                    for (int i = 0; i < effectsSize; ++i) {
                        int effectMask = DataInputOutputUtil.readINT((DataInput)in);
                        if (effectMask == -1) {
                            effects.add(HEffectQuantum.TopEffectQuantum);
                            continue;
                        }
                        if (effectMask == -2) {
                            effects.add(HEffectQuantum.ThisChangeQuantum);
                            continue;
                        }
                        if (effectMask == -3) {
                            byte[] bytes = new byte[14];
                            for (int bi = 0; bi < bytes.length; ++bi) {
                                bytes[bi] = in.readByte();
                            }
                            int rawDirKey = DataInputOutputUtil.readINT((DataInput)in);
                            boolean isStable = in.readBoolean();
                            HKey key = new HKey(bytes, Math.abs(rawDirKey), isStable, false);
                            boolean isStatic = in.readBoolean();
                            int dataLength = DataInputOutputUtil.readINT((DataInput)in);
                            DataValue[] data = new DataValue[dataLength];
                            for (int di = 0; di < dataLength; ++di) {
                                int dataI = DataInputOutputUtil.readINT((DataInput)in);
                                data[di] = dataI == -1 ? DataValue.ThisDataValue : (dataI == -2 ? DataValue.LocalDataValue : (dataI == -3 ? DataValue.OwnedDataValue : (dataI == -4 ? DataValue.UnknownDataValue1 : (dataI == -5 ? DataValue.UnknownDataValue2 : new DataValue.ParameterDataValue(dataI)))));
                            }
                            effects.add(new HEffectQuantum.CallQuantum(key, data, isStatic));
                            continue;
                        }
                        effects.add(new HEffectQuantum.ParamChangeQuantum(effectMask));
                    }
                    results.add(new DirectionResultPair(directionKey, new HEffects(effects)));
                    continue;
                }
                boolean isFinal = in.readBoolean();
                if (isFinal) {
                    int ordinal = DataInputOutputUtil.readINT((DataInput)in);
                    Value value = Value.values()[ordinal];
                    results.add(new DirectionResultPair(directionKey, new HFinal(value)));
                    continue;
                }
                int sumLength = DataInputOutputUtil.readINT((DataInput)in);
                HComponent[] components = new HComponent[sumLength];
                for (int i = 0; i < sumLength; ++i) {
                    int ordinal = DataInputOutputUtil.readINT((DataInput)in);
                    Value value = Value.values()[ordinal];
                    int componentSize = DataInputOutputUtil.readINT((DataInput)in);
                    HKey[] ids = new HKey[componentSize];
                    for (int j = 0; j < componentSize; ++j) {
                        byte[] bytes = new byte[14];
                        for (int bi = 0; bi < bytes.length; ++bi) {
                            bytes[bi] = in.readByte();
                        }
                        int rawDirKey = DataInputOutputUtil.readINT((DataInput)in);
                        ids[j] = new HKey(bytes, Math.abs(rawDirKey), in.readBoolean(), rawDirKey < 0);
                    }
                    components[i] = new HComponent(value, ids);
                }
                results.add(new DirectionResultPair(directionKey, new HPending(components)));
            }
            return new HEquations(results, stable);
        }
    }

    private static class HKeyDescriptor
    implements KeyDescriptor<Bytes>,
    DifferentSerializableBytesImplyNonEqualityPolicy {
        private HKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, Bytes value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HKeyDescriptor", "save"));
            }
            out.write(value.bytes);
        }

        public Bytes read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HKeyDescriptor", "read"));
            }
            byte[] bytes = new byte[14];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = in.readByte();
            }
            return new Bytes(bytes);
        }

        public int getHashCode(Bytes value) {
            return Arrays.hashCode(value.bytes);
        }

        public boolean isEqual(Bytes val1, Bytes val2) {
            return Arrays.equals(val1.bytes, val2.bytes);
        }
    }
}

