/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.HEffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.HKey;
import com.intellij.codeInspection.bytecodeAnalysis.HardCodedPurity;
import com.intellij.codeInspection.bytecodeAnalysis.PurityAnalysis;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

final class PuritySolver {
    private HashMap<HKey, Set<HEffectQuantum>> solved = new HashMap();
    private HashMap<HKey, Set<HKey>> dependencies = new HashMap();
    private final Stack<HKey> moving = new Stack();
    private HashMap<HKey, Set<HEffectQuantum>> pending = new HashMap();

    PuritySolver() {
    }

    void addEquation(HKey key, Set<HEffectQuantum> effects) {
        HashSet<HKey> callKeys = new HashSet<HKey>();
        for (HEffectQuantum effect : effects) {
            if (!(effect instanceof HEffectQuantum.CallQuantum)) continue;
            callKeys.add(((HEffectQuantum.CallQuantum)effect).key);
        }
        if (callKeys.isEmpty()) {
            this.solved.put(key, effects);
            this.moving.add(key);
        } else {
            this.pending.put(key, effects);
            for (HKey callKey : callKeys) {
                Set<HKey> deps = this.dependencies.get(callKey);
                if (deps == null) {
                    deps = new HashSet<HKey>();
                    this.dependencies.put(callKey, deps);
                }
                deps.add(key);
            }
        }
    }

    public Map<HKey, Set<HEffectQuantum>> solve() {
        while (!this.moving.isEmpty()) {
            Set[] propagateEffects;
            HKey[] propagateKeys;
            HKey key = this.moving.pop();
            Set<HEffectQuantum> effects = this.solved.get(key);
            if (key.stable) {
                propagateKeys = new HKey[]{key, key.mkUnstable()};
                propagateEffects = new Set[]{effects, effects};
            } else {
                propagateKeys = new HKey[]{key.mkStable(), key};
                propagateEffects = new Set[]{effects, PuritySolver.mkUnstableEffects(key)};
            }
            for (int i = 0; i < propagateKeys.length; ++i) {
                HKey pKey = propagateKeys[i];
                Set pEffects = propagateEffects[i];
                Set<HKey> dKeys = this.dependencies.remove(pKey);
                if (dKeys == null) continue;
                for (HKey dKey : dKeys) {
                    Set<HEffectQuantum> dEffects = this.pending.remove(dKey);
                    if (dEffects == null) continue;
                    HashSet<HKey> callKeys = new HashSet<HKey>();
                    HashSet<HEffectQuantum> newEffects = new HashSet<HEffectQuantum>();
                    Set<HEffectQuantum> delta = null;
                    for (HEffectQuantum dEffect : dEffects) {
                        if (dEffect instanceof HEffectQuantum.CallQuantum) {
                            HEffectQuantum.CallQuantum call = (HEffectQuantum.CallQuantum)dEffect;
                            if (call.key.equals(pKey)) {
                                delta = this.substitute(pEffects, call.data, call.isStatic);
                                newEffects.addAll(delta);
                                continue;
                            }
                            callKeys.add(call.key);
                            newEffects.add(call);
                            continue;
                        }
                        newEffects.add(dEffect);
                    }
                    if (PurityAnalysis.topHEffect.equals(delta)) {
                        this.solved.put(dKey, PurityAnalysis.topHEffect);
                        this.moving.push(dKey);
                        continue;
                    }
                    if (callKeys.isEmpty()) {
                        this.solved.put(dKey, newEffects);
                        this.moving.push(dKey);
                        continue;
                    }
                    this.pending.put(dKey, newEffects);
                }
            }
        }
        return this.solved;
    }

    private Set<HEffectQuantum> substitute(Set<HEffectQuantum> effects, DataValue[] data, boolean isStatic) {
        if (effects.isEmpty() || PurityAnalysis.topHEffect.equals(effects)) {
            return effects;
        }
        HashSet<HEffectQuantum> newEffects = new HashSet<HEffectQuantum>();
        int shift = isStatic ? 0 : 1;
        for (HEffectQuantum effect : effects) {
            if (effect == HEffectQuantum.ThisChangeQuantum) {
                DataValue thisArg = data[0];
                if (thisArg == DataValue.ThisDataValue || thisArg == DataValue.OwnedDataValue) {
                    newEffects.add(HEffectQuantum.ThisChangeQuantum);
                    continue;
                }
                if (thisArg == DataValue.LocalDataValue) continue;
                if (thisArg instanceof DataValue.ParameterDataValue) {
                    newEffects.add(new HEffectQuantum.ParamChangeQuantum(((DataValue.ParameterDataValue)thisArg).n));
                    continue;
                }
                return PurityAnalysis.topHEffect;
            }
            if (!(effect instanceof HEffectQuantum.ParamChangeQuantum)) continue;
            HEffectQuantum.ParamChangeQuantum paramChange = (HEffectQuantum.ParamChangeQuantum)effect;
            DataValue paramArg = data[paramChange.n + shift];
            if (paramArg == DataValue.ThisDataValue || paramArg == DataValue.OwnedDataValue) {
                newEffects.add(HEffectQuantum.ThisChangeQuantum);
                continue;
            }
            if (paramArg == DataValue.LocalDataValue) continue;
            if (paramArg instanceof DataValue.ParameterDataValue) {
                newEffects.add(new HEffectQuantum.ParamChangeQuantum(((DataValue.ParameterDataValue)paramArg).n));
                continue;
            }
            return PurityAnalysis.topHEffect;
        }
        return newEffects;
    }

    private static Set mkUnstableEffects(HKey key) {
        Set<EffectQuantum> hardcodedEffects = HardCodedPurity.getHardCodedSolution(key);
        return hardcodedEffects == null ? PurityAnalysis.topHEffect : hardcodedEffects;
    }
}

