/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.execution.console.GutterContentProvider;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class ConsoleGutterComponent
extends JComponent
implements MouseMotionListener {
    private static final TooltipGroup TOOLTIP_GROUP = new TooltipGroup("CONSOLE_GUTTER_TOOLTIP_GROUP", 0);
    private final EditorImpl editor;
    private int maxContentWidth;
    private int myLastPreferredHeight;
    private final int gap;
    private final GutterContentProvider gutterContentProvider;
    private int lastGutterToolTipLine;
    private final boolean atLineStart;

    public ConsoleGutterComponent(@NotNull Editor editor, @NotNull GutterContentProvider gutterContentProvider, boolean atLineStart) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/execution/console/ConsoleGutterComponent", "<init>"));
        }
        if (gutterContentProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gutterContentProvider", "com/intellij/execution/console/ConsoleGutterComponent", "<init>"));
        }
        this.myLastPreferredHeight = -1;
        this.lastGutterToolTipLine = -1;
        this.editor = (EditorImpl)editor;
        this.gutterContentProvider = gutterContentProvider;
        this.atLineStart = atLineStart;
        if (atLineStart) {
            this.setOpaque(gutterContentProvider.getLineStartGutterOverlap(editor) == 0);
        } else {
            this.addListeners();
            this.setOpaque(false);
        }
        int spaceWidth = EditorUtil.getSpaceWidth(0, editor);
        this.gap = atLineStart ? spaceWidth * 2 : spaceWidth;
        this.maxContentWidth = atLineStart ? this.gap : 0;
    }

    private void addListeners() {
        this.addMouseMotionListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    ConsoleGutterComponent.this.gutterContentProvider.doAction(EditorUtil.yPositionToLogicalLine((Editor)ConsoleGutterComponent.this.editor, e.getPoint()), ConsoleGutterComponent.this.editor);
                }
            }
        });
    }

    public void updateSize(int start, int end) {
        int oldAnnotationsWidth = this.maxContentWidth;
        this.computeMaxAnnotationWidth(start, end);
        if (oldAnnotationsWidth != this.maxContentWidth || this.myLastPreferredHeight != this.editor.getPreferredHeight()) {
            this.processComponentEvent(new ComponentEvent(this, 101));
        }
        this.repaint();
    }

    private void computeMaxAnnotationWidth(int start, int end) {
        this.gutterContentProvider.beforeUiComponentUpdate(this.editor);
        if (this.atLineStart) {
            return;
        }
        if (!this.gutterContentProvider.hasText()) {
            this.editor.getSettings().setAdditionalColumnsCount(1);
            this.maxContentWidth = 0;
            return;
        }
        FontMetrics fontMetrics = this.editor.getFontMetrics(0);
        int lineCount = Math.min(end, this.editor.getDocument().getLineCount());
        int gutterSize = 0;
        for (int line = start; line < lineCount; ++line) {
            String text = this.gutterContentProvider.getText(line, this.editor);
            if (text == null) continue;
            gutterSize = Math.max(gutterSize, fontMetrics.stringWidth(text));
        }
        if (gutterSize != 0) {
            gutterSize += this.gap;
        }
        this.maxContentWidth = Math.max(gutterSize, this.maxContentWidth);
        this.editor.getSettings().setAdditionalColumnsCount(1 + this.maxContentWidth / EditorUtil.getSpaceWidth(0, this.editor));
    }

    @Override
    public Dimension getPreferredSize() {
        this.myLastPreferredHeight = this.editor.getPreferredHeight();
        return new Dimension(this.maxContentWidth, this.myLastPreferredHeight);
    }

    public int getPreferredWidth() {
        return this.maxContentWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        Rectangle clip = g.getClipBounds();
        if (clip.height <= 0 || this.maxContentWidth == 0) {
            return;
        }
        if (this.atLineStart) {
            if (clip.x >= this.maxContentWidth) {
                return;
            }
            g.setColor(this.editor.getBackgroundColor());
            g.fillRect(clip.x, clip.y, Math.min(clip.width, this.maxContentWidth - clip.x), clip.height);
        }
        UISettings.setupAntialiasing((Graphics)g);
        Graphics2D g2 = (Graphics2D)g;
        Object hint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (!UIUtil.isRetina()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        try {
            this.paintAnnotations(g, clip);
        }
        finally {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
        }
    }

    private void paintAnnotations(Graphics g, Rectangle clip) {
        int endLine;
        int lineHeight = this.editor.getLineHeight();
        int startLine = clip.y / lineHeight;
        if (startLine >= (endLine = Math.min((clip.y + clip.height) / lineHeight + 1, this.editor.getVisibleLineCount()))) {
            return;
        }
        if (!this.atLineStart) {
            g.setColor((Color)JBColor.BLUE);
        }
        g.setFont(this.editor.getColorsScheme().getFont(EditorFontType.PLAIN));
        int y = (startLine + 1) * lineHeight - this.editor.getDescent();
        FontMetrics fontMetrics = this.editor.getFontMetrics(0);
        for (int line = startLine; line < endLine; ++line) {
            int logicalLine = this.editor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)line, (int)0)).line;
            if (this.atLineStart) {
                this.gutterContentProvider.drawIcon(logicalLine, g, y, this.editor);
            } else {
                String text = this.gutterContentProvider.getText(logicalLine, this.editor);
                if (text != null) {
                    g.drawString(text, this.maxContentWidth - this.gap - fontMetrics.stringWidth(text), y);
                }
            }
            y += lineHeight;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        TooltipController.getInstance().cancelTooltips();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        String toolTip;
        int line = EditorUtil.yPositionToLogicalLine((Editor)this.editor, e.getPoint());
        if (line == this.lastGutterToolTipLine) {
            return;
        }
        TooltipController controller = TooltipController.getInstance();
        if (this.lastGutterToolTipLine != -1) {
            controller.cancelTooltip(TOOLTIP_GROUP, e, true);
        }
        this.setCursor((toolTip = this.gutterContentProvider.getToolTip(line, this.editor)) == null ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(12));
        if (toolTip == null) {
            this.lastGutterToolTipLine = -1;
            controller.cancelTooltip(TOOLTIP_GROUP, e, false);
        } else {
            this.lastGutterToolTipLine = line;
            RelativePoint showPoint = new RelativePoint((Component)this, e.getPoint());
            controller.showTooltipByMouseMove(this.editor, showPoint, ((EditorMarkupModel)((Object)this.editor.getMarkupModel())).getErrorStripTooltipRendererProvider().calcTooltipRenderer(toolTip), false, TOOLTIP_GROUP, new HintHint(this, e.getPoint()).setAwtTooltip(true));
        }
    }

    public void documentCleared() {
        if (!this.atLineStart) {
            this.maxContentWidth = 0;
        }
    }
}

