/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startupWizard;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.startupWizard.StartupWizardModel;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ClickListener;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.wizard.WizardNavigationState;
import com.intellij.ui.wizard.WizardStep;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectPluginsStep
extends WizardStep<StartupWizardModel> {
    private JPanel myRootPanel;
    private JList myPluginsList;
    private JTextPane myDescriptionArea;
    private JButton myEnableAllButton;
    private JButton myDisableAllButton;
    private final List<IdeaPluginDescriptor> myPlugins;
    private final StartupWizardModel myModel;
    private final String myRequirePlugin;
    private static final String[] ourSuffixes = new String[]{"integration", "support", "plugin"};

    public SelectPluginsStep(String title, StartupWizardModel model, String requirePlugin) {
        super(title, "Select the plugins to enable. Disabling unused plugins will improve IDE startup speed and performance.\n\nTo change plugin settings later, go to " + ShowSettingsUtil.getSettingsMenuName() + " | Plugins.", null);
        this.$$$setupUI$$$();
        this.myPlugins = new ArrayList<IdeaPluginDescriptor>();
        this.myModel = model;
        this.myRequirePlugin = requirePlugin;
        this.myPluginsList.setCellRenderer(new ListCellRenderer(){
            private final JCheckBox myCheckbox = new JCheckBox();

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)value;
                this.myCheckbox.setEnabled(!SelectPluginsStep.this.myModel.isForceEnable(descriptor));
                if (isSelected) {
                    this.myCheckbox.setBackground(UIUtil.getListSelectionBackground());
                    this.myCheckbox.setForeground(UIUtil.getListSelectionForeground());
                } else {
                    this.myCheckbox.setBackground(UIUtil.getListBackground());
                    this.myCheckbox.setForeground(UIUtil.getListForeground());
                }
                this.myCheckbox.setText(SelectPluginsStep.getAbbreviatedName(descriptor) + SelectPluginsStep.this.buildRequires(descriptor));
                this.myCheckbox.setSelected(!SelectPluginsStep.this.myModel.isDisabledPlugin(descriptor));
                return this.myCheckbox;
            }
        });
        this.myPluginsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                IdeaPluginDescriptor pluginDescriptor = SelectPluginsStep.this.getSelectedPlugin();
                if (pluginDescriptor != null) {
                    String description = pluginDescriptor.getDescription();
                    SelectPluginsStep.this.myDescriptionArea.setText(description == null || description.startsWith("<") ? description : UIUtil.toHtml((String)description, (int)5));
                    SelectPluginsStep.this.myDescriptionArea.moveCaretPosition(0);
                } else {
                    SelectPluginsStep.this.myDescriptionArea.setText(UIUtil.toHtml((String)"Select a plugin to see its description"));
                }
            }
        });
        final int clickableArea = new JCheckBox((String)"").getMinimumSize().width;
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/startupWizard/SelectPluginsStep$3", "onClick"));
                }
                if (e.getX() < clickableArea) {
                    SelectPluginsStep.this.toggleSelection();
                }
                return true;
            }
        }.installOn((Component)this.myPluginsList);
        this.myPluginsList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == ' ') {
                    SelectPluginsStep.this.toggleSelection();
                }
            }
        });
        this.myEnableAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectPluginsStep.this.setAllPluginsEnabled(true);
            }
        });
        this.myDisableAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectPluginsStep.this.setAllPluginsEnabled(false);
            }
        });
    }

    private String buildRequires(IdeaPluginDescriptor descriptor) {
        StringBuilder requiresBuffer = new StringBuilder();
        for (PluginId id : StartupWizardModel.getNonOptionalDependencies(descriptor)) {
            IdeaPluginDescriptor dependent = this.findPlugin(id);
            if (dependent == null) continue;
            String name = SelectPluginsStep.getAbbreviatedName(dependent);
            if (requiresBuffer.length() == 0) {
                requiresBuffer.append("   (requires ");
            } else {
                requiresBuffer.append(", ");
            }
            requiresBuffer.append(name);
        }
        List<IdeaPluginDescriptor> requiredBy = this.myModel.getDependentsOnEarlierPages(descriptor, false);
        if (requiredBy.size() > 0) {
            if (requiresBuffer.length() > 0) {
                requiresBuffer.append(", ");
            } else {
                requiresBuffer.append("   (");
            }
            requiresBuffer.append("required by ");
            requiresBuffer.append(StringUtil.join(requiredBy, (Function)new Function<IdeaPluginDescriptor, String>(){

                public String fun(IdeaPluginDescriptor ideaPluginDescriptor) {
                    return SelectPluginsStep.getAbbreviatedName(ideaPluginDescriptor);
                }
            }, (String)", "));
        }
        if (requiresBuffer.length() > 0) {
            requiresBuffer.append(")");
        }
        return requiresBuffer.toString();
    }

    private static String getAbbreviatedName(IdeaPluginDescriptor descriptor) {
        String name = descriptor.getName();
        for (String suffix : ourSuffixes) {
            if (!name.toLowerCase().endsWith(suffix)) continue;
            return name.substring(0, name.length() - suffix.length()).trim();
        }
        return name;
    }

    private void toggleSelection() {
        Object[] selection;
        IdeaPluginDescriptor descriptor = this.getSelectedPlugin();
        if (descriptor == null || this.myModel.isForceEnable(descriptor)) {
            return;
        }
        boolean willDisable = !this.myModel.isDisabledPlugin(descriptor);
        for (Object o : selection = this.myPluginsList.getSelectedValues()) {
            IdeaPluginDescriptor desc = (IdeaPluginDescriptor)o;
            if (!willDisable) {
                this.myModel.setPluginEnabledWithDependencies(desc);
                continue;
            }
            this.myModel.setPluginDisabledWithDependents(desc);
        }
        this.myPluginsList.repaint();
    }

    private void setAllPluginsEnabled(boolean value) {
        for (IdeaPluginDescriptor descriptor : this.myPlugins) {
            if (!value && this.myModel.isForceEnable(descriptor)) continue;
            this.myModel.setPluginEnabled(descriptor, value);
        }
        this.myPluginsList.repaint();
    }

    @Nullable
    private IdeaPluginDescriptor findPlugin(PluginId id) {
        for (IdeaPluginDescriptor plugin : this.myPlugins) {
            if (!plugin.getPluginId().equals(id)) continue;
            return plugin;
        }
        return null;
    }

    @Nullable
    private IdeaPluginDescriptor getSelectedPlugin() {
        int leadSelectionIndex = this.myPluginsList.getSelectionModel().getLeadSelectionIndex();
        return leadSelectionIndex < 0 ? null : this.myPlugins.get(leadSelectionIndex);
    }

    @Override
    public JComponent prepare(WizardNavigationState state) {
        this.myRootPanel.revalidate();
        this.myPluginsList.requestFocusInWindow();
        return this.myRootPanel;
    }

    public void addPlugin(IdeaPluginDescriptor pluginDescriptor) {
        this.myPlugins.add(pluginDescriptor);
    }

    public void fillPlugins() {
        Collections.sort(this.myPlugins, new Comparator<IdeaPluginDescriptor>(){

            @Override
            public int compare(IdeaPluginDescriptor o1, IdeaPluginDescriptor o2) {
                return StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true);
            }
        });
        this.myPluginsList.setModel(new CollectionListModel(this.myPlugins));
        this.myPluginsList.setSelectedIndex(0);
    }

    public String getRequirePlugin() {
        return this.myRequirePlugin;
    }

    public List<IdeaPluginDescriptor> getPlugins() {
        return this.myPlugins;
    }

    @Override
    public WizardStep onNext(StartupWizardModel model) {
        SelectPluginsStep selectPluginsStep;
        String id;
        WizardStep next = super.onNext(model);
        if (next instanceof SelectPluginsStep && (id = (selectPluginsStep = (SelectPluginsStep)next).getRequirePlugin()) != null && model.getDisabledPluginIds().contains(id) && !model.isLast(next)) {
            for (IdeaPluginDescriptor descriptor : selectPluginsStep.getPlugins()) {
                model.getDisabledPluginIds().add(descriptor.getPluginId().getIdString());
            }
            return model.getNextFor(next);
        }
        return next;
    }

    @Override
    public WizardStep onPrevious(StartupWizardModel model) {
        SelectPluginsStep selectPluginsStep;
        String id;
        WizardStep prev = super.onPrevious(model);
        if (prev instanceof SelectPluginsStep && (id = (selectPluginsStep = (SelectPluginsStep)prev).getRequirePlugin()) != null && model.getDisabledPluginIds().contains(id) && !model.isFirst(prev)) {
            return model.getPreviousFor(prev);
        }
        return prev;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myPluginsList;
    }

    @Override
    public String getHelpId() {
        return "plugin.configuration.wizard";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JTextPane jTextPane;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        JBList jBList = new JBList();
        this.myPluginsList = jBList;
        jBScrollPane.setViewportView((Component)jBList);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel.add((Component)jBScrollPane2, new GridConstraints(2, 0, 1, 2, 0, 3, 7, 3, null, new Dimension(-1, 100), null));
        this.myDescriptionArea = jTextPane = new JTextPane();
        jTextPane.setText("<html>\r\n  <head>\r\n    \r\n  </head>\r\n  <body>\r\n    <p style=\"margin-top: 0\">\r\n      Please select a plugin to see its description\r\n    </p>\r\n  </body>\r\n</html>\r\n");
        jTextPane.setEditable(false);
        ((Component)jTextPane).setFont(UIManager.getFont("Label.font"));
        jTextPane.setContentType("text/html");
        ((Component)jTextPane).setBackground(UIManager.getColor("Label.background"));
        jBScrollPane2.setViewportView(jTextPane);
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 5, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myEnableAllButton = jButton2 = new JButton();
        jButton2.setText("Enable All");
        jButton2.setMnemonic('E');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myDisableAllButton = jButton = new JButton();
        jButton.setText("Disable All");
        jButton.setMnemonic('D');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

