/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.tracker;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.tracker.VirtualFileTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileTrackerImpl
implements VirtualFileTracker {
    private final Map<String, Set<VirtualFileListener>> myNonRefreshTrackers = new ConcurrentHashMap<String, Set<VirtualFileListener>>();
    private final Map<String, Set<VirtualFileListener>> myAllTrackers = new ConcurrentHashMap<String, Set<VirtualFileListener>>();

    public VirtualFileTrackerImpl(VirtualFileManager virtualFileManager) {
        virtualFileManager.addVirtualFileListener(new VirtualFileListener(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/tracker/VirtualFileTrackerImpl$1", "propertyChanged"));
                }
                Collection listeners = VirtualFileTrackerImpl.this.getListeners(event.getFile(), event.isFromRefresh());
                if (listeners == null) {
                    return;
                }
                for (VirtualFileListener listener2 : listeners) {
                    listener2.propertyChanged(event);
                }
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/tracker/VirtualFileTrackerImpl$1", "contentsChanged"));
                }
                Collection listeners = VirtualFileTrackerImpl.this.getListeners(event.getFile(), event.isFromRefresh());
                if (listeners == null) {
                    return;
                }
                for (VirtualFileListener listener2 : listeners) {
                    listener2.contentsChanged(event);
                }
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/tracker/VirtualFileTrackerImpl$1", "fileCreated"));
                }
                Collection listeners = VirtualFileTrackerImpl.this.getListeners(event.getFile(), event.isFromRefresh());
                if (listeners == null) {
                    return;
                }
                for (VirtualFileListener listener2 : listeners) {
                    listener2.fileCreated(event);
                }
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/tracker/VirtualFileTrackerImpl$1", "fileDeleted"));
                }
                Collection listeners = VirtualFileTrackerImpl.this.getListeners(event.getFile(), event.isFromRefresh());
                if (listeners == null) {
                    return;
                }
                for (VirtualFileListener listener2 : listeners) {
                    listener2.fileDeleted(event);
                }
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/tracker/VirtualFileTrackerImpl$1", "fileMoved"));
                }
                Collection listeners = VirtualFileTrackerImpl.this.getListeners(event.getFile(), event.isFromRefresh());
                if (listeners == null) {
                    return;
                }
                for (VirtualFileListener listener2 : listeners) {
                    listener2.fileMoved(event);
                }
            }

            public void fileCopied(@NotNull VirtualFileCopyEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/tracker/VirtualFileTrackerImpl$1", "fileCopied"));
                }
                Collection listeners = VirtualFileTrackerImpl.this.getListeners(event.getFile(), event.isFromRefresh());
                if (listeners == null) {
                    return;
                }
                for (VirtualFileListener listener2 : listeners) {
                    listener2.fileCopied(event);
                }
            }

            public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/tracker/VirtualFileTrackerImpl$1", "beforePropertyChange"));
                }
                Collection listeners = VirtualFileTrackerImpl.this.getListeners(event.getFile(), event.isFromRefresh());
                if (listeners == null) {
                    return;
                }
                for (VirtualFileListener listener2 : listeners) {
                    listener2.beforePropertyChange(event);
                }
            }

            public void beforeContentsChange(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/tracker/VirtualFileTrackerImpl$1", "beforeContentsChange"));
                }
                Collection listeners = VirtualFileTrackerImpl.this.getListeners(event.getFile(), event.isFromRefresh());
                if (listeners == null) {
                    return;
                }
                for (VirtualFileListener listener2 : listeners) {
                    listener2.beforeContentsChange(event);
                }
            }

            public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/tracker/VirtualFileTrackerImpl$1", "beforeFileDeletion"));
                }
                Collection listeners = VirtualFileTrackerImpl.this.getListeners(event.getFile(), event.isFromRefresh());
                if (listeners == null) {
                    return;
                }
                for (VirtualFileListener listener2 : listeners) {
                    listener2.beforeFileDeletion(event);
                }
            }

            public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/tracker/VirtualFileTrackerImpl$1", "beforeFileMovement"));
                }
                Collection listeners = VirtualFileTrackerImpl.this.getListeners(event.getFile(), event.isFromRefresh());
                if (listeners == null) {
                    return;
                }
                for (VirtualFileListener listener2 : listeners) {
                    listener2.beforeFileMovement(event);
                }
            }
        });
    }

    public void addTracker(final @NotNull String fileUrl, final @NotNull VirtualFileListener listener2, final boolean fromRefreshOnly, @NotNull Disposable parentDisposable) {
        if (fileUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileUrl", "com/intellij/openapi/vfs/tracker/VirtualFileTrackerImpl", "addTracker"));
        }
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vfs/tracker/VirtualFileTrackerImpl", "addTracker"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/vfs/tracker/VirtualFileTrackerImpl", "addTracker"));
        }
        VirtualFileTrackerImpl.getSet(fileUrl, this.myAllTrackers).add(listener2);
        if (!fromRefreshOnly) {
            VirtualFileTrackerImpl.getSet(fileUrl, this.myNonRefreshTrackers).add(listener2);
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                VirtualFileTrackerImpl.removeListener(fileUrl, listener2, VirtualFileTrackerImpl.this.myAllTrackers);
                if (!fromRefreshOnly) {
                    VirtualFileTrackerImpl.removeListener(fileUrl, listener2, VirtualFileTrackerImpl.this.myNonRefreshTrackers);
                }
            }
        });
    }

    private static void removeListener(String fileUrl, VirtualFileListener listener2, Map<String, Set<VirtualFileListener>> map) {
        Set<VirtualFileListener> listeners = map.get(fileUrl);
        if (listeners == null) {
            return;
        }
        listeners.remove(listener2);
        if (listeners.isEmpty()) {
            map.remove(fileUrl);
        }
    }

    private static Set<VirtualFileListener> getSet(String fileUrl, Map<String, Set<VirtualFileListener>> map) {
        Set listeners = map.get(fileUrl);
        if (listeners == null) {
            listeners = ContainerUtil.newConcurrentSet();
            map.put(fileUrl, listeners);
        }
        return listeners;
    }

    @Nullable
    private Collection<VirtualFileListener> getListeners(VirtualFile virtualFile, boolean fromRefresh) {
        Set<VirtualFileListener> listeners = null;
        while (virtualFile != null) {
            String url = virtualFile.getUrl();
            listeners = !fromRefresh ? VirtualFileTrackerImpl.addToSet(listeners, this.myNonRefreshTrackers.get(url)) : VirtualFileTrackerImpl.addToSet(listeners, this.myAllTrackers.get(url));
            virtualFile = virtualFile.getParent();
        }
        if (listeners == null || listeners.isEmpty()) {
            return null;
        }
        return listeners;
    }

    private static <T> Set<T> addToSet(Set<T> to, Set<T> what) {
        if (what == null || what.size() == 0) {
            return to;
        }
        if (to == null) {
            to = new HashSet<T>();
        }
        to.addAll(what);
        return to;
    }
}

