/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.ui.properties;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.impl.elements.CompositeElementWithManifest;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ManifestFileConfiguration;
import com.intellij.packaging.ui.PackagingElementPropertiesPanel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ElementWithManifestPropertiesPanel<E extends CompositeElementWithManifest<?>>
extends PackagingElementPropertiesPanel {
    private final E myElement;
    private final ArtifactEditorContext myContext;
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton myMainClassField;
    private TextFieldWithBrowseButton myClasspathField;
    private JLabel myTitleLabel;
    private JButton myCreateManifestButton;
    private JButton myUseExistingManifestButton;
    private JPanel myPropertiesPanel;
    private JTextField myManifestPathField;
    private JLabel myManifestNotFoundLabel;
    private ManifestFileConfiguration myManifestFileConfiguration;

    public ElementWithManifestPropertiesPanel(E element, ArtifactEditorContext context) {
        this.myElement = element;
        this.myContext = context;
        this.$$$setupUI$$$();
        ManifestFileUtil.setupMainClassField(context.getProject(), this.myMainClassField);
        this.myClasspathField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Messages.showTextAreaDialog((JTextField)ElementWithManifestPropertiesPanel.this.myClasspathField.getTextField(), (String)"Edit Classpath", (String)"classpath-attribute-editor");
            }
        });
        this.myClasspathField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ElementWithManifestPropertiesPanel.this.myContext.queueValidation();
            }
        });
        this.myUseExistingManifestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ElementWithManifestPropertiesPanel.this.chooseManifest();
            }
        });
        this.myCreateManifestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ElementWithManifestPropertiesPanel.this.createManifest();
            }
        });
    }

    private void createManifest() {
        VirtualFile file2 = ManifestFileUtil.showDialogAndCreateManifest(this.myContext, this.myElement);
        if (file2 == null) {
            return;
        }
        ManifestFileUtil.addManifestFileToLayout(file2.getPath(), this.myContext, this.myElement);
        this.updateManifest();
        this.myContext.getThisArtifactEditor().updateLayoutTree();
    }

    private void chooseManifest() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
                return super.isFileVisible(file2, showHiddenFiles) && (file2.isDirectory() || file2.getName().equalsIgnoreCase(ManifestFileUtil.MANIFEST_FILE_NAME));
            }
        };
        descriptor.setTitle("Specify Path to MANIFEST.MF File");
        VirtualFile file2 = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)this.myContext.getProject(), null);
        if (file2 == null) {
            return;
        }
        ManifestFileUtil.addManifestFileToLayout(file2.getPath(), this.myContext, this.myElement);
        this.updateManifest();
        this.myContext.getThisArtifactEditor().updateLayoutTree();
    }

    private void updateManifest() {
        String card;
        this.myManifestFileConfiguration = this.myContext.getManifestFile(this.myElement, this.myContext.getArtifactType());
        if (this.myManifestFileConfiguration != null) {
            card = "properties";
            this.myManifestPathField.setText(FileUtil.toSystemDependentName((String)this.myManifestFileConfiguration.getManifestFilePath()));
            this.myMainClassField.setText(StringUtil.notNullize((String)this.myManifestFileConfiguration.getMainClass()));
            this.myMainClassField.setEnabled(this.myManifestFileConfiguration.isWritable());
            this.myClasspathField.setText(StringUtil.join((Collection)this.myManifestFileConfiguration.getClasspath(), (String)" "));
            this.myClasspathField.setEnabled(this.myManifestFileConfiguration.isWritable());
        } else {
            card = "buttons";
            this.myManifestPathField.setText("");
        }
        ((CardLayout)this.myPropertiesPanel.getLayout()).show(this.myPropertiesPanel, card);
    }

    public void reset() {
        this.myTitleLabel.setText("'" + this.myElement.getName() + "' manifest properties:");
        this.myManifestNotFoundLabel.setText("META-INF/MANIFEST.MF file not found in '" + this.myElement.getName() + "'");
        this.updateManifest();
    }

    public boolean isModified() {
        return this.myManifestFileConfiguration != null && (!this.myManifestFileConfiguration.getClasspath().equals(this.getConfiguredClasspath()) || !Comparing.equal((String)this.myManifestFileConfiguration.getMainClass(), (String)this.getConfiguredMainClass()) || !Comparing.equal((String)this.myManifestFileConfiguration.getManifestFilePath(), (String)this.getConfiguredManifestPath()));
    }

    @Nullable
    private String getConfiguredManifestPath() {
        String path = this.myManifestPathField.getText();
        return path.length() != 0 ? FileUtil.toSystemIndependentName((String)path) : null;
    }

    public void apply() {
        if (this.myManifestFileConfiguration != null) {
            this.myManifestFileConfiguration.setMainClass(this.getConfiguredMainClass());
            this.myManifestFileConfiguration.setClasspath(this.getConfiguredClasspath());
            this.myManifestFileConfiguration.setManifestFilePath(this.getConfiguredManifestPath());
        }
    }

    private List<String> getConfiguredClasspath() {
        return StringUtil.split((String)this.myClasspathField.getText(), (String)" ");
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/ui/properties/ElementWithManifestPropertiesPanel", "createComponent"));
        }
        return jPanel;
    }

    @Nullable
    private String getConfiguredMainClass() {
        String className = this.myMainClassField.getText();
        return className.length() != 0 ? className : null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JButton jButton;
        JButton jButton2;
        JTextField jTextField;
        JLabel jLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myPropertiesPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, "properties");
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/CompilerBundle").getString("label.text.main.class"));
        jPanel3.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMainClassField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/CompilerBundle").getString("label.text.class.path"));
        jPanel3.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myClasspathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myTitleLabel = jLabel2 = new JLabel();
        jLabel2.setText("element name");
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Manifest File:");
        jLabel5.setDisplayedMnemonic('F');
        jLabel5.setDisplayedMnemonicIndex(9);
        jPanel3.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myManifestPathField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel3.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, "buttons");
        this.myCreateManifestButton = jButton2 = new JButton();
        jButton2.setText("Create Manifest...");
        jButton2.setMnemonic('C');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myUseExistingManifestButton = jButton = new JButton();
        jButton.setText("Use Existing Manifest...");
        jButton.setMnemonic('U');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myManifestNotFoundLabel = jLabel = new JLabel();
        jLabel.setText("META-INF/MANIFEST.MF file not found");
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        jLabel5.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

