/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.HelpID;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveClassesOrPackagesCallback;
import com.intellij.refactoring.move.MoveDialogBase;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.DestinationFolderComboBox;
import com.intellij.refactoring.move.moveClassesOrPackages.JavaMoveClassesOrPackagesHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassToInnerProcessor;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesImpl;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesProcessor;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.ui.ClassNameReferenceEditor;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveClassesOrPackagesDialog
extends MoveDialogBase {
    @NonNls
    private static final String RECENTS_KEY = "MoveClassesOrPackagesDialog.RECENTS_KEY";
    private final PsiElement[] myElementsToMove;
    private final MoveCallback myMoveCallback;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesDialog");
    private JLabel myNameLabel;
    private ReferenceEditorComboWithBrowseButton myWithBrowseButtonReference;
    private JCheckBox myCbSearchInComments;
    private JCheckBox myCbSearchTextOccurences;
    private String myHelpID;
    private final boolean mySearchTextOccurencesEnabled;
    private final PsiManager myManager;
    private JPanel myMainPanel;
    private JRadioButton myToPackageRadioButton;
    private JRadioButton myMakeInnerClassOfRadioButton;
    private ReferenceEditorComboWithBrowseButton myClassPackageChooser;
    private JPanel myCardPanel;
    private ReferenceEditorWithBrowseButton myInnerClassChooser;
    private JPanel myMoveClassPanel;
    private JPanel myMovePackagePanel;
    private ComboboxWithBrowseButton myDestinationFolderCB;
    private JPanel myTargetPanel;
    private JLabel myTargetDestinationLabel;
    private JPanel myOpenInEditorPanel;
    private boolean myHavePackages;
    private boolean myTargetDirectoryFixed;
    private boolean mySuggestToMoveToAnotherRoot;

    public MoveClassesOrPackagesDialog(Project project2, boolean searchTextOccurences, PsiElement[] elementsToMove, PsiElement initialTargetElement, MoveCallback moveCallback) {
        super(project2, true);
        this.myElementsToMove = elementsToMove;
        this.myMoveCallback = moveCallback;
        this.$$$setupUI$$$();
        this.myManager = PsiManager.getInstance((Project)this.myProject);
        this.setTitle(MoveHandler.REFACTORING_NAME);
        this.mySearchTextOccurencesEnabled = searchTextOccurences;
        this.selectInitialCard();
        this.init();
        if (initialTargetElement instanceof PsiClass) {
            this.myMakeInnerClassOfRadioButton.setSelected(true);
            this.myInnerClassChooser.setText(((PsiClass)initialTargetElement).getQualifiedName());
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    MoveClassesOrPackagesDialog.this.myInnerClassChooser.requestFocus();
                }
            }, ModalityState.stateForComponent((Component)this.myMainPanel));
        } else if (initialTargetElement instanceof PsiPackage) {
            this.myClassPackageChooser.setText(((PsiPackage)initialTargetElement).getQualifiedName());
        }
        this.updateControlsEnabled();
        this.myToPackageRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MoveClassesOrPackagesDialog.this.updateControlsEnabled();
                MoveClassesOrPackagesDialog.this.myClassPackageChooser.requestFocus();
            }
        });
        this.myMakeInnerClassOfRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MoveClassesOrPackagesDialog.this.updateControlsEnabled();
                MoveClassesOrPackagesDialog.this.myInnerClassChooser.requestFocus();
            }
        });
        for (PsiElement element : elementsToMove) {
            if (element.getContainingFile() == null) continue;
            this.myOpenInEditorPanel.add((Component)this.initOpenInEditorCb(), "East");
            break;
        }
    }

    private void updateControlsEnabled() {
        this.myClassPackageChooser.setEnabled(this.myToPackageRadioButton.isSelected());
        this.myInnerClassChooser.setEnabled(this.myMakeInnerClassOfRadioButton.isSelected());
        UIUtil.setEnabled((Component)this.myTargetPanel, (this.isMoveToPackage() && this.getSourceRoots().size() > 1 && !this.myTargetDirectoryFixed ? 1 : 0) != 0, (boolean)true);
        this.validateButtons();
    }

    private void selectInitialCard() {
        this.myHavePackages = false;
        for (PsiElement psiElement : this.myElementsToMove) {
            if (psiElement instanceof PsiClass) continue;
            this.myHavePackages = true;
            break;
        }
        CardLayout cardLayout = (CardLayout)this.myCardPanel.getLayout();
        cardLayout.show(this.myCardPanel, this.myHavePackages ? "Package" : "Class");
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myHavePackages ? this.myWithBrowseButtonReference.getChildComponent() : this.myClassPackageChooser.getChildComponent();
    }

    protected JComponent createCenterPanel() {
        boolean isDestinationVisible = this.getSourceRoots().size() > 1;
        this.myDestinationFolderCB.setVisible(isDestinationVisible);
        this.myTargetDestinationLabel.setVisible(isDestinationVisible);
        return null;
    }

    private void createUIComponents() {
        this.myMainPanel = new JPanel();
        this.myWithBrowseButtonReference = this.createPackageChooser();
        this.myClassPackageChooser = this.createPackageChooser();
        GlobalSearchScope scope = JavaProjectRootsUtil.getScopeWithoutGeneratedSources(ProjectScope.getProjectScope((Project)this.myProject), this.myProject);
        this.myInnerClassChooser = new ClassNameReferenceEditor(this.myProject, null, scope);
        this.myInnerClassChooser.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                MoveClassesOrPackagesDialog.this.validateButtons();
            }
        });
        this.myCardPanel = new JPanel(){

            @Override
            public Dimension getMinimumSize() {
                return MoveClassesOrPackagesDialog.this.myHavePackages ? MoveClassesOrPackagesDialog.this.myMovePackagePanel.getMinimumSize() : MoveClassesOrPackagesDialog.this.myMoveClassPanel.getMinimumSize();
            }

            @Override
            public Dimension getPreferredSize() {
                return MoveClassesOrPackagesDialog.this.myHavePackages ? MoveClassesOrPackagesDialog.this.myMovePackagePanel.getPreferredSize() : MoveClassesOrPackagesDialog.this.myMoveClassPanel.getPreferredSize();
            }
        };
        this.myDestinationFolderCB = new DestinationFolderComboBox(){

            @Override
            public String getTargetPackage() {
                return MoveClassesOrPackagesDialog.this.getTargetPackage();
            }
        };
    }

    private ReferenceEditorComboWithBrowseButton createPackageChooser() {
        PackageNameReferenceEditorCombo packageChooser = new PackageNameReferenceEditorCombo("", this.myProject, RECENTS_KEY, RefactoringBundle.message((String)"choose.destination.package"));
        Document document = ((EditorComboBox)packageChooser.getChildComponent()).getDocument();
        document.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                MoveClassesOrPackagesDialog.this.validateButtons();
            }
        });
        return packageChooser;
    }

    protected JComponent createNorthPanel() {
        if (!this.mySearchTextOccurencesEnabled) {
            this.myCbSearchTextOccurences.setEnabled(false);
            this.myCbSearchTextOccurences.setVisible(false);
            this.myCbSearchTextOccurences.setSelected(false);
        }
        return this.myMainPanel;
    }

    protected String getDimensionServiceKey() {
        return this.myHavePackages ? "#com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesDialog.packages" : "#com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesDialog.classes";
    }

    public void setData(PsiElement[] psiElements, String targetPackageName, PsiDirectory initialTargetDirectory, boolean isTargetDirectoryFixed, boolean suggestToMoveToAnotherRoot, boolean searchInComments, boolean searchForTextOccurences, String helpID) {
        String nameFromCallback;
        this.myTargetDirectoryFixed = isTargetDirectoryFixed;
        this.mySuggestToMoveToAnotherRoot = suggestToMoveToAnotherRoot;
        if (targetPackageName.length() != 0) {
            this.myWithBrowseButtonReference.prependItem(targetPackageName);
            this.myClassPackageChooser.prependItem(targetPackageName);
        }
        String string = nameFromCallback = this.myMoveCallback instanceof MoveClassesOrPackagesCallback ? ((MoveClassesOrPackagesCallback)this.myMoveCallback).getElementsToMoveName() : null;
        if (nameFromCallback != null) {
            this.myNameLabel.setText(nameFromCallback);
        } else if (psiElements.length == 1) {
            PsiElement firstElement = psiElements[0];
            if (firstElement instanceof PsiClass) {
                LOG.assertTrue(!MoveClassesOrPackagesImpl.isClassInnerOrLocal((PsiClass)firstElement));
            } else {
                PsiElement parent = firstElement.getParent();
                LOG.assertTrue(parent != null);
            }
            this.myNameLabel.setText(RefactoringBundle.message((String)"move.single.class.or.package.name.label", (Object[])new Object[]{UsageViewUtil.getType(firstElement), UsageViewUtil.getLongName(firstElement)}));
        } else if (psiElements.length > 1) {
            this.myNameLabel.setText(psiElements[0] instanceof PsiClass ? RefactoringBundle.message((String)"move.specified.classes") : RefactoringBundle.message((String)"move.specified.packages"));
        }
        this.selectInitialCard();
        this.myCbSearchInComments.setSelected(searchInComments);
        this.myCbSearchTextOccurences.setSelected(searchForTextOccurences);
        if (initialTargetDirectory != null && JavaMoveClassesOrPackagesHandler.packageHasMultipleDirectoriesInModule(this.myProject, initialTargetDirectory)) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            HashSet initialRoots = new HashSet();
            MoveClassesOrPackagesDialog.collectSourceRoots(psiElements, fileIndex, (Set<VirtualFile>)initialRoots);
            if (initialRoots.size() > 1) {
                initialTargetDirectory = null;
            }
        }
        ((DestinationFolderComboBox)this.myDestinationFolderCB).setData(this.myProject, initialTargetDirectory, new Pass<String>(){

            public void pass(String s) {
                MoveClassesOrPackagesDialog.this.setErrorText(s);
            }
        }, this.myHavePackages ? (EditorComboBox)this.myWithBrowseButtonReference.getChildComponent() : (EditorComboBox)this.myClassPackageChooser.getChildComponent());
        UIUtil.setEnabled((Component)this.myTargetPanel, (!this.getSourceRoots().isEmpty() && this.isMoveToPackage() && !isTargetDirectoryFixed ? 1 : 0) != 0, (boolean)true);
        this.validateButtons();
        this.myHelpID = helpID;
    }

    private static void collectSourceRoots(PsiElement[] psiElements, ProjectFileIndex fileIndex, Set<VirtualFile> initialRoots) {
        for (PsiElement element : psiElements) {
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element);
            if (file2 != null) {
                VirtualFile sourceRootForFile = fileIndex.getSourceRootForFile(file2);
                if (sourceRootForFile == null) continue;
                initialRoots.add(sourceRootForFile);
                continue;
            }
            if (!(element instanceof PsiDirectoryContainer)) continue;
            MoveClassesOrPackagesDialog.collectSourceRoots((PsiElement[])((PsiDirectoryContainer)element).getDirectories(), fileIndex, initialRoots);
        }
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.myHelpID);
    }

    protected final boolean isSearchInComments() {
        return this.myCbSearchInComments.isSelected();
    }

    @Override
    protected void canRun() throws ConfigurationException {
        if (this.isMoveToPackage()) {
            String name = this.getTargetPackage().trim();
            if (name.length() != 0 && !PsiNameHelper.getInstance((Project)this.myManager.getProject()).isQualifiedName(name)) {
                throw new ConfigurationException("'" + name + "' is invalid destination package name");
            }
        } else {
            if (this.findTargetClass() == null) {
                throw new ConfigurationException("Destination class not found");
            }
            String validationError = this.verifyInnerClassDestination();
            if (validationError != null) {
                throw new ConfigurationException(validationError);
            }
        }
    }

    @Nullable
    private PsiClass findTargetClass() {
        String name = this.myInnerClassChooser.getText().trim();
        return JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findClass(name, ProjectScope.getProjectScope((Project)this.myProject));
    }

    protected boolean isMoveToPackage() {
        return this.myHavePackages || this.myToPackageRadioButton.isSelected();
    }

    protected String getTargetPackage() {
        return this.myHavePackages ? this.myWithBrowseButtonReference.getText() : this.myClassPackageChooser.getText();
    }

    @Nullable
    private static String verifyDestinationForElement(PsiElement element, MoveDestination moveDestination) {
        String message = element instanceof PsiDirectory ? moveDestination.verify((PsiDirectory)element) : (element instanceof PsiPackage ? moveDestination.verify((PsiPackage)element) : moveDestination.verify(element.getContainingFile()));
        return message;
    }

    @Override
    protected void doAction() {
        this.saveOpenInEditorOption();
        if (this.isMoveToPackage()) {
            this.invokeMoveToPackage();
        } else {
            this.invokeMoveToInner();
        }
    }

    private void invokeMoveToPackage() {
        MoveDestination destination = this.selectDestination();
        if (destination == null) {
            return;
        }
        this.saveRefactoringSettings();
        for (PsiElement element : this.myElementsToMove) {
            String message = MoveClassesOrPackagesDialog.verifyDestinationForElement(element, destination);
            if (message == null) continue;
            String helpId = HelpID.getMoveHelpID(this.myElementsToMove[0]);
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)message, (String)helpId, (Project)this.getProject());
            return;
        }
        try {
            for (PsiElement element : this.myElementsToMove) {
                if (!(element instanceof PsiClass)) continue;
                PsiClass aClass = (PsiClass)element;
                LOG.assertTrue(aClass.isPhysical(), (Object)aClass);
                PsiDirectory targetDirectory = destination.getTargetIfExists(element.getContainingFile());
                if (targetDirectory == null) continue;
                MoveFilesOrDirectoriesUtil.checkMove((PsiElement)aClass, (PsiElement)targetDirectory);
            }
            MoveClassesOrPackagesProcessor processor2 = this.createMoveToPackageProcessor(destination, this.myElementsToMove, this.myMoveCallback);
            if (processor2.verifyValidPackageName()) {
                processor2.setOpenInEditor(this.isOpenInEditor());
                this.invokeRefactoring(processor2);
            }
        }
        catch (IncorrectOperationException e) {
            String helpId = HelpID.getMoveHelpID(this.myElementsToMove[0]);
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)e.getMessage(), (String)helpId, (Project)this.getProject());
        }
    }

    protected MoveClassesOrPackagesProcessor createMoveToPackageProcessor(MoveDestination destination, PsiElement[] elementsToMove, MoveCallback callback) {
        return new MoveClassesOrPackagesProcessor(this.getProject(), elementsToMove, destination, this.isSearchInComments(), this.isSearchInNonJavaFiles(), callback);
    }

    private void saveRefactoringSettings() {
        JavaRefactoringSettings refactoringSettings = JavaRefactoringSettings.getInstance();
        boolean searchInComments = this.isSearchInComments();
        boolean searchForTextOccurences = this.isSearchInNonJavaFiles();
        refactoringSettings.MOVE_SEARCH_IN_COMMENTS = searchInComments;
        refactoringSettings.MOVE_SEARCH_FOR_TEXT = searchForTextOccurences;
        refactoringSettings.MOVE_PREVIEW_USAGES = this.isPreviewUsages();
    }

    @Nullable
    private String verifyInnerClassDestination() {
        PsiClass targetClass = this.findTargetClass();
        if (targetClass == null) {
            return null;
        }
        for (PsiElement element : this.myElementsToMove) {
            if (PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)targetClass, (boolean)false)) {
                return RefactoringBundle.message((String)"move.class.to.inner.move.to.self.error");
            }
            Language targetClassLanguage = targetClass.getLanguage();
            if (element.getLanguage().equals(targetClassLanguage)) continue;
            return RefactoringBundle.message((String)"move.to.different.language", (Object[])new Object[]{UsageViewUtil.getType(element), ((PsiClass)element).getQualifiedName(), targetClass.getQualifiedName()});
        }
        while (targetClass != null) {
            if (targetClass.getContainingClass() != null && !targetClass.hasModifierProperty("static")) {
                return RefactoringBundle.message((String)"move.class.to.inner.nonstatic.error");
            }
            targetClass = targetClass.getContainingClass();
        }
        return null;
    }

    private void invokeMoveToInner() {
        this.saveRefactoringSettings();
        PsiClass targetClass = this.findTargetClass();
        if (targetClass == null) {
            return;
        }
        PsiClass[] classesToMove = new PsiClass[this.myElementsToMove.length];
        for (int i = 0; i < this.myElementsToMove.length; ++i) {
            classesToMove[i] = (PsiClass)this.myElementsToMove[i];
        }
        MoveClassToInnerProcessor processor2 = this.createMoveToInnerProcessor(targetClass, classesToMove, this.myMoveCallback);
        processor2.setOpenInEditor(this.isOpenInEditor());
        this.invokeRefactoring(processor2);
    }

    protected MoveClassToInnerProcessor createMoveToInnerProcessor(@NotNull PsiClass destination, @NotNull PsiClass[] classesToMove, @Nullable MoveCallback callback) {
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesDialog", "createMoveToInnerProcessor"));
        }
        if (classesToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classesToMove", "com/intellij/refactoring/move/moveClassesOrPackages/MoveClassesOrPackagesDialog", "createMoveToInnerProcessor"));
        }
        return new MoveClassToInnerProcessor(this.getProject(), classesToMove, destination, this.isSearchInComments(), this.isSearchInNonJavaFiles(), callback);
    }

    protected final boolean isSearchInNonJavaFiles() {
        return this.myCbSearchTextOccurences.isSelected();
    }

    @Nullable
    private MoveDestination selectDestination() {
        int ret;
        String packageName = this.getTargetPackage().trim();
        if (packageName.length() > 0 && !PsiNameHelper.getInstance((Project)this.myManager.getProject()).isQualifiedName(packageName)) {
            Messages.showErrorDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"please.enter.a.valid.target.package.name"), (String)RefactoringBundle.message((String)"move.title"));
            return null;
        }
        RecentsManager.getInstance(this.myProject).registerRecentEntry(RECENTS_KEY, packageName);
        PackageWrapper targetPackage = new PackageWrapper(this.myManager, packageName);
        if (!targetPackage.exists() && (ret = Messages.showYesNoDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"package.does.not.exist", (Object[])new Object[]{packageName}), (String)RefactoringBundle.message((String)"move.title"), (Icon)Messages.getQuestionIcon())) != 0) {
            return null;
        }
        return ((DestinationFolderComboBox)this.myDestinationFolderCB).selectDirectory(targetPackage, this.mySuggestToMoveToAnotherRoot);
    }

    private List<VirtualFile> getSourceRoots() {
        return JavaProjectRootsUtil.getSuitableDestinationSourceRoots(this.myProject);
    }

    @Override
    protected String getMovePropertySuffix() {
        return "Class";
    }

    @Override
    protected String getCbTitle() {
        return "Open moved in editor";
    }

    @Override
    protected boolean isEnabledByDefault() {
        return false;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JPanel jPanel2;
        JPanel jPanel3;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel4;
        JLabel jLabel2;
        JPanel jPanel5;
        this.createUIComponents();
        this.myMainPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myNameLabel = jLabel2 = new JLabel();
        Font font = jLabel2.getFont();
        if (font != null) {
            jLabel2.setFont(new Font(font.getName(), 1, font.getSize()));
        }
        jLabel2.setText("Move");
        ((Component)jLabel2).setEnabled(true);
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        NonFocusableCheckBox nonFocusableCheckBox = new NonFocusableCheckBox();
        this.myCbSearchInComments = nonFocusableCheckBox;
        nonFocusableCheckBox.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox, ResourceBundle.getBundle("messages/RefactoringBundle").getString("search.in.comments.and.strings"));
        jPanel5.add((Component)nonFocusableCheckBox, new GridConstraints(2, 0, 1, 1, 8, 3, 0, 0, null, null, null));
        NonFocusableCheckBox nonFocusableCheckBox2 = new NonFocusableCheckBox();
        this.myCbSearchTextOccurences = nonFocusableCheckBox2;
        nonFocusableCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox2, ResourceBundle.getBundle("messages/RefactoringBundle").getString("search.for.text.occurrences"));
        jPanel5.add((Component)nonFocusableCheckBox2, new GridConstraints(2, 1, 1, 1, 8, 3, 0, 0, null, null, null));
        JPanel jPanel6 = this.myCardPanel;
        jPanel6.setLayout(new CardLayout(0, 0));
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myMoveClassPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(7, 0, 7, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel4, "Class");
        this.myToPackageRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/RefactoringBundle").getString("move.classes.destination.to.package"));
        jRadioButton2.setSelected(true);
        jPanel4.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMakeInnerClassOfRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/RefactoringBundle").getString("move.classes.destination.make.inner"));
        jPanel4.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.myClassPackageChooser;
        jPanel4.add((Component)((Object)referenceEditorComboWithBrowseButton), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        ReferenceEditorWithBrowseButton referenceEditorWithBrowseButton = this.myInnerClassChooser;
        jPanel4.add((Component)((Object)referenceEditorWithBrowseButton), new GridConstraints(1, 1, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myMovePackagePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(7, 0, 7, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel3, "Package");
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton2 = this.myWithBrowseButtonReference;
        jPanel3.add((Component)((Object)referenceEditorComboWithBrowseButton2), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("To package:");
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTargetPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myTargetDestinationLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/RefactoringBundle").getString("target.destination.folder"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.myDestinationFolderCB;
        jPanel2.add((Component)comboboxWithBrowseButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myOpenInEditorPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jLabel.setLabelFor((Component)comboboxWithBrowseButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

