/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import com.intellij.testFramework.LoggedErrorProcessor;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class TestLogger
extends Log4jBasedLogger {
    public TestLogger(Logger logger) {
        super(logger);
    }

    public void warn(String message, @Nullable Throwable t) {
        t = TestLogger.checkException((Throwable)t);
        LoggedErrorProcessor.getInstance().processWarn(message, t, this.myLogger);
    }

    public void error(String message, @Nullable Throwable t, String ... details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/testFramework/TestLogger", "error"));
        }
        t = TestLogger.checkException((Throwable)t);
        LoggedErrorProcessor.getInstance().processError(message, t, details, this.myLogger);
    }

    public Level getLevel() {
        return this.myLogger.getLevel();
    }
}

