/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.asserttoif;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ipp.asserttoif.IfStatementPredicate;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ObjectsRequireNonNullIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        NullCheckedAssignmentPredicate nullCheckedAssignmentPredicate = new NullCheckedAssignmentPredicate();
        if (nullCheckedAssignmentPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/asserttoif/ObjectsRequireNonNullIntention", "getElementPredicate"));
        }
        return nullCheckedAssignmentPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/asserttoif/ObjectsRequireNonNullIntention", "processIntention"));
        }
        if (!(element instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiVariable)) {
            return;
        }
        PsiVariable variable = (PsiVariable)target;
        List notNulls = NullableNotNullManager.getInstance((Project)element.getProject()).getNotNulls();
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)variable, (Collection)notNulls);
        if (annotation != null) {
            annotation.delete();
        } else {
            PsiStatement referenceStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiStatement.class);
            if (referenceStatement == null) {
                return;
            }
            PsiElement parent = referenceStatement.getParent();
            if (!(parent instanceof PsiCodeBlock)) {
                return;
            }
            PsiCodeBlock codeBlock = (PsiCodeBlock)parent;
            PsiStatement[] statements = codeBlock.getStatements();
            PsiStatement statementToDelete = null;
            for (PsiStatement statement2 : statements) {
                if (statement2 == referenceStatement) break;
                if (!NullCheckedAssignmentPredicate.isNotNullAssertion(statement2, variable) && !NullCheckedAssignmentPredicate.isIfStatementNullCheck(statement2, variable)) continue;
                statementToDelete = statement2;
                break;
            }
            if (statementToDelete == null) {
                return;
            }
            statementToDelete.delete();
        }
        PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)referenceExpression, "java.util.Objects.requireNonNull(" + referenceExpression.getText() + ")");
    }

    private static class NullCheckedAssignmentPredicate
    implements PsiElementPredicate {
        private NullCheckedAssignmentPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element) {
            PsiStatement[] statements;
            PsiElement parent;
            if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)element)) {
                return false;
            }
            if (!(element instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            if (PsiUtil.isAccessedForWriting((PsiExpression)referenceExpression)) {
                return false;
            }
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)target;
            if (ClassUtils.findClass("java.util.Objects", element) == null) {
                return false;
            }
            PsiAnnotation annotation = NullableNotNullManager.getInstance((Project)variable.getProject()).getNotNullAnnotation((PsiModifierListOwner)variable, true);
            if (annotation != null && annotation.isWritable()) {
                return true;
            }
            PsiStatement referenceStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiStatement.class);
            PsiElement psiElement = parent = referenceStatement != null ? referenceStatement.getParent() : null;
            if (!(parent instanceof PsiCodeBlock)) {
                return false;
            }
            PsiCodeBlock codeBlock = (PsiCodeBlock)parent;
            for (PsiStatement statement2 : statements = codeBlock.getStatements()) {
                if (statement2 == referenceStatement) {
                    return false;
                }
                if (!NullCheckedAssignmentPredicate.isNotNullAssertion(statement2, variable) && !NullCheckedAssignmentPredicate.isIfStatementNullCheck(statement2, variable)) continue;
                return true;
            }
            return false;
        }

        private static boolean isIfStatementNullCheck(PsiStatement statement2, @NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ipp/asserttoif/ObjectsRequireNonNullIntention$NullCheckedAssignmentPredicate", "isIfStatementNullCheck"));
            }
            if (!(statement2 instanceof PsiIfStatement)) {
                return false;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)statement2;
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch != null) {
                return false;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (!IfStatementPredicate.isSimpleThrowStatement(thenBranch)) {
                return false;
            }
            PsiExpression condition = ifStatement.getCondition();
            return NullCheckedAssignmentPredicate.isNullComparison(condition, variable, true);
        }

        private static boolean isNotNullAssertion(PsiStatement statement2, @NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ipp/asserttoif/ObjectsRequireNonNullIntention$NullCheckedAssignmentPredicate", "isNotNullAssertion"));
            }
            if (!(statement2 instanceof PsiAssertStatement)) {
                return false;
            }
            PsiAssertStatement assertStatement = (PsiAssertStatement)statement2;
            PsiExpression condition = assertStatement.getAssertCondition();
            return NullCheckedAssignmentPredicate.isNullComparison(condition, variable, false);
        }

        private static boolean isNullComparison(PsiExpression expression, @NotNull PsiVariable variable, boolean equal) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ipp/asserttoif/ObjectsRequireNonNullIntention$NullCheckedAssignmentPredicate", "isNullComparison"));
            }
            if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (equal ? !JavaTokenType.EQEQ.equals(tokenType) : !JavaTokenType.NE.equals(tokenType)) {
                return false;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return false;
            }
            return PsiType.NULL.equals((Object)rhs.getType()) && VariableAccessUtils.evaluatesToVariable(lhs, variable) || PsiType.NULL.equals((Object)lhs.getType()) && VariableAccessUtils.evaluatesToVariable(rhs, variable);
        }
    }
}

