/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.platform.ProjectSetReader;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;

public class ProjectSetRequestHandler
extends RestService {
    @Override
    protected boolean isMethodSupported(@NotNull HttpMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/ide/ProjectSetRequestHandler", "isMethodSupported"));
        }
        return method == HttpMethod.POST;
    }

    @Override
    @NotNull
    protected String getServiceName() {
        if ("openProjectSet" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/ProjectSetRequestHandler", "getServiceName"));
        }
        return "openProjectSet";
    }

    @Override
    protected boolean isPrefixlessAllowed() {
        return true;
    }

    @Override
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) throws IOException {
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/ide/ProjectSetRequestHandler", "execute"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/ProjectSetRequestHandler", "execute"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/ide/ProjectSetRequestHandler", "execute"));
        }
        final JsonObject descriptor = new JsonParser().parse(ProjectSetRequestHandler.createJsonReader(request)).getAsJsonObject();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                new ProjectSetReader().readDescriptor(descriptor, null);
                RestService.activateLastFocusedFrame();
            }
        }, ModalityState.defaultModalityState());
        ProjectSetRequestHandler.sendOk(request, context);
        return null;
    }

    @Override
    public boolean isAccessible(@NotNull HttpRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/ProjectSetRequestHandler", "isAccessible"));
        }
        return false;
    }
}

