/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.search;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.intellij.plugins.xpathView.search.SearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopePanel
extends JPanel
implements Disposable {
    private JPanel myRoot;
    private JRadioButton myWholeProjectScope;
    private JRadioButton myModuleScope;
    private ModulesComboBox myModuleSelection;
    private JRadioButton myDirectoryScope;
    private TextFieldWithBrowseButton myDirectory;
    private JCheckBox myRecursive;
    private JRadioButton myCustomScope;
    private ComboboxWithBrowseButton myCustomScopeSelection;
    private final Project myProject;

    public ScopePanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/xpathView/search/ScopePanel", "<init>"));
        }
        this.myProject = project;
        this.$$$setupUI$$$();
    }

    public void initComponent(@Nullable Module currentModule, SearchScope scope) {
        Module m;
        ItemListener stateListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ScopePanel.this.myModuleSelection.setEnabled(ScopePanel.this.myModuleScope.isSelected());
                ScopePanel.this.myDirectory.setEnabled(ScopePanel.this.myDirectoryScope.isSelected());
                ScopePanel.this.myRecursive.setEnabled(ScopePanel.this.myDirectoryScope.isSelected());
                ScopePanel.this.myCustomScopeSelection.setEnabled(ScopePanel.this.myCustomScope.isSelected());
                if (e.getStateChange() == 1) {
                    ScopePanel.this.firePropertyChange("scope", null, ScopePanel.this.getSelectedScope());
                }
            }
        };
        ItemListener scopeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ScopePanel.this.firePropertyChange("scope", null, ScopePanel.this.getSelectedScope());
                }
            }
        };
        this.myWholeProjectScope.addItemListener(stateListener);
        this.myWholeProjectScope.setSelected(scope.getScopeType() == SearchScope.ScopeType.PROJECT);
        this.myModuleScope.addItemListener(stateListener);
        this.myModuleScope.setSelected(scope.getScopeType() == SearchScope.ScopeType.MODULE);
        this.myDirectoryScope.addItemListener(stateListener);
        this.myDirectoryScope.setSelected(scope.getScopeType() == SearchScope.ScopeType.DIRECTORY);
        this.myCustomScope.addItemListener(stateListener);
        this.myCustomScope.setSelected(scope.getScopeType() == SearchScope.ScopeType.CUSTOM);
        this.myModuleSelection.fillModules(this.myProject);
        if (scope.getModuleName() != null) {
            m = ModuleManager.getInstance((Project)this.myProject).findModuleByName(scope.getModuleName());
            if (m == null) {
                m = currentModule;
            }
        } else {
            m = currentModule;
        }
        if (m != null) {
            this.myModuleSelection.setSelectedModule(m);
        }
        this.myModuleSelection.addItemListener(scopeListener);
        ((ScopeChooserCombo)this.myCustomScopeSelection).init(this.myProject, true, true, scope.getScopeName());
        this.myCustomScopeSelection.getComboBox().addItemListener(scopeListener);
        this.myDirectory.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ScopePanel.this.firePropertyChange("scope", null, ScopePanel.this.getSelectedScope());
            }
        });
        this.myDirectory.setText(scope.getPath());
        this.myDirectory.addBrowseFolderListener("Select Path", "Select Path", this.myProject, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myRecursive.setSelected(scope.isRecursive());
    }

    private static ComboBoxModel createModel(Object[] elements) {
        return new DefaultComboBoxModel<Object>(new Vector<Object>(Arrays.asList(elements)));
    }

    private void createUIComponents() {
        this.myRoot = this;
        this.myCustomScopeSelection = new ScopeChooserCombo();
    }

    @Nullable
    private String getDirectoryName() {
        String s = this.myDirectory.getText();
        return s != null && s.length() > 0 ? s : null;
    }

    @Nullable
    private String getModuleName() {
        Module module = this.myModuleSelection.getSelectedModule();
        return module != null ? module.getName() : null;
    }

    @NotNull
    private SearchScope.ScopeType getScopeType() {
        if (this.myWholeProjectScope.isSelected()) {
            SearchScope.ScopeType scopeType = SearchScope.ScopeType.PROJECT;
            if (scopeType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/search/ScopePanel", "getScopeType"));
            }
            return scopeType;
        }
        if (this.myModuleScope.isSelected()) {
            SearchScope.ScopeType scopeType = SearchScope.ScopeType.MODULE;
            if (scopeType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/search/ScopePanel", "getScopeType"));
            }
            return scopeType;
        }
        if (this.myDirectoryScope.isSelected()) {
            SearchScope.ScopeType scopeType = SearchScope.ScopeType.DIRECTORY;
            if (scopeType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/search/ScopePanel", "getScopeType"));
            }
            return scopeType;
        }
        if (this.myCustomScope.isSelected()) {
            SearchScope.ScopeType scopeType = SearchScope.ScopeType.CUSTOM;
            if (scopeType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/search/ScopePanel", "getScopeType"));
            }
            return scopeType;
        }
        assert (false) : "Unknown Scope";
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/search/ScopePanel", "getScopeType"));
        }
        return null;
    }

    public SearchScope getSearchScope() {
        SearchScope scope = this.getSelectedScope();
        scope.setCustomScope(((ScopeChooserCombo)this.myCustomScopeSelection).getSelectedScope());
        return scope;
    }

    SearchScope getSelectedScope() {
        return new SearchScope(this.getScopeType(), this.getDirectoryName(), this.myRecursive.isSelected(), this.getModuleName(), ((ScopeChooserCombo)this.myCustomScopeSelection).getSelectedScopeName());
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myCustomScopeSelection);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JRadioButton jRadioButton;
        ModulesComboBox modulesComboBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        this.createUIComponents();
        JPanel jPanel = this.myRoot;
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), 2, 2, false, false));
        ((Component)jPanel2).setVisible(true);
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 1, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Scope", (int)0, (int)0, null, null));
        this.myWholeProjectScope = jRadioButton4 = new JRadioButton();
        jRadioButton4.setMargin(new Insets(0, 3, 0, 3));
        jRadioButton4.setText("Whole Project");
        jRadioButton4.setMnemonic('W');
        jRadioButton4.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDirectoryScope = jRadioButton3 = new JRadioButton();
        jRadioButton3.setMargin(new Insets(0, 3, 0, 3));
        jRadioButton3.setText("Directory:");
        jRadioButton3.setMnemonic('D');
        jRadioButton3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jRadioButton3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myModuleScope = jRadioButton2 = new JRadioButton();
        jRadioButton2.setVerticalTextPosition(0);
        jRadioButton2.setMargin(new Insets(0, 3, 0, 3));
        jRadioButton2.setText("Module:");
        jRadioButton2.setMnemonic('O');
        jRadioButton2.setDisplayedMnemonicIndex(1);
        jRadioButton2.setContentAreaFilled(true);
        jRadioButton2.setVerticalAlignment(0);
        ((Component)jRadioButton2).setVisible(true);
        jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDirectory = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myModuleSelection = modulesComboBox = new ModulesComboBox();
        jPanel2.add((Component)modulesComboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myCustomScope = jRadioButton = new JRadioButton();
        jRadioButton.setMargin(new Insets(0, 3, 0, 3));
        jRadioButton.setText("Custom:");
        jRadioButton.setMnemonic('C');
        jRadioButton.setDisplayedMnemonicIndex(0);
        ((Component)jRadioButton).setVisible(true);
        jPanel2.add((Component)jRadioButton, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.myCustomScopeSelection;
        comboboxWithBrowseButton.setVisible(true);
        jPanel2.add((Component)comboboxWithBrowseButton, new GridConstraints(4, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myRecursive = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(0, 3, 0, 3));
        jCheckBox.setText("Recursively");
        jCheckBox.setMnemonic('R');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null, 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }
}

