/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.code.ConstantsUtil;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.code.SimpleInstructionSequence;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.code.cfg.ControlFlowGraph;
import org.jetbrains.java.decompiler.code.cfg.ExceptionRangeCFG;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.code.DeadCodeHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.FlattenStatementsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.SSAConstructorSparseEx;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class FinallyProcessor {
    private final Map<Integer, Integer> finallyBlockIDs = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> catchallBlockIDs = new HashMap<Integer, Integer>();
    private final VarProcessor varprocessor;

    public FinallyProcessor(VarProcessor varprocessor) {
        this.varprocessor = varprocessor;
    }

    public boolean iterateGraph(StructMethod mt, RootStatement root, ControlFlowGraph graph) {
        return this.processStatementEx(mt, root, graph);
    }

    private boolean processStatementEx(StructMethod mt, RootStatement root, ControlFlowGraph graph) {
        int bytecode_version = mt.getClassStruct().getBytecodeVersion();
        LinkedList<RootStatement> stack = new LinkedList<RootStatement>();
        stack.add(root);
        while (!stack.isEmpty()) {
            Statement stat = (Statement)stack.removeLast();
            Statement parent = stat.getParent();
            if (parent != null && parent.type == 12 && stat == parent.getFirst() && !parent.isCopied()) {
                CatchAllStatement fin = (CatchAllStatement)parent;
                BasicBlock head = fin.getBasichead().getBlock();
                BasicBlock handler = fin.getHandler().getBasichead().getBlock();
                if (!this.catchallBlockIDs.containsKey(handler.id)) {
                    if (this.finallyBlockIDs.containsKey(handler.id)) {
                        fin.setFinally(true);
                        Integer var = this.finallyBlockIDs.get(handler.id);
                        fin.setMonitor(var == null ? null : new VarExprent(var, VarType.VARTYPE_INT, this.varprocessor));
                    } else {
                        Record inf = FinallyProcessor.getFinallyInformation(mt, root, fin);
                        if (inf == null) {
                            this.catchallBlockIDs.put(handler.id, null);
                        } else {
                            if (DecompilerContext.getOption("fdi") && this.verifyFinallyEx(graph, fin, inf)) {
                                this.finallyBlockIDs.put(handler.id, null);
                            } else {
                                int varindex = DecompilerContext.getCounterContainer().getCounterAndIncrement(2);
                                FinallyProcessor.insertSemaphore(graph, FinallyProcessor.getAllBasicBlocks(fin.getFirst()), head, handler, varindex, inf, bytecode_version);
                                this.finallyBlockIDs.put(handler.id, varindex);
                            }
                            DeadCodeHelper.removeDeadBlocks(graph);
                            DeadCodeHelper.removeEmptyBlocks(graph);
                            DeadCodeHelper.mergeBasicBlocks(graph);
                        }
                        return true;
                    }
                }
            }
            stack.addAll(stat.getStats());
        }
        return false;
    }

    private static Record getFinallyInformation(StructMethod mt, RootStatement root, CatchAllStatement fstat) {
        HashMap<BasicBlock, Boolean> mapLast = new HashMap<BasicBlock, Boolean>();
        BasicBlockStatement firstBlockStatement = fstat.getHandler().getBasichead();
        BasicBlock firstBasicBlock = firstBlockStatement.getBlock();
        Instruction instrFirst = firstBasicBlock.getInstruction(0);
        int firstcode = 0;
        switch (instrFirst.opcode) {
            case 87: {
                firstcode = 1;
                break;
            }
            case 58: {
                firstcode = 2;
            }
        }
        ExprProcessor proc = new ExprProcessor();
        proc.processStatement(root, mt.getClassStruct());
        SSAConstructorSparseEx ssa = new SSAConstructorSparseEx();
        ssa.splitVariables(root, mt);
        List<Exprent> lstExprents = firstBlockStatement.getExprents();
        VarVersionPair varpaar = new VarVersionPair((VarExprent)((AssignmentExprent)lstExprents.get(firstcode == 2 ? 1 : 0)).getLeft());
        FlattenStatementsHelper flatthelper = new FlattenStatementsHelper();
        DirectGraph dgraph = flatthelper.buildDirectGraph(root);
        LinkedList<DirectNode> stack = new LinkedList<DirectNode>();
        stack.add(dgraph.first);
        HashSet<DirectNode> setVisited = new HashSet<DirectNode>();
        while (!stack.isEmpty()) {
            DirectNode node = (DirectNode)stack.removeFirst();
            if (setVisited.contains(node)) continue;
            setVisited.add(node);
            BasicBlockStatement blockStatement = null;
            if (node.block != null) {
                blockStatement = node.block;
            } else if (node.preds.size() == 1) {
                blockStatement = node.preds.get((int)0).block;
            }
            boolean isTrueExit = true;
            if (firstcode != 1) {
                isTrueExit = false;
                for (int i = 0; i < node.exprents.size(); ++i) {
                    ExitExprent exexpr;
                    Exprent exprent = node.exprents.get(i);
                    if (firstcode == 0) {
                        ExitExprent exexpr2;
                        List<Exprent> lst = exprent.getAllExprents();
                        lst.add(exprent);
                        boolean found = false;
                        for (Exprent expr : lst) {
                            if (expr.type != 12 || !new VarVersionPair((VarExprent)expr).equals(varpaar)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        found = false;
                        if (exprent.type == 4 && (exexpr2 = (ExitExprent)exprent).getExitType() == 1 && exexpr2.getValue().type == 12) {
                            found = true;
                        }
                        if (!found) {
                            return null;
                        }
                        isTrueExit = true;
                        continue;
                    }
                    if (firstcode != 2 || exprent.type != 2) continue;
                    AssignmentExprent assexpr = (AssignmentExprent)exprent;
                    if (assexpr.getRight().type != 12 || !new VarVersionPair((VarExprent)assexpr.getRight()).equals(varpaar)) continue;
                    Exprent next = null;
                    if (i == node.exprents.size() - 1) {
                        if (node.succs.size() == 1) {
                            DirectNode nd = node.succs.get(0);
                            if (!nd.exprents.isEmpty()) {
                                next = nd.exprents.get(0);
                            }
                        }
                    } else {
                        next = node.exprents.get(i + 1);
                    }
                    boolean found = false;
                    if (next != null && next.type == 4 && (exexpr = (ExitExprent)next).getExitType() == 1 && exexpr.getValue().type == 12 && assexpr.getLeft().equals(exexpr.getValue())) {
                        found = true;
                    }
                    if (!found) {
                        return null;
                    }
                    isTrueExit = true;
                }
            }
            if (blockStatement != null && blockStatement.getBlock() != null) {
                Statement handler = fstat.getHandler();
                for (StatEdge edge : blockStatement.getSuccessorEdges(0x40000000)) {
                    Boolean existingFlag;
                    if (edge.getType() == 1 || !handler.containsStatement(blockStatement) || handler.containsStatement(edge.getDestination()) || (existingFlag = (Boolean)mapLast.get(blockStatement.getBlock())) != null && existingFlag.booleanValue()) continue;
                    mapLast.put(blockStatement.getBlock(), isTrueExit);
                    break;
                }
            }
            stack.addAll(node.succs);
        }
        if (fstat.getHandler().type == 8) {
            boolean isEmpty = false;
            boolean isFirstLast = mapLast.containsKey(firstBasicBlock);
            InstructionSequence seq = firstBasicBlock.getSeq();
            switch (firstcode) {
                case 0: {
                    isEmpty = isFirstLast && seq.length() == 1;
                    break;
                }
                case 1: {
                    isEmpty = seq.length() == 1;
                    break;
                }
                case 2: {
                    boolean bl;
                    if (isFirstLast) {
                        if (seq.length() == 3) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    bl = isEmpty = seq.length() == 1;
                }
            }
            if (isEmpty) {
                firstcode = 3;
            }
        }
        return new Record(firstcode, mapLast);
    }

    private static void insertSemaphore(ControlFlowGraph graph, Set<BasicBlock> setTry, BasicBlock head, BasicBlock handler, int var, Record information, int bytecode_version) {
        HashSet<BasicBlock> setCopy = new HashSet<BasicBlock>(setTry);
        int finallytype = information.firstCode;
        Map mapLast = information.mapLast;
        FinallyProcessor.removeExceptionInstructionsEx(handler, 1, finallytype);
        for (Map.Entry entry : mapLast.entrySet()) {
            BasicBlock last = (BasicBlock)entry.getKey();
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            FinallyProcessor.removeExceptionInstructionsEx(last, 2, finallytype);
            graph.getFinallyExits().add(last);
        }
        for (BasicBlock block : setTry) {
            List<BasicBlock> lstSucc = block.getSuccs();
            for (BasicBlock dest : lstSucc) {
                if (setCopy.contains(dest) || dest == graph.getLast()) continue;
                SimpleInstructionSequence seq = new SimpleInstructionSequence();
                seq.addInstruction(ConstantsUtil.getInstructionInstance(16, false, 1, bytecode_version, new int[]{0}), -1);
                seq.addInstruction(ConstantsUtil.getInstructionInstance(54, false, 1, bytecode_version, new int[]{var}), -1);
                BasicBlock newblock = new BasicBlock(++graph.last_id);
                newblock.setSeq(seq);
                block.replaceSuccessor(dest, newblock);
                newblock.addSuccessor(dest);
                setCopy.add(newblock);
                graph.getBlocks().addWithKey(newblock, newblock.id);
                for (int j = 0; j < block.getSuccExceptions().size(); ++j) {
                    BasicBlock hd = block.getSuccExceptions().get(j);
                    newblock.addSuccessorException(hd);
                    ExceptionRangeCFG range = graph.getExceptionRange(hd, block);
                    range.getProtectedRange().add(newblock);
                }
            }
        }
        SimpleInstructionSequence seq = new SimpleInstructionSequence();
        seq.addInstruction(ConstantsUtil.getInstructionInstance(16, false, 1, bytecode_version, new int[]{1}), -1);
        seq.addInstruction(ConstantsUtil.getInstructionInstance(54, false, 1, bytecode_version, new int[]{var}), -1);
        BasicBlock newhead = new BasicBlock(++graph.last_id);
        newhead.setSeq(seq);
        FinallyProcessor.insertBlockBefore(graph, head, newhead);
        seq = new SimpleInstructionSequence();
        seq.addInstruction(ConstantsUtil.getInstructionInstance(16, false, 1, bytecode_version, new int[]{0}), -1);
        seq.addInstruction(ConstantsUtil.getInstructionInstance(54, false, 1, bytecode_version, new int[]{var}), -1);
        BasicBlock newheadinit = new BasicBlock(++graph.last_id);
        newheadinit.setSeq(seq);
        FinallyProcessor.insertBlockBefore(graph, newhead, newheadinit);
        setCopy.add(newhead);
        setCopy.add(newheadinit);
        for (BasicBlock hd : new HashSet<BasicBlock>(newheadinit.getSuccExceptions())) {
            ExceptionRangeCFG range = graph.getExceptionRange(hd, newheadinit);
            if (!setCopy.containsAll(range.getProtectedRange())) continue;
            newheadinit.removeSuccessorException(hd);
            range.getProtectedRange().remove(newheadinit);
        }
    }

    private static void insertBlockBefore(ControlFlowGraph graph, BasicBlock oldblock, BasicBlock newblock) {
        ArrayList<BasicBlock> lstTemp = new ArrayList<BasicBlock>();
        lstTemp.addAll(oldblock.getPreds());
        lstTemp.addAll(oldblock.getPredExceptions());
        for (BasicBlock pred : lstTemp) {
            pred.replaceSuccessor(oldblock, newblock);
        }
        for (BasicBlock hd : oldblock.getSuccExceptions()) {
            newblock.addSuccessorException(hd);
            ExceptionRangeCFG range = graph.getExceptionRange(hd, oldblock);
            range.getProtectedRange().add(newblock);
        }
        for (ExceptionRangeCFG range : graph.getExceptions()) {
            if (range.getHandler() != oldblock) continue;
            range.setHandler(newblock);
        }
        newblock.addSuccessor(oldblock);
        graph.getBlocks().addWithKey(newblock, newblock.id);
        if (graph.getFirst() == oldblock) {
            graph.setFirst(newblock);
        }
    }

    private static HashSet<BasicBlock> getAllBasicBlocks(Statement stat) {
        LinkedList<Statement> lst = new LinkedList<Statement>();
        lst.add(stat);
        int index = 0;
        do {
            Statement st = (Statement)lst.get(index);
            if (st.type == 8) {
                ++index;
                continue;
            }
            lst.addAll(st.getStats());
            lst.remove(index);
        } while (index < lst.size());
        HashSet<BasicBlock> res = new HashSet<BasicBlock>();
        for (Statement st : lst) {
            res.add(((BasicBlockStatement)st).getBlock());
        }
        return res;
    }

    private boolean verifyFinallyEx(ControlFlowGraph graph, CatchAllStatement fstat, Record information) {
        BasicBlock firstsuc;
        HashSet<BasicBlock> tryBlocks = FinallyProcessor.getAllBasicBlocks(fstat.getFirst());
        HashSet<BasicBlock> catchBlocks = FinallyProcessor.getAllBasicBlocks(fstat.getHandler());
        int finallytype = information.firstCode;
        Map mapLast = information.mapLast;
        BasicBlock first = fstat.getHandler().getBasichead().getBlock();
        boolean skippedFirst = false;
        if (finallytype == 3) {
            FinallyProcessor.removeExceptionInstructionsEx(first, 3, finallytype);
            if (mapLast.containsKey(first)) {
                graph.getFinallyExits().add(first);
            }
            return true;
        }
        if (first.getSeq().length() == 1 && finallytype > 0 && catchBlocks.contains(firstsuc = first.getSuccs().get(0))) {
            first = firstsuc;
            skippedFirst = true;
        }
        HashSet<BasicBlock> startBlocks = new HashSet<BasicBlock>();
        for (BasicBlock block : tryBlocks) {
            startBlocks.addAll(block.getSuccs());
        }
        startBlocks.remove(graph.getLast());
        startBlocks.removeAll(tryBlocks);
        ArrayList<Area> lstAreas = new ArrayList<Area>();
        for (BasicBlock basicBlock : startBlocks) {
            Area arr = this.compareSubgraphsEx(graph, basicBlock, catchBlocks, first, finallytype, mapLast, skippedFirst);
            if (arr == null) {
                return false;
            }
            lstAreas.add(arr);
        }
        for (Area area : lstAreas) {
            FinallyProcessor.deleteArea(graph, area);
        }
        for (Map.Entry entry : mapLast.entrySet()) {
            BasicBlock last = (BasicBlock)entry.getKey();
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            FinallyProcessor.removeExceptionInstructionsEx(last, 2, finallytype);
            graph.getFinallyExits().add(last);
        }
        FinallyProcessor.removeExceptionInstructionsEx(fstat.getHandler().getBasichead().getBlock(), 1, finallytype);
        return true;
    }

    private Area compareSubgraphsEx(ControlFlowGraph graph, BasicBlock startSample, HashSet<BasicBlock> catchBlocks, BasicBlock startCatch, int finallytype, Map<BasicBlock, Boolean> mapLast, boolean skippedFirst) {
        LinkedList<BlockStackEntry> stack = new LinkedList<BlockStackEntry>();
        HashSet<BasicBlock> setSample = new HashSet<BasicBlock>();
        HashMap<String, BasicBlock[]> mapNext = new HashMap<String, BasicBlock[]>();
        class BlockStackEntry {
            public BasicBlock blockCatch;
            public BasicBlock blockSample;
            public List<int[]> lstStoreVars;

            public BlockStackEntry(BasicBlock blockCatch, BasicBlock blockSample, List<int[]> lstStoreVars) {
                this.blockCatch = blockCatch;
                this.blockSample = blockSample;
                this.lstStoreVars = new ArrayList<int[]>(lstStoreVars);
            }
        }
        stack.add(new BlockStackEntry(startCatch, startSample, new ArrayList<int[]>()));
        while (!stack.isEmpty()) {
            BasicBlock sucSample;
            BasicBlock sucCatch;
            int i;
            boolean isLastBlock;
            boolean isTrueLastBlock;
            BlockStackEntry entry = (BlockStackEntry)stack.remove(0);
            BasicBlock blockCatch = entry.blockCatch;
            BasicBlock blockSample = entry.blockSample;
            boolean isFirstBlock = !skippedFirst && blockCatch == startCatch;
            if (!this.compareBasicBlocksEx(graph, blockCatch, blockSample, (isFirstBlock ? 1 : 0) | ((isTrueLastBlock = (isLastBlock = mapLast.containsKey(blockCatch)) && mapLast.get(blockCatch) != false) ? 2 : 0), finallytype, entry.lstStoreVars)) {
                return null;
            }
            if (blockSample.getSuccs().size() != blockCatch.getSuccs().size()) {
                return null;
            }
            setSample.add(blockSample);
            for (i = 0; i < blockCatch.getSuccs().size(); ++i) {
                sucCatch = blockCatch.getSuccs().get(i);
                sucSample = blockSample.getSuccs().get(i);
                if (!catchBlocks.contains(sucCatch) || setSample.contains(sucSample)) continue;
                stack.add(new BlockStackEntry(sucCatch, sucSample, entry.lstStoreVars));
            }
            if (!isLastBlock || !blockSample.getSeq().isEmpty()) {
                if (blockCatch.getSuccExceptions().size() == blockSample.getSuccExceptions().size()) {
                    for (i = 0; i < blockCatch.getSuccExceptions().size(); ++i) {
                        boolean equalexc;
                        sucCatch = blockCatch.getSuccExceptions().get(i);
                        sucSample = blockSample.getSuccExceptions().get(i);
                        String excCatch = graph.getExceptionRange(sucCatch, blockCatch).getUniqueExceptionsString();
                        String excSample = graph.getExceptionRange(sucSample, blockSample).getUniqueExceptionsString();
                        boolean bl = excCatch == null ? excSample == null : (equalexc = excCatch.equals(excSample));
                        if (equalexc) {
                            if (!catchBlocks.contains(sucCatch) || setSample.contains(sucSample)) continue;
                            List<int[]> lst = entry.lstStoreVars;
                            if (sucCatch.getSeq().length() > 0 && sucSample.getSeq().length() > 0) {
                                Instruction instrCatch = sucCatch.getSeq().getInstr(0);
                                Instruction instrSample = sucSample.getSeq().getInstr(0);
                                if (instrCatch.opcode == 58 && instrSample.opcode == 58) {
                                    lst = new ArrayList<int[]>(lst);
                                    lst.add(new int[]{instrCatch.getOperand(0), instrSample.getOperand(0)});
                                }
                            }
                            stack.add(new BlockStackEntry(sucCatch, sucSample, lst));
                            continue;
                        }
                        return null;
                    }
                } else {
                    return null;
                }
            }
            if (!isLastBlock) continue;
            HashSet<BasicBlock> setSuccs = new HashSet<BasicBlock>(blockSample.getSuccs());
            setSuccs.removeAll(setSample);
            for (BlockStackEntry stackent : stack) {
                setSuccs.remove(stackent.blockSample);
            }
            for (BasicBlock succ : setSuccs) {
                if (graph.getLast() == succ) continue;
                mapNext.put(blockSample.id + "#" + succ.id, new BasicBlock[]{blockSample, succ, isTrueLastBlock ? succ : null});
            }
        }
        return new Area(startSample, setSample, FinallyProcessor.getUniqueNext(graph, new HashSet<BasicBlock[]>(mapNext.values())));
    }

    private static BasicBlock getUniqueNext(ControlFlowGraph graph, Set<BasicBlock[]> setNext) {
        BasicBlock next = null;
        boolean multiple = false;
        for (BasicBlock[] arr : setNext) {
            if (arr[2] != null) {
                next = arr[1];
                multiple = false;
                break;
            }
            if (next == null) {
                next = arr[1];
            } else if (next != arr[1]) {
                multiple = true;
            }
            if (arr[1].getPreds().size() != 1) continue;
            next = arr[1];
        }
        if (multiple) {
            for (BasicBlock[] arr : setNext) {
                BasicBlock block = arr[1];
                if (block == next) continue;
                if (InterpreterUtil.equalSets(next.getSuccs(), block.getSuccs())) {
                    InstructionSequence seqNext = next.getSeq();
                    InstructionSequence seqBlock = block.getSeq();
                    if (seqNext.length() == seqBlock.length()) {
                        for (int i = 0; i < seqNext.length(); ++i) {
                            Instruction instrNext = seqNext.getInstr(i);
                            Instruction instrBlock = seqBlock.getInstr(i);
                            if (instrNext.opcode != instrBlock.opcode || instrNext.wide != instrBlock.wide || instrNext.operandsCount() != instrBlock.operandsCount()) {
                                return null;
                            }
                            for (int j = 0; j < instrNext.getOperands().length; ++j) {
                                if (instrNext.getOperand(j) == instrBlock.getOperand(j)) continue;
                                return null;
                            }
                        }
                        continue;
                    }
                    return null;
                }
                return null;
            }
            for (BasicBlock[] arr : setNext) {
                if (arr[1] == next) continue;
                arr[0].removeSuccessor(arr[1]);
                arr[0].addSuccessor(next);
            }
            DeadCodeHelper.removeDeadBlocks(graph);
        }
        return next;
    }

    private boolean compareBasicBlocksEx(ControlFlowGraph graph, BasicBlock pattern, BasicBlock sample, int type, int finallytype, List<int[]> lstStoreVars) {
        InstructionSequence seqPattern = pattern.getSeq();
        InstructionSequence seqSample = sample.getSeq();
        if (type != 0) {
            seqPattern = seqPattern.clone();
            if ((type & 1) > 0 && finallytype > 0) {
                seqPattern.removeInstruction(0);
            }
            if ((type & 2) > 0) {
                if (finallytype == 0 || finallytype == 2) {
                    seqPattern.removeLast();
                }
                if (finallytype == 2) {
                    seqPattern.removeLast();
                }
            }
        }
        if (seqPattern.length() > seqSample.length()) {
            return false;
        }
        for (int i = 0; i < seqPattern.length(); ++i) {
            Instruction instrSample;
            Instruction instrPattern = seqPattern.getInstr(i);
            if (this.equalInstructions(instrPattern, instrSample = seqSample.getInstr(i), lstStoreVars)) continue;
            return false;
        }
        if (seqPattern.length() < seqSample.length()) {
            SimpleInstructionSequence seq = new SimpleInstructionSequence();
            LinkedList<Integer> oldOffsets = new LinkedList<Integer>();
            for (int i = seqSample.length() - 1; i >= seqPattern.length(); --i) {
                seq.addInstruction(0, seqSample.getInstr(i), -1);
                oldOffsets.addFirst(sample.getOldOffset(i));
                seqSample.removeInstruction(i);
            }
            BasicBlock newblock = new BasicBlock(++graph.last_id);
            newblock.setSeq(seq);
            newblock.getInstrOldOffsets().addAll(oldOffsets);
            ArrayList<BasicBlock> lstTemp = new ArrayList<BasicBlock>();
            lstTemp.addAll(sample.getSuccs());
            for (BasicBlock suc : lstTemp) {
                sample.removeSuccessor(suc);
                newblock.addSuccessor(suc);
            }
            sample.addSuccessor(newblock);
            graph.getBlocks().addWithKey(newblock, newblock.id);
            Set<BasicBlock> setFinallyExits = graph.getFinallyExits();
            if (setFinallyExits.contains(sample)) {
                setFinallyExits.remove(sample);
                setFinallyExits.add(newblock);
            }
            for (int j = 0; j < sample.getSuccExceptions().size(); ++j) {
                BasicBlock hd = sample.getSuccExceptions().get(j);
                newblock.addSuccessorException(hd);
                ExceptionRangeCFG range = graph.getExceptionRange(hd, sample);
                range.getProtectedRange().add(newblock);
            }
        }
        return true;
    }

    public boolean equalInstructions(Instruction first, Instruction second, List<int[]> lstStoreVars) {
        if (first.opcode != second.opcode || first.wide != second.wide || first.operandsCount() != second.operandsCount()) {
            return false;
        }
        if (first.group != 2 && first.getOperands() != null) {
            for (int i = 0; i < first.getOperands().length; ++i) {
                int secondOp;
                int firstOp = first.getOperand(i);
                if (firstOp == (secondOp = second.getOperand(i))) continue;
                if (first.opcode == 25 || first.opcode == 58) {
                    for (int[] arr : lstStoreVars) {
                        if (arr[0] != firstOp || arr[1] != secondOp) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return true;
    }

    private static void deleteArea(ControlFlowGraph graph, Area area) {
        BasicBlock next;
        BasicBlock start = area.start;
        if (start == (next = area.next)) {
            return;
        }
        if (next == null) {
            next = graph.getLast();
        }
        HashSet<BasicBlock> setCommonExceptionHandlers = new HashSet<BasicBlock>(next.getSuccExceptions());
        for (BasicBlock pred : start.getPreds()) {
            setCommonExceptionHandlers.retainAll(pred.getSuccExceptions());
        }
        boolean is_outside_range = false;
        HashSet<BasicBlock> setPredecessors = new HashSet<BasicBlock>(start.getPreds());
        for (BasicBlock pred : setPredecessors) {
            pred.replaceSuccessor(start, next);
        }
        Set setBlocks = area.sample;
        HashSet<ExceptionRangeCFG> setCommonRemovedExceptionRanges = null;
        for (BasicBlock block : setBlocks) {
            if (!graph.getBlocks().containsKey(block.id)) continue;
            if (!block.getSuccExceptions().containsAll(setCommonExceptionHandlers)) {
                is_outside_range = true;
            }
            HashSet<ExceptionRangeCFG> setRemovedExceptionRanges = new HashSet<ExceptionRangeCFG>();
            for (BasicBlock handler : block.getSuccExceptions()) {
                setRemovedExceptionRanges.add(graph.getExceptionRange(handler, block));
            }
            if (setCommonRemovedExceptionRanges == null) {
                setCommonRemovedExceptionRanges = setRemovedExceptionRanges;
            } else {
                setCommonRemovedExceptionRanges.retainAll(setRemovedExceptionRanges);
            }
            if (block.getSeq().isEmpty() && block.getSuccs().size() == 1) {
                BasicBlock succs = block.getSuccs().get(0);
                for (BasicBlock pred : new ArrayList<BasicBlock>(block.getPreds())) {
                    if (setBlocks.contains(pred)) continue;
                    pred.replaceSuccessor(block, succs);
                }
                if (graph.getFirst() == block) {
                    graph.setFirst(succs);
                }
            }
            graph.removeBlock(block);
        }
        if (is_outside_range) {
            BasicBlock emptyblock = new BasicBlock(++graph.last_id);
            graph.getBlocks().addWithKey(emptyblock, emptyblock.id);
            if (setCommonRemovedExceptionRanges != null) {
                for (ExceptionRangeCFG range : setCommonRemovedExceptionRanges) {
                    emptyblock.addSuccessorException(range.getHandler());
                    range.getProtectedRange().add(emptyblock);
                }
            }
            emptyblock.addSuccessor(next);
            for (BasicBlock pred : setPredecessors) {
                pred.replaceSuccessor(next, emptyblock);
            }
        }
    }

    private static void removeExceptionInstructionsEx(BasicBlock block, int blocktype, int finallytype) {
        InstructionSequence seq = block.getSeq();
        if (finallytype == 3) {
            for (int i = seq.length() - 1; i >= 0; --i) {
                seq.removeInstruction(i);
            }
        } else {
            if ((blocktype & 1) > 0 && (finallytype == 2 || finallytype == 1)) {
                seq.removeInstruction(0);
            }
            if ((blocktype & 2) > 0) {
                if (finallytype == 2 || finallytype == 0) {
                    seq.removeLast();
                }
                if (finallytype == 2) {
                    seq.removeLast();
                }
            }
        }
    }

    private static class Area {
        private final BasicBlock start;
        private final Set<BasicBlock> sample;
        private final BasicBlock next;

        private Area(BasicBlock start, Set<BasicBlock> sample, BasicBlock next) {
            this.start = start;
            this.sample = sample;
            this.next = next;
        }
    }

    private static class Record {
        private final int firstCode;
        private final Map<BasicBlock, Boolean> mapLast;

        private Record(int firstCode, Map<BasicBlock, Boolean> mapLast) {
            this.firstCode = firstCode;
            this.mapLast = mapLast;
        }
    }
}

