/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessageParser;
import com.android.tools.idea.logcat.AndroidConsoleWriter;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.StackTraceExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.android.util.AndroidOutputReceiver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidLogcatReceiver
extends AndroidOutputReceiver
implements Disposable {
    private final LogCatMessageParser myParser;
    private static final String STACK_TRACE_LINE_PREFIX = StringUtil.repeatSymbol((char)' ', (int)4);
    private static final String STACK_TRACE_CAUSE_LINE_PREFIX = Character.toString(' ');
    private volatile boolean myCanceled;
    private final AndroidConsoleWriter myWriter;
    private final IDevice myDevice;
    private final StackTraceExpander myStackTraceExpander;
    @Nullable
    private LogCatHeader myActiveHeader;
    private int myLineIndex;

    public AndroidLogcatReceiver(@NotNull IDevice device, @NotNull AndroidConsoleWriter writer) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/logcat/AndroidLogcatReceiver", "<init>"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/android/tools/idea/logcat/AndroidLogcatReceiver", "<init>"));
        }
        this.myParser = new LogCatMessageParser();
        this.myCanceled = false;
        this.myDevice = device;
        this.myWriter = writer;
        this.myStackTraceExpander = new StackTraceExpander(STACK_TRACE_LINE_PREFIX, STACK_TRACE_CAUSE_LINE_PREFIX);
    }

    @Override
    public void processNewLine(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/AndroidLogcatReceiver", "processNewLine"));
        }
        if (line.isEmpty()) {
            this.myStackTraceExpander.reset();
            this.myActiveHeader = null;
            return;
        }
        LogCatHeader header = this.myParser.processLogHeader(line, this.myDevice);
        if (header != null) {
            this.myActiveHeader = header;
            this.myLineIndex = 0;
        } else if (this.myActiveHeader != null) {
            this.myStackTraceExpander.process(line);
            for (String processedLine : this.myStackTraceExpander.getProcessedLines()) {
                processedLine = this.myLineIndex == 0 ? AndroidLogcatFormatter.formatMessageFull(this.myActiveHeader, processedLine) : AndroidLogcatFormatter.formatContinuation(processedLine);
                this.myWriter.addMessage(processedLine);
                ++this.myLineIndex;
            }
        }
    }

    public boolean isCancelled() {
        return this.myCanceled;
    }

    public void dispose() {
        this.cancel();
    }

    public void cancel() {
        this.myCanceled = true;
    }
}

