/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtTypeElement;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0012\u0013B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveNullableFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNullableType;", "element", "typeOfError", "Lorg/jetbrains/kotlin/idea/quickfix/RemoveNullableFix$NullableKind;", "(Lorg/jetbrains/kotlin/psi/KtNullableType;Lorg/jetbrains/kotlin/idea/quickfix/RemoveNullableFix$NullableKind;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Factory", "NullableKind", "idea"})
public final class RemoveNullableFix
extends KotlinQuickFixAction<KtNullableType> {
    private final NullableKind typeOfError;

    @NotNull
    public String getFamilyName() {
        return "Remove '?'";
    }

    @NotNull
    public String getText() {
        return this.typeOfError.getMessage();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KtTypeElement ktTypeElement = ((KtNullableType)this.getElement()).getInnerType();
        if (ktTypeElement == null) {
            void message$iv;
            String string = "No inner type " + ((KtNullableType)this.getElement()).getText() + ", should have been rejected in createFactory()";
            throw (Throwable)new IllegalStateException(message$iv.toString());
        }
        KtTypeElement type2 = ktTypeElement;
        ((KtNullableType)this.getElement()).replace((PsiElement)type2);
    }

    public RemoveNullableFix(@NotNull KtNullableType element2, @NotNull NullableKind typeOfError) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)((Object)typeOfError), (String)"typeOfError");
        super((PsiElement)element2);
        this.typeOfError = typeOfError;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveNullableFix$NullableKind;", "", "message", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "REDUNDANT", "SUPERTYPE", "USELESS", "idea"})
    public static final class NullableKind
    extends Enum<NullableKind> {
        public static final /* enum */ NullableKind REDUNDANT;
        public static final /* enum */ NullableKind SUPERTYPE;
        public static final /* enum */ NullableKind USELESS;
        private static final /* synthetic */ NullableKind[] $VALUES;
        @NotNull
        private final String message;

        static {
            NullableKind[] nullableKindArray = new NullableKind[3];
            NullableKind[] nullableKindArray2 = nullableKindArray;
            nullableKindArray[0] = REDUNDANT = new NullableKind("Remove redundant '?'");
            nullableKindArray[1] = SUPERTYPE = new NullableKind("Remove '?'");
            nullableKindArray[2] = USELESS = new NullableKind("Remove useless '?'");
            $VALUES = nullableKindArray;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        protected NullableKind(String message2) {
            Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
            this.message = message2;
        }

        public static NullableKind[] values() {
            return (NullableKind[])$VALUES.clone();
        }

        public static NullableKind valueOf(String string) {
            return Enum.valueOf(NullableKind.class, string);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveNullableFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "typeOfError", "Lorg/jetbrains/kotlin/idea/quickfix/RemoveNullableFix$NullableKind;", "(Lorg/jetbrains/kotlin/idea/quickfix/RemoveNullableFix$NullableKind;)V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNullableType;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Factory
    extends KotlinSingleIntentionActionFactory {
        private final NullableKind typeOfError;

        @Override
        @Nullable
        protected KotlinQuickFixAction<KtNullableType> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement $receiver$iv = diagnostic.getPsiElement();
            KtNullableType nullType = (KtNullableType)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtNullableType.class, (boolean)false);
            if (nullType == null || nullType.getInnerType() == null) {
                return null;
            }
            return new RemoveNullableFix(nullType, this.typeOfError);
        }

        public Factory(@NotNull NullableKind typeOfError) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)typeOfError), (String)"typeOfError");
            this.typeOfError = typeOfError;
        }
    }
}

