/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.ScalableIcon;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class SizedIcon
implements Icon,
ScalableIcon {
    private final int myWidth;
    private final int myHeight;
    private final Icon myDelegate;
    private Icon myScaledDelegate;
    private float myScale = 1.0f;

    public SizedIcon(Icon delegate, int width, int height) {
        this.myDelegate = delegate;
        this.myWidth = width;
        this.myHeight = height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        x = this.scale(x);
        y = this.scale(y);
        int dx = this.scale(this.myWidth) - this.scale(this.myDelegate.getIconWidth());
        int dy = this.scale(this.myHeight) - this.scale(this.myDelegate.getIconHeight());
        if (dx > 0 || dy > 0) {
            this.myDelegate.paintIcon(c, g, x + dx / 2, y + dy / 2);
        } else {
            this.myDelegate.paintIcon(c, g, x, y);
        }
    }

    private int scale(int n) {
        return this.myScale == 1.0f ? n : (int)((float)n * this.myScale);
    }

    @Override
    public int getIconWidth() {
        if (this.myDelegate instanceof ScalableIcon) {
            return this.myDelegate.getIconWidth();
        }
        return this.myWidth;
    }

    @Override
    public int getIconHeight() {
        if (this.myDelegate instanceof ScalableIcon) {
            return this.myDelegate.getIconHeight();
        }
        return this.myHeight;
    }

    public Icon scale(float scaleFactor) {
        if (scaleFactor == 1.0f) {
            this.myScaledDelegate = null;
        } else if (this.myDelegate instanceof ScalableIcon) {
            this.myScaledDelegate = ((ScalableIcon)this.myDelegate).scale(scaleFactor);
        }
        return this;
    }
}

