/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.module.impl.ModuleImpl;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.IdeaTestCase;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleTestCase
extends IdeaTestCase {
    protected final Collection<Module> myModulesToDispose = new ArrayList<Module>();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myModulesToDispose.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            ModuleManager moduleManager = ModuleManager.getInstance(this.myProject);
            List errors = null;
            AccessToken token = WriteAction.start();
            try {
                for (Module module : this.myModulesToDispose) {
                    try {
                        String moduleName = module.getName();
                        if (moduleManager.findModuleByName(moduleName) == null) continue;
                        moduleManager.disposeModule(module);
                    }
                    catch (Throwable e) {
                        if (errors == null) {
                            errors = new SmartList();
                        }
                        errors.add(e);
                    }
                }
            }
            finally {
                token.finish();
            }
            CompoundRuntimeException.throwIfNotEmpty(errors);
        }
        finally {
            this.myModulesToDispose.clear();
            super.tearDown();
        }
    }

    protected Module createModule(File moduleFile) {
        return this.createModule(moduleFile, StdModuleTypes.JAVA);
    }

    protected Module createModule(File moduleFile, ModuleType moduleType) {
        String path2 = moduleFile.getAbsolutePath();
        return this.createModule(path2, moduleType);
    }

    protected Module createModule(final String path2, final ModuleType moduleType) {
        Module module = ApplicationManager.getApplication().runWriteAction(new Computable<Module>(){

            public Module compute() {
                return ModuleManager.getInstance(ModuleTestCase.this.myProject).newModule(path2, moduleType.getId());
            }
        });
        this.myModulesToDispose.add(module);
        return module;
    }

    protected Module loadModule(@NotNull String modulePath) {
        Module module;
        if (modulePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePath", "com/intellij/testFramework/ModuleTestCase", "loadModule"));
        }
        final String normalizedPath = FileUtil.toSystemIndependentName((String)modulePath);
        LocalFileSystem.getInstance().refreshAndFindFileByPath(normalizedPath);
        final ModuleManager moduleManager = ModuleManager.getInstance(this.myProject);
        try {
            module = ApplicationManager.getApplication().runWriteAction(new ThrowableComputable<Module, Exception>(){

                public Module compute() throws Exception {
                    return moduleManager.loadModule(normalizedPath);
                }
            });
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
        this.myModulesToDispose.add(module);
        return module;
    }

    @Nullable
    protected Module loadAllModulesUnder(@NotNull VirtualFile rootDir) {
        if (rootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDir", "com/intellij/testFramework/ModuleTestCase", "loadAllModulesUnder"));
        }
        return this.loadAllModulesUnder(rootDir, null);
    }

    @Nullable
    protected Module loadAllModulesUnder(@NotNull VirtualFile rootDir, final @Nullable Consumer<Module> moduleConsumer) {
        if (rootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDir", "com/intellij/testFramework/ModuleTestCase", "loadAllModulesUnder"));
        }
        final Ref result = Ref.create();
        VfsUtilCore.visitChildrenRecursively(rootDir, new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @Override
            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/ModuleTestCase$3", "visitFile"));
                }
                if (!file.isDirectory() && file.getName().endsWith(".iml")) {
                    ModuleImpl module = (ModuleImpl)ModuleTestCase.this.loadModule(file.getPath());
                    if (moduleConsumer != null) {
                        moduleConsumer.consume((Object)module);
                    }
                    result.setIfNull((Object)module);
                }
                return true;
            }
        });
        return (Module)result.get();
    }

    protected Module createModuleFromTestData(String dirInTestData, String newModuleFileName, ModuleType moduleType, boolean addSourceRoot) throws IOException {
        File dirInTestDataFile = new File(dirInTestData);
        ModuleTestCase.assertTrue((boolean)dirInTestDataFile.isDirectory());
        File moduleDir = this.createTempDirectory();
        FileUtil.copyDir((File)dirInTestDataFile, (File)moduleDir);
        Module module = this.createModule(moduleDir + "/" + newModuleFileName, moduleType);
        final VirtualFile root = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(moduleDir);
        ModuleTestCase.assertNotNull((Object)root);
        new WriteCommandAction.Simple(module.getProject(), new PsiFile[0]){

            @Override
            protected void run() throws Throwable {
                root.refresh(false, true);
            }
        }.execute().throwException();
        if (addSourceRoot) {
            PsiTestUtil.addSourceContentToRoots((Module)module, (VirtualFile)root);
        } else {
            PsiTestUtil.addContentRoot((Module)module, (VirtualFile)root);
        }
        return module;
    }
}

