/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.AccessorResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GrScopeProcessorWithHints;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;
import org.jetbrains.plugins.groovy.lang.resolve.processors.SubstitutorComputer;

public abstract class GroovyResolverProcessor
implements PsiScopeProcessor,
ElementClassHint,
NameHint {
    @NotNull
    protected final GrReferenceExpression myRef;
    @NotNull
    private final String myName;
    @NotNull
    protected final EnumSet<GroovyResolveKind> myAcceptableKinds;
    private final boolean myIsLValue;
    @Nullable
    protected final PsiType myThisType;
    @NotNull
    protected final PsiType[] myTypeArguments;
    @Nullable
    private final PsiType[] myArgumentTypesNonErased;
    @Nullable
    protected final PsiType[] myArgumentTypes;
    private final NotNullLazyValue<SubstitutorComputer> myPropertySubstitutorComputer;
    private final NotNullLazyValue<SubstitutorComputer> myMethodSubstitutorComputer;
    private final List<PsiScopeProcessor> myAccessorProcessors;
    protected final MultiMap<GroovyResolveKind, GroovyResolveResult> myCandidates;
    protected final MultiMap<GroovyResolveKind, GroovyResolveResult> myInapplicableCandidates;
    private boolean myStopExecutingMethods;

    GroovyResolverProcessor(@NotNull GrReferenceExpression ref, @NotNull EnumSet<GroovyResolveKind> kinds, @Nullable GrExpression myUpToArgument) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor", "<init>"));
        }
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor", "<init>"));
        }
        this.myPropertySubstitutorComputer = new NotNullLazyValue<SubstitutorComputer>(){

            @NotNull
            protected SubstitutorComputer compute() {
                SubstitutorComputer substitutorComputer = new SubstitutorComputer(GroovyResolverProcessor.this.myThisType, PsiType.EMPTY_ARRAY, GroovyResolverProcessor.this.myTypeArguments, GroovyResolverProcessor.this.myRef, GroovyResolverProcessor.this.myRef);
                if (substitutorComputer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor$1", "compute"));
                }
                return substitutorComputer;
            }
        };
        this.myMethodSubstitutorComputer = new NotNullLazyValue<SubstitutorComputer>(){

            @NotNull
            protected SubstitutorComputer compute() {
                SubstitutorComputer substitutorComputer = new SubstitutorComputer(GroovyResolverProcessor.this.myThisType, GroovyResolverProcessor.this.myArgumentTypesNonErased, GroovyResolverProcessor.this.myTypeArguments, GroovyResolverProcessor.this.myRef, GroovyResolverProcessor.this.myRef.getParent());
                if (substitutorComputer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor$2", "compute"));
                }
                return substitutorComputer;
            }
        };
        this.myCandidates = MultiMap.create();
        this.myInapplicableCandidates = MultiMap.create();
        this.myStopExecutingMethods = false;
        this.myRef = ref;
        this.myAcceptableKinds = kinds;
        this.myName = GroovyResolverProcessor.getReferenceName(ref);
        this.myIsLValue = PsiUtil.isLValue(this.myRef);
        this.myThisType = PsiImplUtil.getQualifierType(ref);
        this.myTypeArguments = ref.getTypeArguments();
        if (kinds.contains((Object)GroovyResolveKind.METHOD)) {
            this.myArgumentTypesNonErased = PsiUtil.getArgumentTypes(ref, false, myUpToArgument, false);
            this.myArgumentTypes = GroovyResolverProcessor.eraseTypes(this.myArgumentTypesNonErased);
        } else {
            this.myArgumentTypesNonErased = null;
            this.myArgumentTypes = null;
        }
        this.myAccessorProcessors = this.calcAccessorProcessors();
    }

    private List<PsiScopeProcessor> calcAccessorProcessors() {
        if (this.isPropertyResolve()) {
            if (this.myIsLValue) {
                return Collections.singletonList(this.accessorProcessor(GroovyPropertyUtils.getSetterName(this.myName)));
            }
            return ContainerUtil.newArrayList((Object[])new PsiScopeProcessor[]{this.accessorProcessor(GroovyPropertyUtils.getGetterNameNonBoolean(this.myName)), this.accessorProcessor(GroovyPropertyUtils.getGetterNameBoolean(this.myName))});
        }
        return Collections.emptyList();
    }

    private GrScopeProcessorWithHints accessorProcessor(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor", "accessorProcessor"));
        }
        return new GrScopeProcessorWithHints(name, GroovyResolveKind.METHOD.declarationKinds){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor$3", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor$3", "execute"));
                }
                return !AccessorResolverProcessor.checkAccessor(element, state, GroovyResolverProcessor.this.myName, !GroovyResolverProcessor.this.myIsLValue) || GroovyResolverProcessor.this.execute(element, state);
            }
        };
    }

    public boolean isPropertyResolve() {
        return this.myAcceptableKinds.contains((Object)GroovyResolveKind.PROPERTY);
    }

    public static List<PsiScopeProcessor> allProcessors(PsiScopeProcessor processor) {
        List<PsiScopeProcessor> accessors;
        if (processor instanceof GroovyResolverProcessor && !((GroovyResolverProcessor)processor).myStopExecutingMethods && !(accessors = ((GroovyResolverProcessor)processor).myAccessorProcessors).isEmpty()) {
            return ContainerUtil.concat(Collections.singletonList(processor), accessors);
        }
        return Collections.singletonList(processor);
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        GroovyResolveResultImpl candidate;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor", "execute"));
        }
        if (!(element instanceof PsiNamedElement)) {
            return true;
        }
        PsiNamedElement namedElement = (PsiNamedElement)element;
        PsiElement resolveContext = (PsiElement)state.get(ClassHint.RESOLVE_CONTEXT);
        GroovyResolveKind kind = this.computeKindAndCheckName(namedElement, resolveContext);
        if (!this.myAcceptableKinds.contains((Object)kind)) {
            return true;
        }
        if (kind == GroovyResolveKind.METHOD && this.myStopExecutingMethods) {
            return true;
        }
        if (kind != GroovyResolveKind.PROPERTY && kind != GroovyResolveKind.METHOD && !this.myCandidates.get((Object)kind).isEmpty()) {
            return true;
        }
        PsiSubstitutor substitutor = GroovyResolverProcessor.getSubstitutor(state);
        SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
        boolean isAccessible = ResolveUtil.isAccessible(this.myRef, namedElement);
        boolean isStaticsOK = ResolveUtil.isStaticsOK(this.myRef, namedElement, resolveContext, false);
        if (kind == GroovyResolveKind.METHOD || kind == GroovyResolveKind.PROPERTY) {
            PsiMethod method = (PsiMethod)namedElement;
            boolean isApplicable = kind == GroovyResolveKind.PROPERTY || PsiUtil.isApplicable(this.myArgumentTypes, method, null, this.myRef, true);
            NotNullComputable substitutorComputer = kind == GroovyResolveKind.METHOD ? () -> ((SubstitutorComputer)this.myMethodSubstitutorComputer.getValue()).obtainSubstitutor(substitutor, method, resolveContext) : () -> ((SubstitutorComputer)this.myPropertySubstitutorComputer.getValue()).obtainSubstitutor(substitutor, method, resolveContext);
            candidate = new GroovyMethodResult(method, resolveContext, spreadState, substitutor, (NotNullComputable<PsiSubstitutor>)substitutorComputer, kind == GroovyResolveKind.PROPERTY, isAccessible, isStaticsOK, isApplicable);
        } else {
            candidate = new GroovyResolveResultImpl((PsiElement)namedElement, resolveContext, spreadState, substitutor, isAccessible, isStaticsOK, false, true);
        }
        (candidate.isValidResult() ? this.myCandidates : this.myInapplicableCandidates).putValue((Object)kind, (Object)candidate);
        if (candidate.isValidResult() && kind == GroovyResolveKind.VARIABLE) {
            this.myStopExecutingMethods = true;
        }
        return true;
    }

    @Nullable
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor", "getHint"));
        }
        if (hintKey == ElementClassHint.KEY || hintKey == NameHint.KEY) {
            return (T)this;
        }
        return null;
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, @Nullable Object associated) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor", "handleEvent"));
        }
        if (JavaScopeProcessorEvent.CHANGE_LEVEL == event && !this.myCandidates.get((Object)GroovyResolveKind.METHOD).isEmpty()) {
            this.myStopExecutingMethods = true;
        }
    }

    public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
        if (kind == ElementClassHint.DeclarationKind.METHOD) {
            if (this.myStopExecutingMethods) {
                return false;
            }
            if (this.isPropertyResolve() && !this.myAcceptableKinds.contains((Object)GroovyResolveKind.METHOD)) {
                return false;
            }
        }
        for (GroovyResolveKind resolveKind : this.myAcceptableKinds) {
            if (!resolveKind.declarationKinds.contains(kind)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String getName(@NotNull ResolveState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor", "getName"));
        }
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor", "getName"));
        }
        return string;
    }

    @NotNull
    public abstract List<GroovyResolveResult> getCandidates();

    public final GroovyResolveResult[] getCandidatesArray() {
        List<GroovyResolveResult> candidates = this.getCandidates();
        int size = candidates.size();
        if (size == 0) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        if (size == 1) {
            return new GroovyResolveResult[]{candidates.get(0)};
        }
        return candidates.toArray(new GroovyResolveResult[size]);
    }

    private GroovyResolveKind computeKindAndCheckName(PsiNamedElement element, PsiElement resolveContext) {
        String importedName;
        String string = importedName = resolveContext instanceof GrImportStatement ? ((GrImportStatement)resolveContext).getImportedName() : null;
        if (element instanceof PsiMethod) {
            if (importedName == null) {
                if (this.myIsLValue ? GroovyPropertyUtils.isSimplePropertySetter((PsiMethod)element, this.myName) : GroovyPropertyUtils.isSimplePropertyGetter((PsiMethod)element, this.myName)) {
                    return GroovyResolveKind.PROPERTY;
                }
            } else {
                if (this.myIsLValue ? GroovyPropertyUtils.isSimplePropertySetter((PsiMethod)element, null) && (AccessorResolverProcessor.isAppropriatePropertyNameForSetter(importedName, this.myName) || this.myName.equals(importedName)) : GroovyPropertyUtils.isSimplePropertyGetter((PsiMethod)element, null) && (AccessorResolverProcessor.isAppropriatePropertyNameForGetter((PsiMethod)element, importedName, this.myName) || this.myName.equals(importedName))) {
                    return GroovyResolveKind.PROPERTY;
                }
                if (importedName.equals(GroovyPropertyUtils.getPropertyNameByGetterName(this.myName, true)) || importedName.equals(GroovyPropertyUtils.getPropertyNameBySetterName(this.myName))) {
                    return GroovyResolveKind.METHOD;
                }
            }
        }
        if (importedName == null) {
            if (element instanceof PsiClass) {
                return GroovyResolveKind.CLASS;
            }
            if (element instanceof PsiPackage) {
                return GroovyResolveKind.PACKAGE;
            }
            if (element instanceof PsiMethod) {
                return GroovyResolveKind.METHOD;
            }
            if (element instanceof PsiField) {
                return GroovyResolveKind.FIELD;
            }
            if (element instanceof GrBindingVariable) {
                return GroovyResolveKind.BINDING;
            }
            if (element instanceof PsiVariable) {
                return GroovyResolveKind.VARIABLE;
            }
        } else if (this.myName.equals(importedName)) {
            if (element instanceof PsiClass) {
                return GroovyResolveKind.CLASS;
            }
            if (element instanceof PsiMethod) {
                return GroovyResolveKind.METHOD;
            }
            if (element instanceof PsiField) {
                return GroovyResolveKind.FIELD;
            }
        }
        return null;
    }

    @NotNull
    protected List<GroovyResolveResult> getCandidates(GroovyResolveKind ... kinds) {
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor", "getCandidates"));
        }
        List results = ContainerUtil.newSmartList();
        for (GroovyResolveKind kind : kinds) {
            results.addAll(this.myCandidates.get((Object)kind));
        }
        List list = results;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor", "getCandidates"));
        }
        return list;
    }

    @NotNull
    protected static PsiSubstitutor getSubstitutor(@NotNull ResolveState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor", "getSubstitutor"));
        }
        PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
        if (substitutor == null) {
            substitutor = PsiSubstitutor.EMPTY;
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor", "getSubstitutor"));
        }
        return psiSubstitutor;
    }

    @NotNull
    private static String getReferenceName(@NotNull GrReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor", "getReferenceName"));
        }
        String name = ref.getReferenceName();
        assert (name != null) : "Reference name cannot be null";
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessor", "getReferenceName"));
        }
        return string;
    }

    @Nullable
    private static PsiType[] eraseTypes(@Nullable PsiType[] types) {
        PsiType[] erasedTypes;
        PsiType[] psiTypeArray = erasedTypes = types == null ? null : Arrays.copyOf(types, types.length);
        if (erasedTypes != null) {
            for (int i = 0; i < types.length; ++i) {
                erasedTypes[i] = TypeConversionUtil.erasure((PsiType)erasedTypes[i]);
            }
        }
        return erasedTypes;
    }
}

