/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerProviders;
import com.intellij.codeInsight.daemon.LineMarkerSettings;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.LineMarkersProcessor;
import com.intellij.codeInsight.daemon.impl.LineMarkersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineMarkersPass
extends TextEditorHighlightingPass
implements LineMarkersProcessor,
DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.LineMarkersPass");
    private volatile Collection<LineMarkerInfo> myMarkers;
    @NotNull
    private final PsiFile myFile;
    @Nullable
    private final Editor myEditor;
    @NotNull
    private final TextRange myBounds;

    LineMarkersPass(@NotNull Project project2, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull Document document, @NotNull TextRange bounds) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "<init>"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "<init>"));
        }
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "<init>"));
        }
        super(project2, document, false);
        this.myMarkers = Collections.emptyList();
        this.myFile = file2;
        this.myEditor = editor;
        this.myBounds = bounds;
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = super.getDocument();
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "getDocument"));
        }
        return document;
    }

    @Override
    public void doApplyInformationToEditor() {
        try {
            LineMarkersUtil.setLineMarkersToEditor(this.myProject, this.getDocument(), (Segment)this.myBounds, this.myMarkers, 4);
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "doCollectInformation"));
        }
        ArrayList<LineMarkerInfo> lineMarkers = new ArrayList<LineMarkerInfo>();
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        Set relevantLanguages = viewProvider.getLanguages();
        for (Language language : relevantLanguages) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (!HighlightingLevelManager.getInstance(this.myProject).shouldHighlight((PsiElement)psiRoot)) continue;
            List<PsiElement> elements = CollectHighlightsUtil.getElementsInRange((PsiElement)psiRoot, this.myBounds.getStartOffset(), this.myBounds.getEndOffset());
            if (elements.isEmpty()) {
                elements = Collections.singletonList(psiRoot);
            }
            List<LineMarkerProvider> providers = LineMarkersPass.getMarkerProviders(language, this.myProject);
            this.addLineMarkers(elements, providers, lineMarkers, progress);
            LineMarkersPass.collectLineMarkersForInjected(lineMarkers, elements, this, this.myFile, progress);
        }
        this.myMarkers = LineMarkersPass.mergeLineMarkers(lineMarkers, this.myEditor);
    }

    static List<LineMarkerInfo> mergeLineMarkers(@NotNull List<LineMarkerInfo> markers, @Nullable Editor editor) {
        if (markers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markers", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "mergeLineMarkers"));
        }
        ArrayList<MergeableLineMarkerInfo> forMerge = new ArrayList<MergeableLineMarkerInfo>();
        Iterator<LineMarkerInfo> iterator = markers.iterator();
        while (iterator.hasNext()) {
            LineMarkerInfo marker = iterator.next();
            if (!(marker instanceof MergeableLineMarkerInfo)) continue;
            iterator.remove();
            forMerge.add((MergeableLineMarkerInfo)marker);
        }
        if (forMerge.isEmpty() || editor == null) {
            return markers;
        }
        ArrayList<LineMarkerInfo> result = new ArrayList<LineMarkerInfo>(markers);
        TIntObjectHashMap sameLineMarkers = new TIntObjectHashMap();
        for (MergeableLineMarkerInfo info : forMerge) {
            int line = editor.getDocument().getLineNumber(info.startOffset);
            ArrayList<MergeableLineMarkerInfo> infos = (ArrayList<MergeableLineMarkerInfo>)sameLineMarkers.get(line);
            if (infos == null) {
                infos = new ArrayList<MergeableLineMarkerInfo>();
                sameLineMarkers.put(line, infos);
            }
            infos.add(info);
        }
        for (Object v : sameLineMarkers.getValues()) {
            List infos = (List)v;
            result.addAll(MergeableLineMarkerInfo.merge((List)infos));
        }
        return result;
    }

    public static List<LineMarkerProvider> getMarkerProviders(@NotNull Language language, @NotNull Project project2) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "getMarkerProviders"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "getMarkerProviders"));
        }
        List forLanguage = LineMarkerProviders.INSTANCE.allForLanguageOrAny(language);
        List providers = DumbService.getInstance((Project)project2).filterByDumbAwareness((Collection)forLanguage);
        final LineMarkerSettings settings = LineMarkerSettings.getSettings();
        return ContainerUtil.filter((Collection)providers, (Condition)new Condition<LineMarkerProvider>(){

            public boolean value(LineMarkerProvider provider) {
                if (!(provider instanceof LineMarkerProviderDescriptor)) {
                    return true;
                }
                return settings.isEnabled((GutterIconDescriptor)((LineMarkerProviderDescriptor)provider));
            }
        });
    }

    @Override
    public void addLineMarkers(@NotNull List<PsiElement> elements, @NotNull List<LineMarkerProvider> providers, @NotNull List<LineMarkerInfo> result, @NotNull ProgressIndicator progress) throws ProcessCanceledException {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "addLineMarkers"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "addLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "addLineMarkers"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "addLineMarkers"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int elementsSize = elements.size();
        for (int i = 0; i < elementsSize; ++i) {
            PsiElement element = elements.get(i);
            progress.checkCanceled();
            int providersSize = providers.size();
            for (int j = 0; j < providersSize; ++j) {
                LineMarkerInfo info;
                LineMarkerProvider provider = providers.get(j);
                try {
                    info = provider.getLineMarkerInfo(element);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (IndexNotReadyException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    continue;
                }
                if (info == null) continue;
                result.add(info);
            }
        }
    }

    static void collectLineMarkersForInjected(@NotNull List<LineMarkerInfo> result, @NotNull List<PsiElement> elements, @NotNull LineMarkersProcessor processor2, final @NotNull PsiFile file2, @NotNull ProgressIndicator progress) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "collectLineMarkersForInjected"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "collectLineMarkersForInjected"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "collectLineMarkersForInjected"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "collectLineMarkersForInjected"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "collectLineMarkersForInjected"));
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)file2.getProject());
        ArrayList<LineMarkerInfo> injectedMarkers = new ArrayList<LineMarkerInfo>();
        THashSet injectedFiles = new THashSet();
        final PsiLanguageInjectionHost.InjectedPsiVisitor collectingVisitor = new PsiLanguageInjectionHost.InjectedPsiVisitor((Set)injectedFiles){
            final /* synthetic */ Set val$injectedFiles;
            {
                this.val$injectedFiles = set;
            }

            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                if (injectedPsi == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/codeInsight/daemon/impl/LineMarkersPass$2", "visit"));
                }
                if (places == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/codeInsight/daemon/impl/LineMarkersPass$2", "visit"));
                }
                this.val$injectedFiles.add(injectedPsi);
            }
        };
        InjectedLanguageManagerImpl.getInstanceImpl(file2.getProject()).processInjectableElements(elements, new Processor<PsiElement>(){

            public boolean process(PsiElement element) {
                InjectedLanguageUtil.enumerate(element, file2, false, collectingVisitor);
                return true;
            }
        });
        for (PsiFile injectedPsi : injectedFiles) {
            Project project2 = injectedPsi.getProject();
            Document document = PsiDocumentManager.getInstance((Project)project2).getCachedDocument(injectedPsi);
            if (!(document instanceof DocumentWindow)) {
                return;
            }
            List<PsiElement> injElements = CollectHighlightsUtil.getElementsInRange((PsiElement)injectedPsi, 0, injectedPsi.getTextLength());
            List<LineMarkerProvider> providers = LineMarkersPass.getMarkerProviders(injectedPsi.getLanguage(), project2);
            processor2.addLineMarkers(injElements, providers, injectedMarkers, progress);
            for (final LineMarkerInfo injectedMarker : injectedMarkers) {
                GutterIconRenderer gutterRenderer = injectedMarker.createGutterRenderer();
                TextRange injectedRange = new TextRange(injectedMarker.startOffset, injectedMarker.endOffset);
                List editables = manager.intersectWithAllEditableFragments(injectedPsi, injectedRange);
                for (TextRange editable : editables) {
                    TextRange hostRange = manager.injectedToHost((PsiElement)injectedPsi, editable);
                    Icon icon = gutterRenderer == null ? null : gutterRenderer.getIcon();
                    LineMarkerInfo converted = new LineMarkerInfo(injectedMarker.getElement(), hostRange, icon, injectedMarker.updatePass, (Function)new Function<PsiElement, String>(){

                        public String fun(PsiElement element) {
                            return injectedMarker.getLineMarkerTooltip();
                        }
                    }, injectedMarker.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
                    result.add(converted);
                }
            }
            injectedMarkers.clear();
        }
    }

    @NotNull
    public static Collection<LineMarkerInfo> queryLineMarkers(@NotNull PsiFile file2, @NotNull Document document) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "queryLineMarkers"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "queryLineMarkers"));
        }
        if (file2.getNode() == null) {
            List<LineMarkerInfo> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "queryLineMarkers"));
            }
            return list;
        }
        LineMarkersPass pass = new LineMarkersPass(file2.getProject(), file2, null, document, file2.getTextRange());
        pass.doCollectInformation((ProgressIndicator)new EmptyProgressIndicator());
        Collection<LineMarkerInfo> collection = pass.myMarkers;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "queryLineMarkers"));
        }
        return collection;
    }

    @NotNull
    public static LineMarkerInfo createMethodSeparatorLineMarker(@NotNull PsiElement startFrom, @NotNull EditorColorsManager colorsManager) {
        if (startFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startFrom", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "createMethodSeparatorLineMarker"));
        }
        if (colorsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsManager", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "createMethodSeparatorLineMarker"));
        }
        LineMarkerInfo info = new LineMarkerInfo(startFrom, startFrom.getTextRange(), null, 4, (Function)FunctionUtil.nullConstant(), null, GutterIconRenderer.Alignment.RIGHT);
        EditorColorsScheme scheme = colorsManager.getGlobalScheme();
        info.separatorColor = scheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        info.separatorPlacement = SeparatorPlacement.TOP;
        LineMarkerInfo lineMarkerInfo = info;
        if (lineMarkerInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/LineMarkersPass", "createMethodSeparatorLineMarker"));
        }
        return lineMarkerInfo;
    }
}

