/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowErrorDescriptionHandler;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class ShowErrorDescriptionAction
extends BaseCodeInsightAction
implements DumbAware {
    private static int width;
    private static boolean shouldShowDescription;
    private static boolean descriptionShown;

    public ShowErrorDescriptionAction() {
        this.setEnabledInModalContext(true);
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        ShowErrorDescriptionHandler showErrorDescriptionHandler = new ShowErrorDescriptionHandler(shouldShowDescription ? width : 0);
        if (showErrorDescriptionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/ShowErrorDescriptionAction", "getHandler"));
        }
        return showErrorDescriptionHandler;
    }

    protected boolean isValidForFile(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/actions/ShowErrorDescriptionAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/actions/ShowErrorDescriptionAction", "isValidForFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/actions/ShowErrorDescriptionAction", "isValidForFile"));
        }
        return DaemonCodeAnalyzer.getInstance((Project)project2).isHighlightingAvailable(file2) && ShowErrorDescriptionAction.isEnabledForFile(project2, editor, file2);
    }

    private static boolean isEnabledForFile(Project project2, Editor editor, PsiFile file2) {
        DaemonCodeAnalyzer codeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)project2);
        HighlightInfo info = ((DaemonCodeAnalyzerImpl)codeAnalyzer).findHighlightByOffset(editor.getDocument(), editor.getCaretModel().getOffset(), false);
        return info != null && info.getDescription() != null;
    }

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/actions/ShowErrorDescriptionAction", "beforeActionPerformedUpdate"));
        }
        super.beforeActionPerformedUpdate(e);
        ShowErrorDescriptionAction.changeState();
    }

    private static void changeState() {
        if (Comparing.strEqual((String)ActionManagerEx.getInstanceEx().getPrevPreformedActionId(), (String)"ShowErrorDescription")) {
            shouldShowDescription = descriptionShown;
        } else {
            shouldShowDescription = false;
            descriptionShown = true;
        }
    }

    public static void rememberCurrentWidth(int currentWidth) {
        width = currentWidth;
        descriptionShown = !shouldShowDescription;
    }

    static {
        shouldShowDescription = false;
        descriptionShown = true;
    }
}

