/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.embedding;

import com.intellij.embedding.MasqueradingLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IndentEatingLexer
extends MasqueradingLexer.SmartDelegate {
    private final int myIndent;
    @NotNull
    private CharSequence myBuffer;
    @NotNull
    private List<DeletedIndentInfo> myDeletions;
    private int myCurrentDelta;
    private int myTotalDelta;
    private int myCurrentDelIndex;

    public IndentEatingLexer(@NotNull Lexer delegate, int baseIndent) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/embedding/IndentEatingLexer", "<init>"));
        }
        super(delegate);
        this.myIndent = baseIndent;
        this.myBuffer = "";
        this.myDeletions = Collections.emptyList();
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/embedding/IndentEatingLexer", "start"));
        }
        this.myBuffer = buffer;
        this.myDeletions = this.findAllDeletions(buffer, startOffset, endOffset);
        this.myCurrentDelta = 0;
        this.myTotalDelta = 0;
        if (this.myDeletions.isEmpty()) {
            super.start(buffer, startOffset, endOffset, initialState);
            return;
        }
        CharSequence newSequence = this.deleteIndents(buffer, startOffset, endOffset);
        super.start(newSequence, 0, newSequence.length(), initialState);
        this.myTotalDelta = startOffset;
        this.myCurrentDelIndex = 0;
        this.updateDeltas();
    }

    private void updateDeltas() {
        DeletedIndentInfo info;
        this.myTotalDelta += this.myCurrentDelta;
        this.myCurrentDelta = 0;
        while (this.myCurrentDelIndex < this.myDeletions.size() && (info = this.myDeletions.get(this.myCurrentDelIndex)).getShrunkPos() >= super.getTokenStart() && info.getShrunkPos() <= super.getTokenEnd()) {
            this.myCurrentDelta += info.getLength();
            ++this.myCurrentDelIndex;
        }
    }

    public void advance() {
        super.advance();
        this.updateDeltas();
    }

    public int getTokenStart() {
        return super.getTokenStart() + this.myTotalDelta;
    }

    public int getTokenEnd() {
        return super.getTokenEnd() + this.myTotalDelta + this.myCurrentDelta;
    }

    @NotNull
    public String getTokenText() {
        String string = this.myBuffer.subSequence(this.getTokenStart(), this.getTokenEnd()).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/embedding/IndentEatingLexer", "getTokenText"));
        }
        return string;
    }

    @NotNull
    private List<DeletedIndentInfo> findAllDeletions(@NotNull CharSequence buffer, int startOffset, int endOffset) {
        int newline;
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/embedding/IndentEatingLexer", "findAllDeletions"));
        }
        ArrayList<DeletedIndentInfo> result = new ArrayList<DeletedIndentInfo>();
        int offset = startOffset;
        while (offset < endOffset && (newline = StringUtil.indexOf((CharSequence)buffer, (char)'\n', (int)offset, (int)endOffset)) >= 0) {
            char c;
            int charsToDelete;
            for (charsToDelete = 0; charsToDelete < this.myIndent && newline + charsToDelete + 1 < endOffset && (c = buffer.charAt(newline + charsToDelete + 1)) != '\n' && Character.isWhitespace(c); ++charsToDelete) {
            }
            if (charsToDelete > 0) {
                result.add(new DeletedIndentInfo(newline + 1, charsToDelete));
            }
            offset = newline + charsToDelete + 1;
        }
        ArrayList<DeletedIndentInfo> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/embedding/IndentEatingLexer", "findAllDeletions"));
        }
        return arrayList;
    }

    @NotNull
    private CharSequence deleteIndents(@NotNull CharSequence buffer, int startOffset, int endOffset) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/embedding/IndentEatingLexer", "deleteIndents"));
        }
        StringBuilder result = new StringBuilder();
        int offset = startOffset;
        for (DeletedIndentInfo deletion : this.myDeletions) {
            result.append(buffer.subSequence(offset, deletion.getRealPos()));
            deletion.setShrunkPos(result.length());
            offset = deletion.getRealPos() + deletion.getLength();
        }
        result.append(buffer.subSequence(offset, endOffset));
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/embedding/IndentEatingLexer", "deleteIndents"));
        }
        return string;
    }

    private static class DeletedIndentInfo {
        private final int realPos;
        private final int length;
        private int shrunkPos;

        public DeletedIndentInfo(int realPos, int length) {
            this.realPos = realPos;
            this.length = length;
            this.shrunkPos = -1;
        }

        public void setShrunkPos(int shrunkPos) {
            this.shrunkPos = shrunkPos;
        }

        public int getRealPos() {
            return this.realPos;
        }

        public int getLength() {
            return this.length;
        }

        public int getShrunkPos() {
            return this.shrunkPos;
        }
    }
}

