/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.find.FindSettings;
import com.intellij.find.SearchTextArea;
import com.intellij.find.editorHeaderActions.ContextAwareShortcutProvider;
import com.intellij.find.editorHeaderActions.ShowMoreOptions;
import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.find.editorHeaderActions.VariantsCompletionAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.LightColors;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchReplaceComponent
extends EditorHeaderComponent
implements DataProvider {
    private final EventDispatcher<Listener> myEventDispatcher;
    private final MyTextComponentWrapper mySearchFieldWrapper;
    private JTextComponent mySearchTextComponent;
    private final MyTextComponentWrapper myReplaceFieldWrapper;
    private JTextComponent myReplaceTextComponent;
    private final JPanel myLeftPanel;
    private final JPanel myRightPanel;
    private final DefaultActionGroup mySearchFieldActions;
    private final ActionToolbarImpl mySearchActionsToolbar1;
    private final ActionToolbarImpl mySearchActionsToolbar2;
    private final ActionToolbarImpl.PopupStateModifier mySearchToolbar1PopupStateModifier;
    private final DefaultActionGroup myReplaceFieldActions;
    private final ActionToolbarImpl myReplaceActionsToolbar1;
    private final ActionToolbarImpl myReplaceActionsToolbar2;
    private final JPanel myReplaceToolbarWrapper;
    private final Project myProject;
    private final JComponent myTargetComponent;
    private final Runnable myCloseAction;
    private final Runnable myReplaceAction;
    private final DataProvider myDataProviderDelegate;
    private boolean myMultilineMode;
    private String myStatusText;

    @NotNull
    public static Builder buildFor(@Nullable Project project2, @NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/find/SearchReplaceComponent", "buildFor"));
        }
        Builder builder = new Builder(project2, component);
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent", "buildFor"));
        }
        return builder;
    }

    private SearchReplaceComponent(@Nullable Project project2, @NotNull JComponent targetComponent, @NotNull DefaultActionGroup searchToolbar1Actions, final @NotNull BooleanGetter searchToolbar1ModifiedFlagGetter, @NotNull DefaultActionGroup searchToolbar2Actions, @NotNull DefaultActionGroup searchFieldActions, @NotNull DefaultActionGroup replaceToolbar1Actions, @NotNull DefaultActionGroup replaceToolbar2Actions, @NotNull DefaultActionGroup replaceFieldActions, @Nullable Runnable replaceAction, @Nullable Runnable closeAction, @Nullable DataProvider dataProvider) {
        if (targetComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetComponent", "com/intellij/find/SearchReplaceComponent", "<init>"));
        }
        if (searchToolbar1Actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchToolbar1Actions", "com/intellij/find/SearchReplaceComponent", "<init>"));
        }
        if (searchToolbar1ModifiedFlagGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchToolbar1ModifiedFlagGetter", "com/intellij/find/SearchReplaceComponent", "<init>"));
        }
        if (searchToolbar2Actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchToolbar2Actions", "com/intellij/find/SearchReplaceComponent", "<init>"));
        }
        if (searchFieldActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchFieldActions", "com/intellij/find/SearchReplaceComponent", "<init>"));
        }
        if (replaceToolbar1Actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replaceToolbar1Actions", "com/intellij/find/SearchReplaceComponent", "<init>"));
        }
        if (replaceToolbar2Actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replaceToolbar2Actions", "com/intellij/find/SearchReplaceComponent", "<init>"));
        }
        if (replaceFieldActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replaceFieldActions", "com/intellij/find/SearchReplaceComponent", "<init>"));
        }
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        this.myStatusText = "";
        this.myProject = project2;
        this.myTargetComponent = targetComponent;
        this.mySearchFieldActions = searchFieldActions;
        this.myReplaceFieldActions = replaceFieldActions;
        this.myReplaceAction = replaceAction;
        this.myCloseAction = closeAction;
        this.mySearchToolbar1PopupStateModifier = new ActionToolbarImpl.PopupStateModifier(){

            @Override
            public int getModifiedPopupState() {
                return -1;
            }

            @Override
            public boolean willModify() {
                return searchToolbar1ModifiedFlagGetter.get();
            }
        };
        this.mySearchFieldWrapper = new MyTextComponentWrapper(){

            public void setContent(JComponent wrapped) {
                super.setContent(wrapped);
                SearchReplaceComponent.this.mySearchTextComponent = 2.unwrapTextComponent(wrapped);
            }
        };
        this.myReplaceFieldWrapper = new MyTextComponentWrapper(){

            public void setContent(JComponent wrapped) {
                super.setContent(wrapped);
                SearchReplaceComponent.this.myReplaceTextComponent = 3.unwrapTextComponent(wrapped);
            }
        };
        this.myLeftPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        this.myLeftPanel.add((Component)((Object)this.mySearchFieldWrapper), "North");
        this.myLeftPanel.add((Component)((Object)this.myReplaceFieldWrapper), "Center");
        this.mySearchActionsToolbar1 = this.createSearchToolbar1(searchToolbar1Actions);
        NonOpaquePanel searchToolbarWrapper1 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        searchToolbarWrapper1.add((Component)this.mySearchActionsToolbar1, (Object)"West");
        this.mySearchActionsToolbar2 = this.createSearchToolbar2(searchToolbar2Actions);
        Wrapper searchToolbarWrapper2 = new Wrapper((JComponent)this.mySearchActionsToolbar2);
        this.mySearchActionsToolbar2.setBorder((Border)JBUI.Borders.emptyLeft((int)16));
        Wrapper searchPair = new NonOpaquePanel((LayoutManager)new BorderLayout()).setVerticalSizeReferent((JComponent)((Object)this.mySearchFieldWrapper));
        searchPair.add((Component)searchToolbarWrapper1, "West");
        searchPair.add((Component)searchToolbarWrapper2, "Center");
        this.myReplaceActionsToolbar1 = this.createReplaceToolbar1(replaceToolbar1Actions);
        Wrapper replaceToolbarWrapper1 = new Wrapper((JComponent)this.myReplaceActionsToolbar1).setVerticalSizeReferent((JComponent)((Object)this.myReplaceFieldWrapper));
        this.myReplaceActionsToolbar2 = this.createReplaceToolbar2(replaceToolbar2Actions);
        Wrapper replaceToolbarWrapper2 = new Wrapper((JComponent)this.myReplaceActionsToolbar2).setVerticalSizeReferent((JComponent)((Object)this.myReplaceFieldWrapper));
        this.myReplaceActionsToolbar2.setBorder((Border)JBUI.Borders.emptyLeft((int)16));
        this.myReplaceToolbarWrapper = new NonOpaquePanel((LayoutManager)new BorderLayout());
        this.myReplaceToolbarWrapper.add((Component)replaceToolbarWrapper1, "West");
        this.myReplaceToolbarWrapper.add((Component)replaceToolbarWrapper2, "Center");
        searchToolbarWrapper1.setHorizontalSizeReferent((JComponent)replaceToolbarWrapper1);
        JLabel closeLabel = new JLabel(null, AllIcons.Actions.Cross, 4);
        closeLabel.setBorder(JBUI.Borders.empty((int)5));
        closeLabel.setVerticalAlignment(1);
        closeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SearchReplaceComponent.this.close();
            }
        });
        closeLabel.setToolTipText("Close search bar (Escape)");
        searchPair.add((Component)new Wrapper.North((JComponent)closeLabel), "East");
        this.myRightPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        this.myRightPanel.add((Component)searchPair, "North");
        this.myRightPanel.add((Component)this.myReplaceToolbarWrapper, "Center");
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.25f);
        splitter.setFirstComponent((JComponent)this.myLeftPanel);
        splitter.setSecondComponent((JComponent)this.myRightPanel);
        splitter.setHonorComponentsMinimumSize(true);
        splitter.setAndLoadSplitterProportionKey("FindSplitterProportion");
        splitter.setOpaque(false);
        splitter.getDivider().setOpaque(false);
        this.add((Component)splitter, "Center");
        this.update("", "", false, false);
        this.myDataProviderDelegate = dataProvider;
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
    }

    public void resetUndoRedoActions() {
        UIUtil.resetUndoRedoActions((JTextComponent)this.mySearchTextComponent);
        UIUtil.resetUndoRedoActions((JTextComponent)this.myReplaceTextComponent);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.addTextToRecent(this.mySearchTextComponent);
        if (this.myReplaceTextComponent != null) {
            this.addTextToRecent(this.myReplaceTextComponent);
        }
    }

    public void requestFocusInTheSearchFieldAndSelectContent(Project project2) {
        this.mySearchTextComponent.setSelectionStart(0);
        this.mySearchTextComponent.setSelectionEnd(this.mySearchTextComponent.getText().length());
        IdeFocusManager.getInstance((Project)project2).requestFocus((Component)this.mySearchTextComponent, true);
    }

    public void setStatusText(@NotNull String status) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/find/SearchReplaceComponent", "setStatusText"));
        }
        this.myStatusText = status;
    }

    @NotNull
    public String getStatusText() {
        String string = this.myStatusText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent", "getStatusText"));
        }
        return string;
    }

    public void replace() {
        if (this.myReplaceAction != null) {
            this.myReplaceAction.run();
        }
    }

    public void close() {
        if (this.myCloseAction != null) {
            this.myCloseAction.run();
        }
    }

    public void setRegularBackground() {
        this.mySearchTextComponent.setBackground(UIUtil.getTextFieldBackground());
    }

    public void setNotFoundBackground() {
        this.mySearchTextComponent.setBackground(LightColors.RED);
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        if (UIUtil.isUnderGTKLookAndFeel() || UIUtil.isUnderNimbusLookAndFeel()) {
            ++insets.top;
            insets.bottom += 2;
        }
        return insets;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (SpeedSearchSupply.SPEED_SEARCH_CURRENT_QUERY.is(dataId)) {
            return this.mySearchTextComponent.getText();
        }
        return this.myDataProviderDelegate != null ? this.myDataProviderDelegate.getData(dataId) : null;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void addListener(@NotNull Listener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/find/SearchReplaceComponent", "addListener"));
        }
        this.myEventDispatcher.addListener((EventListener)listener2);
    }

    public boolean isMultiline() {
        return this.myMultilineMode;
    }

    private void setMultilineInternal(boolean multiline) {
        boolean stateChanged = multiline != this.myMultilineMode;
        this.myMultilineMode = multiline;
        if (stateChanged) {
            this.multilineStateChanged();
        }
    }

    @NotNull
    public JTextComponent getSearchTextComponent() {
        JTextComponent jTextComponent = this.mySearchTextComponent;
        if (jTextComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent", "getSearchTextComponent"));
        }
        return jTextComponent;
    }

    @NotNull
    public JTextComponent getReplaceTextComponent() {
        JTextComponent jTextComponent = this.myReplaceTextComponent;
        if (jTextComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent", "getReplaceTextComponent"));
        }
        return jTextComponent;
    }

    private void updateSearchComponent(@NotNull String textToSet) {
        boolean wasNull;
        if (textToSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textToSet", "com/intellij/find/SearchReplaceComponent", "updateSearchComponent"));
        }
        final int oldCaretPosition = this.mySearchTextComponent != null ? this.mySearchTextComponent.getCaretPosition() : 0;
        boolean bl = wasNull = this.mySearchTextComponent == null;
        if (!this.updateTextComponent(true)) {
            if (!this.mySearchTextComponent.getText().equals(textToSet)) {
                this.mySearchTextComponent.setText(textToSet);
            }
            return;
        }
        if (!this.mySearchTextComponent.getText().equals(textToSet)) {
            this.mySearchTextComponent.setText(textToSet);
            if (wasNull) {
                this.mySearchTextComponent.selectAll();
            }
        }
        this.mySearchTextComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SearchReplaceComponent.this.searchFieldDocumentChanged();
                    }
                });
            }
        });
        this.mySearchTextComponent.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtil.isEmpty((String)SearchReplaceComponent.this.mySearchTextComponent.getText())) {
                    SearchReplaceComponent.this.close();
                } else {
                    IdeFocusManager.getInstance((Project)SearchReplaceComponent.this.myProject).requestFocus((Component)SearchReplaceComponent.this.myTargetComponent, true);
                    SearchReplaceComponent.this.addTextToRecent(SearchReplaceComponent.this.mySearchTextComponent);
                }
            }
        }, KeyStroke.getKeyStroke(10, SystemInfo.isMac ? 256 : 128), 0);
        if (!wasNull) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchReplaceComponent.this.mySearchTextComponent.setCaretPosition(Math.min(oldCaretPosition, SearchReplaceComponent.this.mySearchTextComponent.getText().length()));
                }
            });
        }
        new VariantsCompletionAction(this.mySearchTextComponent);
    }

    private void updateReplaceComponent(@NotNull String textToSet) {
        int oldCaretPosition;
        if (textToSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textToSet", "com/intellij/find/SearchReplaceComponent", "updateReplaceComponent"));
        }
        int n = oldCaretPosition = this.myReplaceTextComponent != null ? this.myReplaceTextComponent.getCaretPosition() : 0;
        if (!this.updateTextComponent(false)) {
            return;
        }
        this.myReplaceTextComponent.setText(textToSet);
        this.myReplaceTextComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SearchReplaceComponent.this.replaceFieldDocumentChanged();
                    }
                });
            }
        });
        if (!this.isMultiline()) {
            this.installReplaceOnEnterAction(this.myReplaceTextComponent);
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchReplaceComponent.this.myReplaceTextComponent.setCaretPosition(oldCaretPosition);
            }
        });
        new VariantsCompletionAction(this.myReplaceTextComponent);
        this.myReplaceFieldWrapper.revalidate();
        this.myReplaceFieldWrapper.repaint();
    }

    public void update(@NotNull String findText, @NotNull String replaceText, boolean replaceMode, boolean multiline) {
        if (findText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findText", "com/intellij/find/SearchReplaceComponent", "update"));
        }
        if (replaceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replaceText", "com/intellij/find/SearchReplaceComponent", "update"));
        }
        this.setMultilineInternal(multiline);
        boolean needToResetSearchFocus = this.mySearchTextComponent != null && this.mySearchTextComponent.hasFocus();
        boolean needToResetReplaceFocus = this.myReplaceTextComponent != null && this.myReplaceTextComponent.hasFocus();
        this.updateSearchComponent(findText);
        this.updateReplaceComponent(replaceText);
        if (replaceMode) {
            if (this.myReplaceFieldWrapper.getParent() == null) {
                this.myLeftPanel.add((Component)((Object)this.myReplaceFieldWrapper), "Center");
            }
            if (this.myReplaceToolbarWrapper.getParent() == null) {
                this.myRightPanel.add((Component)this.myReplaceToolbarWrapper, "Center");
            }
            if (needToResetReplaceFocus) {
                this.myReplaceTextComponent.requestFocusInWindow();
            }
        } else {
            if (this.myReplaceFieldWrapper.getParent() != null) {
                this.myLeftPanel.remove((Component)((Object)this.myReplaceFieldWrapper));
            }
            if (this.myReplaceToolbarWrapper.getParent() != null) {
                this.myRightPanel.remove(this.myReplaceToolbarWrapper);
            }
        }
        if (needToResetSearchFocus) {
            this.mySearchTextComponent.requestFocusInWindow();
        }
        this.updateBindings();
        this.updateActions();
        this.revalidate();
        this.repaint();
    }

    public void updateActions() {
        this.mySearchActionsToolbar1.updateActionsImmediately();
        this.mySearchActionsToolbar2.updateActionsImmediately();
        this.myReplaceActionsToolbar1.updateActionsImmediately();
        this.myReplaceActionsToolbar2.updateActionsImmediately();
    }

    public void addTextToRecent(@NotNull JTextComponent textField) {
        if (textField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textField", "com/intellij/find/SearchReplaceComponent", "addTextToRecent"));
        }
        String text = textField.getText();
        if (text.length() > 0) {
            if (textField == this.mySearchTextComponent) {
                FindSettings.getInstance().addStringToFind(text);
                if (this.mySearchFieldWrapper.getTargetComponent() instanceof SearchTextField) {
                    ((SearchTextField)this.mySearchFieldWrapper.getTargetComponent()).addCurrentTextToHistory();
                }
            } else {
                FindSettings.getInstance().addStringToReplace(text);
                if (this.myReplaceFieldWrapper.getTargetComponent() instanceof SearchTextField) {
                    ((SearchTextField)this.myReplaceFieldWrapper.getTargetComponent()).addCurrentTextToHistory();
                }
            }
        }
    }

    private boolean updateTextComponent(boolean search) {
        JTextComponent textComponent;
        MyTextComponentWrapper wrapper;
        JTextComponent oldComponent = search ? this.mySearchTextComponent : this.myReplaceTextComponent;
        Color oldBackground = oldComponent != null ? oldComponent.getBackground() : null;
        MyTextComponentWrapper myTextComponentWrapper = wrapper = search ? this.mySearchFieldWrapper : this.myReplaceFieldWrapper;
        if (this.isMultiline() && oldComponent instanceof JTextArea) {
            return false;
        }
        if (!this.isMultiline() && oldComponent instanceof JTextField) {
            return false;
        }
        if (this.isMultiline()) {
            SearchTextArea textArea = new SearchTextArea(search);
            textComponent = textArea.getTextArea();
            ((JTextArea)textComponent).setColumns(25);
            ((JTextArea)textComponent).setRows(2);
            wrapper.setContent((JComponent)((Object)textArea));
        } else {
            SearchTextField searchTextField = new SearchTextField(true);
            searchTextField.setOpaque(false);
            textComponent = searchTextField.getTextEditor();
            searchTextField.getTextEditor().setColumns(25);
            if (UIUtil.isUnderGTKLookAndFeel()) {
                textComponent.setOpaque(false);
            }
            searchTextField.setHistorySize(20);
            searchTextField.setHistory(ContainerUtil.reverse(Arrays.asList(search ? FindSettings.getInstance().getRecentFindStrings() : FindSettings.getInstance().getRecentReplaceStrings())));
            textComponent.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final String text = textComponent.getText();
                    SearchReplaceComponent.this.setMultilineInternal(true);
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((JTextComponent)ObjectUtils.assertNotNull((Object)wrapper.getTextComponent())).setText(text + "\n");
                        }
                    });
                }
            }, KeyStroke.getKeyStroke(10, 512), 0);
            wrapper.setContent((JComponent)searchTextField);
        }
        UIUtil.addUndoRedoActions((JTextComponent)textComponent);
        Utils.setSmallerFont(textComponent);
        textComponent.putClientProperty("AuxEditorComponent", Boolean.TRUE);
        if (oldBackground != null) {
            textComponent.setBackground(oldBackground);
        }
        textComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                textComponent.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                textComponent.repaint();
            }
        });
        this.installCloseOnEscapeAction(textComponent);
        return true;
    }

    private void searchFieldDocumentChanged() {
        if (this.mySearchTextComponent instanceof JTextArea) {
            SearchReplaceComponent.adjustRows((JTextArea)this.mySearchTextComponent);
        }
        ((Listener)this.myEventDispatcher.getMulticaster()).searchFieldDocumentChanged();
    }

    private void replaceFieldDocumentChanged() {
        if (this.myReplaceTextComponent instanceof JTextArea) {
            SearchReplaceComponent.adjustRows((JTextArea)this.myReplaceTextComponent);
        }
        ((Listener)this.myEventDispatcher.getMulticaster()).replaceFieldDocumentChanged();
    }

    private void multilineStateChanged() {
        ((Listener)this.myEventDispatcher.getMulticaster()).multilineStateChanged();
    }

    private static void adjustRows(@NotNull JTextArea area) {
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/find/SearchReplaceComponent", "adjustRows"));
        }
        area.setRows(Math.max(2, Math.min(3, StringUtil.countChars((CharSequence)area.getText(), (char)'\n') + 1)));
    }

    private void installCloseOnEscapeAction(@NotNull JTextComponent c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/find/SearchReplaceComponent", "installCloseOnEscapeAction"));
        }
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchReplaceComponent.this.close();
            }
        };
        c.registerKeyboardAction(action, KeyStroke.getKeyStroke(27, 0), 0);
        if (KeymapUtil.isEmacsKeymap()) {
            c.registerKeyboardAction(action, KeyStroke.getKeyStroke(71, 2), 0);
        }
    }

    private void installReplaceOnEnterAction(@NotNull JTextComponent c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/find/SearchReplaceComponent", "installReplaceOnEnterAction"));
        }
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchReplaceComponent.this.replace();
            }
        };
        c.registerKeyboardAction(action, KeyStroke.getKeyStroke(10, 0), 0);
    }

    private void updateBindings() {
        this.updateBindings(this.mySearchFieldActions, (JComponent)((Object)this.mySearchFieldWrapper));
        this.updateBindings(this.mySearchActionsToolbar1, (JComponent)((Object)this.mySearchFieldWrapper));
        this.updateBindings(this.mySearchActionsToolbar2, (JComponent)((Object)this.mySearchFieldWrapper));
        this.updateBindings(this.myReplaceFieldActions, (JComponent)((Object)this.myReplaceFieldWrapper));
        this.updateBindings(this.myReplaceActionsToolbar1, (JComponent)this.myReplaceToolbarWrapper);
        this.updateBindings(this.myReplaceActionsToolbar2, (JComponent)this.myReplaceToolbarWrapper);
    }

    private void updateBindings(@NotNull DefaultActionGroup group, @NotNull JComponent shortcutHolder) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/find/SearchReplaceComponent", "updateBindings"));
        }
        if (shortcutHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcutHolder", "com/intellij/find/SearchReplaceComponent", "updateBindings"));
        }
        this.updateBindings((List<? extends AnAction>)ContainerUtil.immutableList((Object[])group.getChildActionsOrStubs()), shortcutHolder);
    }

    private void updateBindings(@NotNull ActionToolbarImpl toolbar, @NotNull JComponent shortcutHolder) {
        if (toolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolbar", "com/intellij/find/SearchReplaceComponent", "updateBindings"));
        }
        if (shortcutHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcutHolder", "com/intellij/find/SearchReplaceComponent", "updateBindings"));
        }
        this.updateBindings(toolbar.getActions(true), shortcutHolder);
    }

    private void updateBindings(@NotNull List<? extends AnAction> actions, @NotNull JComponent shortcutHolder) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/find/SearchReplaceComponent", "updateBindings"));
        }
        if (shortcutHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcutHolder", "com/intellij/find/SearchReplaceComponent", "updateBindings"));
        }
        DataContext context = DataManager.getInstance().getDataContext((Component)this);
        for (AnAction anAction : actions) {
            ShortcutSet shortcut = null;
            if (anAction instanceof ContextAwareShortcutProvider) {
                shortcut = ((ContextAwareShortcutProvider)anAction).getShortcut(context);
            } else if (anAction instanceof ShortcutProvider) {
                shortcut = ((ShortcutProvider)anAction).getShortcut();
            }
            if (shortcut == null) continue;
            anAction.registerCustomShortcutSet(shortcut, shortcutHolder);
        }
    }

    @NotNull
    private ActionToolbarImpl createSearchToolbar1(@NotNull DefaultActionGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/find/SearchReplaceComponent", "createSearchToolbar1"));
        }
        ActionToolbarImpl toolbar = this.createToolbar((ActionGroup)group);
        toolbar.setForceMinimumSize(true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.setSecondaryButtonPopupStateModifier(this.mySearchToolbar1PopupStateModifier);
        toolbar.setSecondaryActionsTooltip("More Options(" + ShowMoreOptions.SHORT_CUT + ")");
        new ShowMoreOptions(toolbar, (JComponent)((Object)this.mySearchFieldWrapper));
        ActionToolbarImpl actionToolbarImpl = toolbar;
        if (actionToolbarImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent", "createSearchToolbar1"));
        }
        return actionToolbarImpl;
    }

    @NotNull
    private ActionToolbarImpl createSearchToolbar2(@NotNull DefaultActionGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/find/SearchReplaceComponent", "createSearchToolbar2"));
        }
        ActionToolbarImpl actionToolbarImpl = this.createToolbar((ActionGroup)group);
        if (actionToolbarImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent", "createSearchToolbar2"));
        }
        return actionToolbarImpl;
    }

    @NotNull
    private ActionToolbarImpl createReplaceToolbar1(@NotNull DefaultActionGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/find/SearchReplaceComponent", "createReplaceToolbar1"));
        }
        ActionToolbarImpl toolbar = this.createToolbar((ActionGroup)group);
        toolbar.setForceMinimumSize(true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        ActionToolbarImpl actionToolbarImpl = toolbar;
        if (actionToolbarImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent", "createReplaceToolbar1"));
        }
        return actionToolbarImpl;
    }

    @NotNull
    private ActionToolbarImpl createReplaceToolbar2(@NotNull DefaultActionGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/find/SearchReplaceComponent", "createReplaceToolbar2"));
        }
        ActionToolbarImpl actionToolbarImpl = this.createToolbar((ActionGroup)group);
        if (actionToolbarImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent", "createReplaceToolbar2"));
        }
        return actionToolbarImpl;
    }

    @NotNull
    private ActionToolbarImpl createToolbar(@NotNull ActionGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/find/SearchReplaceComponent", "createToolbar"));
        }
        ActionToolbarImpl actionToolbarImpl = this.tweakToolbar((ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("EditorToolbar", group, true));
        if (actionToolbarImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent", "createToolbar"));
        }
        return actionToolbarImpl;
    }

    @NotNull
    private ActionToolbarImpl tweakToolbar(@NotNull ActionToolbarImpl toolbar) {
        if (toolbar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolbar", "com/intellij/find/SearchReplaceComponent", "tweakToolbar"));
        }
        toolbar.setTargetComponent(this);
        toolbar.setLayoutPolicy(2);
        toolbar.setBorder(null);
        toolbar.setOpaque(false);
        Utils.setSmallerFontForChildren(toolbar);
        ActionToolbarImpl actionToolbarImpl = toolbar;
        if (actionToolbarImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent", "tweakToolbar"));
        }
        return actionToolbarImpl;
    }

    private static class MyTextComponentWrapper
    extends Wrapper {
        private MyTextComponentWrapper() {
        }

        @Nullable
        public JTextComponent getTextComponent() {
            JComponent wrapped = this.getTargetComponent();
            return wrapped != null ? MyTextComponentWrapper.unwrapTextComponent(wrapped) : null;
        }

        @NotNull
        protected static JTextComponent unwrapTextComponent(@NotNull JComponent wrapped) {
            if (wrapped == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapped", "com/intellij/find/SearchReplaceComponent$MyTextComponentWrapper", "unwrapTextComponent"));
            }
            if (wrapped instanceof SearchTextField) {
                JTextField jTextField = ((SearchTextField)wrapped).getTextEditor();
                if (jTextField == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent$MyTextComponentWrapper", "unwrapTextComponent"));
                }
                return jTextField;
            }
            if (wrapped instanceof SearchTextArea) {
                JTextArea jTextArea = ((SearchTextArea)((Object)wrapped)).getTextArea();
                if (jTextArea == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent$MyTextComponentWrapper", "unwrapTextComponent"));
                }
                return jTextArea;
            }
            throw new AssertionError();
        }
    }

    public static class Builder {
        private final Project myProject;
        private final JComponent myTargetComponent;
        private DataProvider myDataProvider;
        private Runnable myReplaceAction;
        private Runnable myCloseAction;
        private DefaultActionGroup mySearchActions;
        private DefaultActionGroup myExtraSearchActions;
        private DefaultActionGroup mySearchFieldActions;
        private BooleanGetter mySearchToolbarModifiedFlagGetter;
        private DefaultActionGroup myReplaceActions;
        private DefaultActionGroup myExtraReplaceActions;
        private DefaultActionGroup myReplaceFieldActions;

        private Builder(@Nullable Project project2, @NotNull JComponent component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/find/SearchReplaceComponent$Builder", "<init>"));
            }
            this.mySearchActions = new DefaultActionGroup("search bar 1", false);
            this.myExtraSearchActions = new DefaultActionGroup("search bar 2", false);
            this.mySearchFieldActions = new DefaultActionGroup("search field actions", false);
            this.mySearchToolbarModifiedFlagGetter = BooleanGetter.FALSE;
            this.myReplaceActions = new DefaultActionGroup("replace bar 1", false);
            this.myExtraReplaceActions = new DefaultActionGroup("replace bar 1", false);
            this.myReplaceFieldActions = new DefaultActionGroup("replace field actions", false);
            this.myProject = project2;
            this.myTargetComponent = component;
        }

        @NotNull
        public Builder withDataProvider(@NotNull DataProvider provider) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/find/SearchReplaceComponent$Builder", "withDataProvider"));
            }
            this.myDataProvider = provider;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent$Builder", "withDataProvider"));
            }
            return builder;
        }

        @NotNull
        public Builder withReplaceAction(@NotNull Runnable action) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/find/SearchReplaceComponent$Builder", "withReplaceAction"));
            }
            this.myReplaceAction = action;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent$Builder", "withReplaceAction"));
            }
            return builder;
        }

        @NotNull
        public Builder withCloseAction(@NotNull Runnable action) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/find/SearchReplaceComponent$Builder", "withCloseAction"));
            }
            this.myCloseAction = action;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent$Builder", "withCloseAction"));
            }
            return builder;
        }

        @NotNull
        public Builder addSearchFieldActions(AnAction ... actions) {
            if (actions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/find/SearchReplaceComponent$Builder", "addSearchFieldActions"));
            }
            this.mySearchFieldActions.addAll(actions);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent$Builder", "addSearchFieldActions"));
            }
            return builder;
        }

        @NotNull
        public Builder addReplaceFieldActions(AnAction ... actions) {
            if (actions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/find/SearchReplaceComponent$Builder", "addReplaceFieldActions"));
            }
            this.myReplaceFieldActions.addAll(actions);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent$Builder", "addReplaceFieldActions"));
            }
            return builder;
        }

        @NotNull
        public Builder addPrimarySearchActions(AnAction ... actions) {
            if (actions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/find/SearchReplaceComponent$Builder", "addPrimarySearchActions"));
            }
            this.mySearchActions.addAll(actions);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent$Builder", "addPrimarySearchActions"));
            }
            return builder;
        }

        @NotNull
        public Builder addSecondarySearchActions(AnAction ... actions) {
            if (actions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/find/SearchReplaceComponent$Builder", "addSecondarySearchActions"));
            }
            for (AnAction action : actions) {
                this.mySearchActions.addAction(action).setAsSecondary(true);
            }
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent$Builder", "addSecondarySearchActions"));
            }
            return builder;
        }

        @NotNull
        public Builder withSecondarySearchActionsIsModifiedGetter(@NotNull BooleanGetter getter) {
            if (getter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getter", "com/intellij/find/SearchReplaceComponent$Builder", "withSecondarySearchActionsIsModifiedGetter"));
            }
            this.mySearchToolbarModifiedFlagGetter = getter;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent$Builder", "withSecondarySearchActionsIsModifiedGetter"));
            }
            return builder;
        }

        @NotNull
        public Builder addExtraSearchActions(AnAction ... actions) {
            if (actions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/find/SearchReplaceComponent$Builder", "addExtraSearchActions"));
            }
            this.myExtraSearchActions.addAll(actions);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent$Builder", "addExtraSearchActions"));
            }
            return builder;
        }

        @NotNull
        public Builder addPrimaryReplaceActions(AnAction ... actions) {
            if (actions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/find/SearchReplaceComponent$Builder", "addPrimaryReplaceActions"));
            }
            this.myReplaceActions.addAll(actions);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent$Builder", "addPrimaryReplaceActions"));
            }
            return builder;
        }

        @NotNull
        public Builder addExtraReplaceAction(AnAction ... actions) {
            if (actions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/find/SearchReplaceComponent$Builder", "addExtraReplaceAction"));
            }
            this.myExtraReplaceActions.addAll(actions);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent$Builder", "addExtraReplaceAction"));
            }
            return builder;
        }

        @NotNull
        public SearchReplaceComponent build() {
            SearchReplaceComponent searchReplaceComponent = new SearchReplaceComponent(this.myProject, this.myTargetComponent, this.mySearchActions, this.mySearchToolbarModifiedFlagGetter, this.myExtraSearchActions, this.mySearchFieldActions, this.myReplaceActions, this.myExtraReplaceActions, this.myReplaceFieldActions, this.myReplaceAction, this.myCloseAction, this.myDataProvider);
            if (searchReplaceComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/SearchReplaceComponent$Builder", "build"));
            }
            return searchReplaceComponent;
        }
    }

    public static interface Listener
    extends EventListener {
        public void searchFieldDocumentChanged();

        public void replaceFieldDocumentChanged();

        public void multilineStateChanged();
    }
}

